/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.api;

import java.util.Set;
import java.util.UUID;
import nl.svenar.powerranks.common.structure.PRPermission;
import nl.svenar.powerranks.common.structure.PRPlayer;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRCache;

public class PlayersAPI {
    public PRPlayer get(UUID uuid) {
        return this.get(uuid.toString());
    }

    public PRPlayer get(String identifier) {
        return PRCache.getPlayer(identifier);
    }

    public boolean setName(UUID uuid, String name) {
        return this.setName(uuid.toString(), name);
    }

    public boolean setName(String identifier, String name) {
        return this.setName(this.get(identifier), name);
    }

    public boolean setName(PRPlayer player, String name) {
        if (player == null) {
            return false;
        }
        player.setName(name);
        return true;
    }

    public String getName(UUID uuid) {
        return this.getName(uuid.toString());
    }

    public String getName(String identifier) {
        return this.getName(this.get(identifier));
    }

    public String getName(PRPlayer player) {
        if (player == null) {
            return null;
        }
        return player.getName();
    }

    public boolean setNickName(UUID uuid, String nickname) {
        return this.setNickName(uuid.toString(), nickname);
    }

    public boolean setNickName(String identifier, String nickname) {
        return this.setNickName(this.get(identifier), nickname);
    }

    public boolean setNickName(PRPlayer player, String nickname) {
        if (player == null) {
            return false;
        }
        player.setNickname(nickname);
        return true;
    }

    public String getNickName(UUID uuid) {
        return this.getNickName(uuid.toString());
    }

    public String getNickName(String identifier) {
        return this.getNickName(this.get(identifier));
    }

    public String getNickName(PRPlayer player) {
        if (player == null) {
            return null;
        }
        return player.getNickname();
    }

    public boolean setPlaytime(UUID uuid, long playtime) {
        return this.setPlaytime(uuid.toString(), playtime);
    }

    public boolean setPlaytime(String identifier, long playtime) {
        return this.setPlaytime(this.get(identifier), playtime);
    }

    public boolean setPlaytime(PRPlayer player, long playtime) {
        if (player == null) {
            return false;
        }
        player.setPlaytime(playtime);
        return true;
    }

    public long getPlaytime(UUID uuid) {
        return this.getPlaytime(uuid.toString());
    }

    public long getPlaytime(String identifier) {
        return this.getPlaytime(this.get(identifier));
    }

    public long getPlaytime(PRPlayer player) {
        if (player == null) {
            return -1L;
        }
        return player.getPlaytime();
    }

    public boolean setRank(UUID uuid, String rankname) {
        return this.setRank(uuid.toString(), PRCache.getRank(rankname));
    }

    public boolean setRank(String identifier, String rankname) {
        return this.setRank(this.get(identifier), PRCache.getRank(rankname));
    }

    public boolean setRank(UUID uuid, PRRank rank) {
        return this.setRank(uuid.toString(), rank);
    }

    public boolean setRank(String identifier, PRRank rank) {
        return this.setRank(this.get(identifier), rank);
    }

    public boolean setRank(PRPlayer player, PRRank rank) {
        if (player == null) {
            return false;
        }
        player.getRanks().clear();
        player.getRanks().add(new PRPlayerRank(rank));
        return true;
    }

    public boolean addRank(UUID uuid, String rankname) {
        return this.addRank(uuid.toString(), PRCache.getRank(rankname));
    }

    public boolean addRank(String identifier, String rankname) {
        return this.addRank(this.get(identifier), PRCache.getRank(rankname));
    }

    public boolean addRank(UUID uuid, PRRank rank) {
        return this.addRank(uuid.toString(), rank);
    }

    public boolean addRank(String identifier, PRRank rank) {
        return this.addRank(this.get(identifier), rank);
    }

    public boolean addRank(PRPlayer player, PRRank rank) {
        if (player == null) {
            return false;
        }
        for (PRPlayerRank prPlayerRank : player.getRanks()) {
            if (!prPlayerRank.getName().equalsIgnoreCase(rank.getName())) continue;
            return false;
        }
        player.getRanks().add(new PRPlayerRank(rank));
        return true;
    }

    public Set<PRPlayerRank> getRanks(UUID uuid) {
        return this.getRanks(uuid.toString());
    }

    public Set<PRPlayerRank> getRanks(String identifier) {
        return this.getRanks(this.get(identifier));
    }

    public Set<PRPlayerRank> getRanks(PRPlayer player) {
        if (player == null) {
            return null;
        }
        return player.getRanks();
    }

    public boolean removeRank(UUID uuid, String rankname) {
        return this.removeRank(uuid.toString(), PRCache.getRank(rankname));
    }

    public boolean removeRank(String identifier, String rankname) {
        return this.removeRank(this.get(identifier), PRCache.getRank(rankname));
    }

    public boolean removeRank(UUID uuid, PRRank rank) {
        return this.removeRank(uuid.toString(), rank);
    }

    public boolean removeRank(String identifier, PRRank rank) {
        return this.removeRank(this.get(identifier), rank);
    }

    public boolean removeRank(PRPlayer player, PRRank rank) {
        if (player == null) {
            return false;
        }
        for (PRPlayerRank prPlayerRank : player.getRanks()) {
            if (!prPlayerRank.getName().equalsIgnoreCase(rank.getName())) continue;
            player.getRanks().remove(prPlayerRank);
            return true;
        }
        return false;
    }

    public boolean hasRank(UUID uuid, String rankname) {
        return this.hasRank(uuid.toString(), PRCache.getRank(rankname));
    }

    public boolean hasRank(String identifier, String rankname) {
        return this.hasRank(this.get(identifier), PRCache.getRank(rankname));
    }

    public boolean hasRank(UUID uuid, PRRank rank) {
        return this.hasRank(uuid.toString(), rank);
    }

    public boolean hasRank(String identifier, PRRank rank) {
        return this.hasRank(this.get(identifier), rank);
    }

    public boolean hasRank(PRPlayer player, PRRank rank) {
        if (player == null) {
            return false;
        }
        for (PRPlayerRank prPlayerRank : player.getRanks()) {
            if (!prPlayerRank.getName().equalsIgnoreCase(rank.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean addPermission(UUID uuid, String permissionNode, boolean isAllowed) {
        return this.addPermission(uuid.toString(), permissionNode, isAllowed);
    }

    public boolean addPermission(String identifier, String permissionNode, boolean isAllowed) {
        return this.addPermission(this.get(identifier), permissionNode, isAllowed);
    }

    public boolean addPermission(PRPlayer player, String permissionNode, boolean isAllowed) {
        return this.addPermission(player, new PRPermission(permissionNode, isAllowed));
    }

    public boolean addPermission(UUID uuid, PRPermission permission) {
        return this.addPermission(uuid.toString(), permission);
    }

    public boolean addPermission(String identifier, PRPermission permission) {
        return this.addPermission(this.get(identifier), permission);
    }

    public boolean addPermission(PRPlayer player, PRPermission permission) {
        if (player == null) {
            return false;
        }
        for (PRPermission prPermission : player.getPermissions()) {
            if (!prPermission.getName().equalsIgnoreCase(permission.getName())) continue;
            return false;
        }
        player.getPermissions().add(permission);
        return true;
    }

    public boolean removePermission(UUID uuid, String permissionNode) {
        return this.removePermission(uuid.toString(), permissionNode);
    }

    public boolean removePermission(String identifier, String permissionNode) {
        return this.removePermission(this.get(identifier), permissionNode);
    }

    public boolean removePermission(PRPlayer player, String permissionNode) {
        return this.removePermission(player, new PRPermission(permissionNode, false));
    }

    public boolean removePermission(UUID uuid, PRPermission permission) {
        return this.removePermission(uuid.toString(), permission);
    }

    public boolean removePermission(String identifier, PRPermission permission) {
        return this.removePermission(this.get(identifier), permission);
    }

    public boolean removePermission(PRPlayer player, PRPermission permission) {
        if (player == null) {
            return false;
        }
        for (PRPermission prPermission : player.getPermissions()) {
            if (!prPermission.getName().equalsIgnoreCase(permission.getName())) continue;
            player.getPermissions().remove(prPermission);
            return true;
        }
        return false;
    }

    public boolean hasPermission(UUID uuid, String permissionNode) {
        return this.hasPermission(uuid.toString(), permissionNode);
    }

    public boolean hasPermission(String identifier, String permissionNode) {
        return this.hasPermission(this.get(identifier), permissionNode);
    }

    public boolean hasPermission(PRPlayer player, String permissionNode) {
        if (player == null) {
            return false;
        }
        for (PRPermission prPermission : player.getPermissions()) {
            if (!prPermission.getName().equals(permissionNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionAllowed(UUID uuid, String permissionNode) {
        return this.isPermissionAllowed(uuid.toString(), permissionNode);
    }

    public boolean isPermissionAllowed(String identifier, String permissionNode) {
        return this.isPermissionAllowed(this.get(identifier), permissionNode);
    }

    public boolean isPermissionAllowed(PRPlayer player, String permissionNode) {
        if (player == null) {
            return false;
        }
        for (PRPermission prPermission : player.getPermissions()) {
            if (!prPermission.getName().equals(permissionNode)) continue;
            return prPermission.getValue();
        }
        return false;
    }

    public boolean setPermissionAllowed(UUID uuid, String permissionNode) {
        return this.setPermissionAllowed(uuid.toString(), permissionNode);
    }

    public boolean setPermissionAllowed(String identifier, String permissionNode) {
        return this.setPermissionAllowed(this.get(identifier), permissionNode);
    }

    public boolean setPermissionAllowed(PRPlayer player, String permissionNode) {
        if (player == null) {
            return false;
        }
        for (PRPermission prPermission : player.getPermissions()) {
            if (!prPermission.getName().equals(permissionNode)) continue;
            prPermission.setValue(true);
            return true;
        }
        return false;
    }

    public boolean setPermissionDisallowed(UUID uuid, String permissionNode) {
        return this.setPermissionDisallowed(uuid.toString(), permissionNode);
    }

    public boolean setPermissionDisallowed(String identifier, String permissionNode) {
        return this.setPermissionDisallowed(this.get(identifier), permissionNode);
    }

    public boolean setPermissionDisallowed(PRPlayer player, String permissionNode) {
        if (player == null) {
            return false;
        }
        for (PRPermission prPermission : player.getPermissions()) {
            if (!prPermission.getName().equals(permissionNode)) continue;
            prPermission.setValue(false);
            return true;
        }
        return false;
    }

    public Set<PRPermission> getPermissions(UUID uuid) {
        return this.getPermissions(uuid.toString());
    }

    public Set<PRPermission> getPermissions(String identifier) {
        return this.getPermissions(this.get(identifier));
    }

    public Set<PRPermission> getPermissions(PRPlayer player) {
        if (player == null) {
            return null;
        }
        return player.getPermissions();
    }

    public boolean addUsertag(UUID uuid, String usertag) {
        return this.addUsertag(uuid.toString(), usertag);
    }

    public boolean addUsertag(String identifier, String usertag) {
        return this.addUsertag(this.get(identifier), usertag);
    }

    public boolean addUsertag(PRPlayer player, String usertag) {
        if (player == null) {
            return false;
        }
        for (String tag : player.getUsertags()) {
            if (!tag.equalsIgnoreCase(usertag)) continue;
            return false;
        }
        player.getUsertags().add(usertag);
        return true;
    }

    public boolean removeUsertag(UUID uuid, String usertag) {
        return this.removeUsertag(uuid.toString(), usertag);
    }

    public boolean removeUsertag(String identifier, String usertag) {
        return this.removeUsertag(this.get(identifier), usertag);
    }

    public boolean removeUsertag(PRPlayer player, String usertag) {
        if (player == null) {
            return false;
        }
        for (String tag : player.getUsertags()) {
            if (!tag.equalsIgnoreCase(usertag)) continue;
            player.getUsertags().remove(tag);
            return true;
        }
        return false;
    }

    public boolean hasUsertag(UUID uuid, String usertag) {
        return this.hasUsertag(uuid.toString(), usertag);
    }

    public boolean hasUsertag(String identifier, String usertag) {
        return this.hasUsertag(this.get(identifier), usertag);
    }

    public boolean hasUsertag(PRPlayer player, String usertag) {
        if (player == null) {
            return false;
        }
        for (String tag : player.getUsertags()) {
            if (!tag.equalsIgnoreCase(usertag)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getUsertags(UUID uuid) {
        return this.getUsertags(uuid.toString());
    }

    public Set<String> getUsertags(String identifier) {
        return this.getUsertags(this.get(identifier));
    }

    public Set<String> getUsertags(PRPlayer player) {
        if (player == null) {
            return null;
        }
        return player.getUsertags();
    }
}

