/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.lib.kotlin.jvm.internal;

import java.util.List;
import nl.svenar.lib.kotlin.SinceKotlin;
import nl.svenar.lib.kotlin.jvm.internal.ClassReference;
import nl.svenar.lib.kotlin.jvm.internal.FunctionBase;
import nl.svenar.lib.kotlin.jvm.internal.FunctionReference;
import nl.svenar.lib.kotlin.jvm.internal.Lambda;
import nl.svenar.lib.kotlin.jvm.internal.MutablePropertyReference0;
import nl.svenar.lib.kotlin.jvm.internal.MutablePropertyReference1;
import nl.svenar.lib.kotlin.jvm.internal.MutablePropertyReference2;
import nl.svenar.lib.kotlin.jvm.internal.PackageReference;
import nl.svenar.lib.kotlin.jvm.internal.PropertyReference0;
import nl.svenar.lib.kotlin.jvm.internal.PropertyReference1;
import nl.svenar.lib.kotlin.jvm.internal.PropertyReference2;
import nl.svenar.lib.kotlin.jvm.internal.TypeParameterReference;
import nl.svenar.lib.kotlin.jvm.internal.TypeReference;
import nl.svenar.lib.kotlin.reflect.KClass;
import nl.svenar.lib.kotlin.reflect.KClassifier;
import nl.svenar.lib.kotlin.reflect.KDeclarationContainer;
import nl.svenar.lib.kotlin.reflect.KFunction;
import nl.svenar.lib.kotlin.reflect.KMutableProperty0;
import nl.svenar.lib.kotlin.reflect.KMutableProperty1;
import nl.svenar.lib.kotlin.reflect.KMutableProperty2;
import nl.svenar.lib.kotlin.reflect.KProperty0;
import nl.svenar.lib.kotlin.reflect.KProperty1;
import nl.svenar.lib.kotlin.reflect.KProperty2;
import nl.svenar.lib.kotlin.reflect.KType;
import nl.svenar.lib.kotlin.reflect.KTypeParameter;
import nl.svenar.lib.kotlin.reflect.KTypeProjection;
import nl.svenar.lib.kotlin.reflect.KVariance;

public class ReflectionFactory {
    private static final String KOTLIN_JVM_FUNCTIONS = "nl.svenar.lib.kotlin.jvm.functions.";

    public KClass createKotlinClass(Class javaClass) {
        return new ClassReference(javaClass);
    }

    public KClass createKotlinClass(Class javaClass, String internalName) {
        return new ClassReference(javaClass);
    }

    public KDeclarationContainer getOrCreateKotlinPackage(Class javaClass, String moduleName) {
        return new PackageReference(javaClass, moduleName);
    }

    public KClass getOrCreateKotlinClass(Class javaClass) {
        return new ClassReference(javaClass);
    }

    public KClass getOrCreateKotlinClass(Class javaClass, String internalName) {
        return new ClassReference(javaClass);
    }

    @SinceKotlin(version="1.1")
    public String renderLambdaToString(Lambda lambda2) {
        return this.renderLambdaToString((FunctionBase)lambda2);
    }

    @SinceKotlin(version="1.3")
    public String renderLambdaToString(FunctionBase lambda2) {
        String result = lambda2.getClass().getGenericInterfaces()[0].toString();
        return result.startsWith(KOTLIN_JVM_FUNCTIONS) ? result.substring(KOTLIN_JVM_FUNCTIONS.length()) : result;
    }

    public KFunction function(FunctionReference f) {
        return f;
    }

    public KProperty0 property0(PropertyReference0 p) {
        return p;
    }

    public KMutableProperty0 mutableProperty0(MutablePropertyReference0 p) {
        return p;
    }

    public KProperty1 property1(PropertyReference1 p) {
        return p;
    }

    public KMutableProperty1 mutableProperty1(MutablePropertyReference1 p) {
        return p;
    }

    public KProperty2 property2(PropertyReference2 p) {
        return p;
    }

    public KMutableProperty2 mutableProperty2(MutablePropertyReference2 p) {
        return p;
    }

    @SinceKotlin(version="1.4")
    public KType typeOf(KClassifier klass, List<KTypeProjection> arguments, boolean isMarkedNullable) {
        return new TypeReference(klass, arguments, isMarkedNullable);
    }

    @SinceKotlin(version="1.4")
    public KTypeParameter typeParameter(Object container, String name, KVariance variance, boolean isReified) {
        return new TypeParameterReference(container, name, variance, isReified);
    }

    @SinceKotlin(version="1.4")
    public void setUpperBounds(KTypeParameter typeParameter, List<KType> bounds) {
        ((TypeParameterReference)typeParameter).setUpperBounds(bounds);
    }
}

