/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.lib.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import nl.svenar.lib.fasterxml.jackson.core.JsonGenerator;
import nl.svenar.lib.fasterxml.jackson.databind.JavaType;
import nl.svenar.lib.fasterxml.jackson.databind.JsonMappingException;
import nl.svenar.lib.fasterxml.jackson.databind.SerializerProvider;
import nl.svenar.lib.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import nl.svenar.lib.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import nl.svenar.lib.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import nl.svenar.lib.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import nl.svenar.lib.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

