/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util.setting;

import com.lishid.openinv.util.setting.PlayerToggle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class PlayerToggles {
    private static final Map<String, PlayerToggle> TOGGLES = new HashMap<String, PlayerToggle>();
    private static final PlayerToggle ANY = PlayerToggles.add(new MemoryToggle("AnyContainer"));
    private static final PlayerToggle SILENT = PlayerToggles.add(new MemoryToggle("SilentContainer"));

    @NotNull
    public static PlayerToggle any() {
        return ANY;
    }

    @NotNull
    public static PlayerToggle silent() {
        return SILENT;
    }

    @Nullable
    public static PlayerToggle get(@NotNull String toggleName) {
        PlayerToggle toggle = TOGGLES.get(toggleName);
        if (toggle == null) {
            toggle = TOGGLES.get(toggleName.toLowerCase(Locale.ENGLISH));
        }
        return toggle;
    }

    public static @UnmodifiableView @NotNull Collection<PlayerToggle> get() {
        return Collections.unmodifiableCollection(TOGGLES.values());
    }

    @NotNull
    private static PlayerToggle add(@NotNull PlayerToggle toggle) {
        TOGGLES.put(toggle.getName().toLowerCase(Locale.ENGLISH), toggle);
        return toggle;
    }

    private PlayerToggles() {
        throw new IllegalStateException("Cannot create instance of utility class.");
    }

    private static class MemoryToggle
    implements PlayerToggle {
        @NotNull
        private final Set<UUID> enabled = new HashSet<UUID>();
        @NotNull
        private final String name;

        private MemoryToggle(@NotNull String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean is(@NotNull UUID uuid) {
            return this.enabled.contains(uuid);
        }

        @Override
        public boolean set(@NotNull UUID uuid, boolean enabled) {
            if (enabled) {
                return this.enabled.add(uuid);
            }
            return this.enabled.remove(uuid);
        }
    }
}

