/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util.lang;

import com.lishid.openinv.util.lang.Replacement;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageManager {
    private final Plugin plugin;
    private final File folder;
    private final String defaultLocale;
    private final Map<String, YamlConfiguration> locales;

    public LanguageManager(@NotNull Plugin plugin, @NotNull String defaultLocale) {
        this.plugin = plugin;
        this.defaultLocale = defaultLocale;
        this.locales = new HashMap<String, YamlConfiguration>();
        this.folder = new File(plugin.getDataFolder(), "locale");
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            plugin.getLogger().warning(() -> "Unable to create " + this.folder.getPath() + "! Languages may not be editable.");
        }
        this.reload();
    }

    public void reload() {
        this.locales.clear();
        this.getOrLoadLocale(this.defaultLocale);
    }

    @NotNull
    private YamlConfiguration getOrLoadLocale(@NotNull String locale) {
        YamlConfiguration loaded = this.locales.get(locale);
        if (loaded != null) {
            return loaded;
        }
        LangLocation lang = this.bestMatch(locale, null);
        if (!locale.equals(lang.locale) && (loaded = this.locales.get(lang.locale)) != null) {
            this.locales.put(locale, loaded);
            return loaded;
        }
        YamlConfiguration localeConfig = this.loadLocale(lang);
        if (!locale.equals(this.defaultLocale)) {
            this.addTranslationFallthrough(lang, localeConfig);
            if (this.plugin.getConfig().getBoolean("settings.secret.warn-about-guess-section", true) && localeConfig.isConfigurationSection("guess")) {
                this.plugin.getLogger().info(() -> "[LanguageManager] Missing translations from " + lang.locale + ".yml! Check the guess section!");
            }
        }
        this.locales.put(locale, localeConfig);
        this.locales.put(lang.locale, localeConfig);
        return localeConfig;
    }

    @NotNull
    private LangLocation bestMatch(@NotNull String locale, @Nullable LangLocation initial) {
        int lastSeparator;
        File file = new File(this.folder, locale + ".yml");
        InputStream bundled = this.plugin.getResource("locale/" + locale + ".yml");
        if (file.exists() || bundled != null) {
            return new LangLocation(locale, file, bundled);
        }
        if (initial == null) {
            initial = new LangLocation(locale, file, null);
        }
        if ((lastSeparator = locale.lastIndexOf(95)) < 1) {
            return initial;
        }
        return this.bestMatch(locale.substring(0, lastSeparator), initial);
    }

    @NotNull
    private YamlConfiguration loadLocale(@NotNull LangLocation lang) {
        YamlConfiguration localeConfigDefaults;
        if (lang.bundled == null) {
            localeConfigDefaults = new YamlConfiguration();
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(lang.bundled, StandardCharsets.UTF_8));){
                localeConfigDefaults = YamlConfiguration.loadConfiguration((Reader)reader);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to load resource " + lang.locale + ".yml");
                localeConfigDefaults = new YamlConfiguration();
            }
        }
        if (!lang.file.exists()) {
            try {
                localeConfigDefaults.save(lang.file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to save resource " + lang.locale + ".yml");
            }
            return localeConfigDefaults;
        }
        YamlConfiguration localeConfig = YamlConfiguration.loadConfiguration((File)lang.file);
        List<String> newKeys = this.getMissingKeys((Configuration)localeConfigDefaults, arg_0 -> ((YamlConfiguration)localeConfig).isSet(arg_0));
        if (newKeys.isEmpty()) {
            return localeConfig;
        }
        ConfigurationSection guess = localeConfig.getConfigurationSection("guess");
        for (String newKey : newKeys) {
            localeConfig.set(newKey, localeConfigDefaults.get(newKey));
            if (guess == null) continue;
            guess.set(newKey, null);
        }
        if (guess != null && guess.getKeys(false).isEmpty()) {
            localeConfig.set("guess", null);
        }
        this.plugin.getLogger().info(() -> "[LanguageManager] Added new translation keys to " + lang.locale + ".yml: " + String.join((CharSequence)", ", newKeys));
        try {
            localeConfig.save(lang.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to save resource " + lang.locale + ".yml");
        }
        return localeConfig;
    }

    private void addTranslationFallthrough(@NotNull LangLocation location, @NotNull YamlConfiguration localeConfig) {
        YamlConfiguration defaultLocaleConfig = this.locales.get(this.defaultLocale);
        List<String> missingKeys = this.getMissingKeys((Configuration)defaultLocaleConfig, key -> localeConfig.isSet(key) || localeConfig.isSet("guess." + key));
        if (!missingKeys.isEmpty()) {
            for (String key2 : missingKeys) {
                localeConfig.set("guess." + key2, defaultLocaleConfig.get(key2));
            }
            try {
                localeConfig.save(location.file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e, () -> "[LanguageManager] Unable to save resource " + location.locale + ".yml");
            }
        }
        localeConfig.setDefaults((Configuration)defaultLocaleConfig);
    }

    @NotNull
    private List<String> getMissingKeys(@NotNull Configuration configurationDefault, @NotNull Predicate<String> nodeSetPredicate) {
        ArrayList<String> missingKeys = new ArrayList<String>();
        for (String key : configurationDefault.getKeys(true)) {
            if (configurationDefault.isConfigurationSection(key) || nodeSetPredicate.test(key)) continue;
            missingKeys.add(key);
        }
        return missingKeys;
    }

    @Nullable
    public String getValue(@NotNull String key, @Nullable String locale) {
        String value = this.getOrLoadLocale(locale == null ? this.defaultLocale : locale.toLowerCase(Locale.ENGLISH)).getString(key);
        if (value == null || value.isBlank()) {
            return null;
        }
        value = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
        return value;
    }

    @Nullable
    public String getValue(@NotNull String key, @Nullable String locale, Replacement ... replacements) {
        String value = this.getValue(key, locale);
        if (value == null) {
            return null;
        }
        for (Replacement replacement : replacements) {
            value = value.replace(replacement.placeholder(), replacement.value());
        }
        return value;
    }

    @Nullable
    public String getLocalizedMessage(@NotNull CommandSender sender, @NotNull String key) {
        return this.getValue(key, this.getLocale(sender));
    }

    @Nullable
    public String getLocalizedMessage(@NotNull CommandSender sender, @NotNull String key, Replacement ... replacements) {
        return this.getValue(key, this.getLocale(sender), replacements);
    }

    @NotNull
    private String getLocale(@NotNull CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getLocale();
        }
        return this.plugin.getConfig().getString("settings.locale", "en");
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull String key) {
        String message = this.getLocalizedMessage(sender, key);
        if (message != null && !message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull String key, Replacement ... replacements) {
        String message = this.getLocalizedMessage(sender, key, replacements);
        if (message != null && !message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public void sendSystemMessage(@NotNull Player player, @NotNull String key) {
        String message = this.getLocalizedMessage((CommandSender)player, key);
        if (message == null) {
            return;
        }
        int newline = message.indexOf(10);
        if (newline != -1) {
            message = message.substring(0, newline);
        }
        if (message.isEmpty()) {
            return;
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)message));
    }

    private record LangLocation(@NotNull String locale, @NotNull File file, @Nullable InputStream bundled) {
    }
}

