/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util.lang;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class LangMigrator {
    @NotNull
    private final Path oldFolder;
    @NotNull
    private final Path newFolder;
    @NotNull
    private final Logger logger;

    public LangMigrator(@NotNull Path oldFolder, @NotNull Path newFolder, @NotNull Logger logger) {
        this.oldFolder = oldFolder;
        this.newFolder = newFolder;
        this.logger = logger;
    }

    public void migrate() {
        if (!Files.exists(this.oldFolder.resolve("en_us.yml"), new LinkOption[0])) {
            return;
        }
        this.logger.info(() -> String.format("[LanguageManager] Migrating language files to %s", this.newFolder));
        if (!Files.exists(this.newFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.newFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Unable to create language subdirectory!", e);
            }
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.oldFolder);){
            files.forEach(path -> {
                if (path == null) {
                    return;
                }
                String fileName = path.getFileName().toString();
                if (fileName.startsWith("config") || !fileName.endsWith(".yml")) {
                    return;
                }
                fileName = switch (fileName) {
                    case "en_us.yml" -> "en.yml";
                    case "de_de.yml" -> "de.yml";
                    case "es_es.yml" -> "es.yml";
                    case "pt_br.yml" -> "pt.yml";
                    default -> fileName;
                };
                try {
                    Files.copy(path, this.newFolder.resolve(fileName), new CopyOption[0]);
                    Files.delete(path);
                }
                catch (FileAlreadyExistsException e1) {
                    try {
                        Files.copy(path, this.newFolder.resolve("old_" + fileName), new CopyOption[0]);
                        Files.delete(path);
                    }
                    catch (IOException e2) {
                        throw new UncheckedIOException(e2);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            this.logger.log(Level.WARNING, "Unable to migrate languages to subdirectory!", e.getCause());
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Unable to migrate languages to subdirectory!", e);
        }
    }
}

