/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util.config;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record ConfigUpdater(@NotNull Plugin plugin) {
    public void checkForUpdates() {
        int version = this.plugin.getConfig().getInt("config-version", 1);
        Configuration defaults = this.plugin.getConfig().getDefaults();
        if (defaults == null || version >= defaults.getInt("config-version")) {
            return;
        }
        this.plugin.getLogger().info("Configuration update found! Performing update...");
        try {
            this.plugin.getConfig().save(new File(this.plugin.getDataFolder(), "config_old.yml"));
            this.plugin.getLogger().info("Backed up config.yml to config_old.yml before updating.");
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not back up config.yml before updating!");
        }
        if (version < 2) {
            this.updateConfig1To2();
        }
        if (version < 3) {
            this.updateConfig2To3();
        }
        if (version < 4) {
            this.updateConfig3To4();
        }
        if (version < 5) {
            this.updateConfig4To5();
        }
        if (version < 6) {
            this.updateConfig5To6();
        }
        if (version < 7) {
            this.updateConfig6To7();
        }
        if (version < 8) {
            this.updateConfig7To8();
        }
        this.plugin.saveConfig();
        this.plugin.getLogger().info("Configuration update complete!");
    }

    private void updateConfig7To8() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("settings.equal-access", (Object)"view");
        config.set("config-version", (Object)8);
    }

    private void updateConfig6To7() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("toggles", null);
        String consoleLocale = config.getString("settings.locale", "en");
        if (consoleLocale.isBlank() || consoleLocale.equalsIgnoreCase("en_us")) {
            consoleLocale = "en";
        }
        config.set("settings.console-locale", (Object)consoleLocale);
        config.set("settings.locale", null);
        config.set("config-version", (Object)7);
    }

    private void updateConfig5To6() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("settings.command.open.no-args-opens-self", (Object)false);
        config.set("settings.command.searchcontainer.max-radius", (Object)10);
        config.set("config-version", (Object)6);
    }

    private void updateConfig4To5() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("settings.disable-offline-access", (Object)false);
        config.set("config-version", (Object)5);
    }

    private void updateConfig3To4() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("notify", null);
        config.set("config-version", (Object)4);
    }

    private void updateConfig2To3() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("items", null);
        config.set("ItemOpenInv", null);
        config.set("toggles", null);
        config.set("settings.disable-saving", (Object)config.getBoolean("DisableSaving", false));
        config.set("DisableSaving", null);
        config.set("config-version", (Object)3);
    }

    private void updateConfig1To2() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("ItemOpenInvItemID", null);
        config.set("NotifySilentChest", null);
        config.set("NotifyAnyChest", null);
        config.set("AnyChest", null);
        config.set("SilentChest", null);
        config.set("config-version", (Object)2);
    }
}

