/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import java.lang.reflect.Field;
import org.jetbrains.annotations.Nullable;

public final class ReflectionHelper {
    @Nullable
    public static <T> T grabObjectByType(Object holder, Class<T> fieldType) {
        Field field = ReflectionHelper.grabFieldByType(holder.getClass(), fieldType);
        if (field != null) {
            try {
                return fieldType.cast(field.get(holder));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Field grabFieldByType(Class<?> holderType, Class<?> fieldType) {
        for (Field field : holderType.getDeclaredFields()) {
            if (!fieldType.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        if (holderType.getSuperclass() != null) {
            return ReflectionHelper.grabFieldByType(fieldType, holderType.getSuperclass());
        }
        return null;
    }

    private ReflectionHelper() {
        throw new IllegalStateException("Cannot create instance of utility class.");
    }
}

