/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.errorprone.annotations.Keep;
import com.lishid.openinv.util.InternalAccessor;
import com.lishid.openinv.util.InventoryManager;
import com.lishid.openinv.util.StringMetric;
import com.lishid.openinv.util.config.Config;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerLoader
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Config config;
    @NotNull
    private final InventoryManager inventoryManager;
    @NotNull
    private final InternalAccessor internalAccessor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Cache<String, PlayerProfile> lookupCache;

    public PlayerLoader(@NotNull Plugin plugin, @NotNull Config config, @NotNull InventoryManager inventoryManager, @NotNull InternalAccessor internalAccessor, @NotNull Logger logger) {
        this.plugin = plugin;
        this.config = config;
        this.inventoryManager = inventoryManager;
        this.internalAccessor = internalAccessor;
        this.logger = logger;
        this.lookupCache = CacheBuilder.newBuilder().maximumSize(20L).build();
    }

    @Nullable
    public Player load(@NotNull OfflinePlayer offline) {
        UUID key = offline.getUniqueId();
        Player player = offline.getPlayer();
        if (player != null) {
            return player;
        }
        player = this.inventoryManager.getLoadedPlayer(key);
        if (player != null) {
            return player;
        }
        if (this.config.isOfflineDisabled() || !this.internalAccessor.isSupported()) {
            return null;
        }
        if (Bukkit.isPrimaryThread()) {
            return this.internalAccessor.getPlayerDataManager().loadPlayer(offline);
        }
        Future future = Bukkit.getScheduler().callSyncMethod(this.plugin, () -> this.internalAccessor.getPlayerDataManager().loadPlayer(offline));
        try {
            player = (Player)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
        return player;
    }

    @Nullable
    public OfflinePlayer match(@NotNull String name) {
        if (Bukkit.getServer().isPrimaryThread()) {
            this.logger.warning("Call to PlayerSearchCache#matchPlayer made on the main thread!");
            this.logger.warning("This can cause the server to hang, potentially severely.");
            this.logger.log(Level.WARNING, "Current stack trace", new Throwable("Current stack trace"));
        }
        try {
            UUID uuid = UUID.fromString(name);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.hasPlayedBefore() || player.isOnline()) {
                return player;
            }
            return null;
        }
        catch (IllegalArgumentException uuid) {
            Player player = Bukkit.getServer().getPlayerExact(name);
            if (player != null) {
                return player;
            }
            PlayerProfile cachedResult = (PlayerProfile)this.lookupCache.getIfPresent((Object)name);
            if (cachedResult != null && cachedResult.getUniqueId() != null) {
                player = Bukkit.getOfflinePlayer((UUID)cachedResult.getUniqueId());
                if (player.hasPlayedBefore() || player.isOnline()) {
                    return player;
                }
                return null;
            }
            player = Bukkit.getServer().getOfflinePlayer(name);
            if (player.hasPlayedBefore()) {
                this.lookupCache.put((Object)name, (Object)player.getPlayerProfile());
                return player;
            }
            player = Bukkit.getServer().getPlayer(name);
            if (player != null) {
                return player;
            }
            float bestMatch = 0.0f;
            for (OfflinePlayer offline : Bukkit.getServer().getOfflinePlayers()) {
                if (offline.getName() == null) continue;
                float currentMatch = StringMetric.compareJaroWinkler(name, offline.getName());
                if (currentMatch == 1.0f) {
                    return offline;
                }
                if (!(currentMatch > bestMatch)) continue;
                bestMatch = currentMatch;
                player = offline;
            }
            if (player != null) {
                this.lookupCache.put((Object)name, (Object)player.getPlayerProfile());
                return player;
            }
            return null;
        }
    }

    @Keep
    @EventHandler
    private void updateMatches(@NotNull PlayerJoinEvent event) {
        if (event.getPlayer().hasPlayedBefore()) {
            return;
        }
        String name = event.getPlayer().getName();
        this.lookupCache.invalidate((Object)name);
        if (this.lookupCache.size() == 0L) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLaterAsynchronously(this.plugin, () -> {
            Iterator iterator = this.lookupCache.asMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String oldMatch = ((PlayerProfile)entry.getValue()).getName();
                if (oldMatch == null) {
                    iterator.remove();
                    continue;
                }
                String lookup = (String)entry.getKey();
                float oldMatchScore = StringMetric.compareJaroWinkler(lookup, oldMatch);
                float newMatchScore = StringMetric.compareJaroWinkler(lookup, name);
                if (!(newMatchScore > oldMatchScore)) continue;
                iterator.remove();
            }
        }, 7L);
    }
}

