/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.util;

import com.github.jikoo.openinv.planarwrappers.util.version.BukkitVersions;
import com.github.jikoo.openinv.planarwrappers.util.version.Version;
import com.lishid.openinv.internal.Accessor;
import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.PlayerManager;
import com.lishid.openinv.util.InventoryAccess;
import com.lishid.openinv.util.lang.LanguageManager;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalAccessor {
    @Nullable
    private Accessor internal;

    public InternalAccessor(@NotNull Logger logger, @NotNull LanguageManager lang) {
        try {
            if (BukkitVersions.MINECRAFT.equals(Version.of(1, 21, 1)) || BukkitVersions.MINECRAFT.equals(Version.of(1, 21))) {
                this.internal = new com.lishid.openinv.internal.v1_21_R1.InternalAccessor(logger, lang);
            } else if (BukkitVersions.MINECRAFT.equals(Version.of(1, 20, 4))) {
                this.internal = new com.lishid.openinv.internal.v1_20_R3.InternalAccessor(logger, lang);
            } else if (BukkitVersions.MINECRAFT.equals(Version.of(1, 20, 6))) {
                this.internal = new com.lishid.openinv.internal.v1_20_R4.InternalAccessor(logger, lang);
            }
            if (this.internal != null) {
                InventoryAccess.setProvider(this.internal::get);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            this.internal = null;
            InventoryAccess.setProvider(null);
        }
    }

    public String getReleasesLink() {
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 4, 4))) {
            return "https://dev.bukkit.org/projects/openinv/files?&sort=datecreated";
        }
        if (BukkitVersions.MINECRAFT.equals(Version.of(1, 8, 8))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.1.5";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 13))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.0.0 (OpenInv-legacy)";
        }
        if (BukkitVersions.MINECRAFT.equals(Version.of(1, 13))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.0.0";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 14))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.0.7";
        }
        if (BukkitVersions.MINECRAFT.equals(Version.of(1, 14))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.0.0";
        }
        if (BukkitVersions.MINECRAFT.equals(Version.of(1, 14, 1))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.0.1";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 15))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.1.1";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 15, 1))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.1.5";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 16))) {
            return "https://github.com/Jikoo/OpenInv/commit/502f661be39ee85d300851dd571f3da226f12345 (never released)";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 16, 1))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.1.4";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 16, 3))) {
            return "https://github.com/lishid/OpenInv/releases/tag/4.1.5";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 17))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.1.8";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 18, 1))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.1.10";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 19))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.3.0";
        }
        if (BukkitVersions.MINECRAFT.equals(Version.of(1, 19))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.2.0";
        }
        if (BukkitVersions.MINECRAFT.equals(Version.of(1, 19, 1))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.2.2";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 19, 3))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.3.0";
        }
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 20))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.4.3";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 20, 1))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.4.1";
        }
        if (BukkitVersions.MINECRAFT.lessThanOrEqual(Version.of(1, 20, 3))) {
            return "https://github.com/Jikoo/OpenInv/releases/tag/4.4.3";
        }
        return "https://github.com/Jikoo/OpenInv/releases";
    }

    public void reload(ConfigurationSection config) {
        if (this.internal != null) {
            this.internal.reload(config);
        }
    }

    @NotNull
    public String getVersion() {
        return BukkitVersions.MINECRAFT.toString();
    }

    public boolean isSupported() {
        return this.internal != null;
    }

    @NotNull
    public IAnySilentContainer getAnySilentContainer() {
        if (this.internal == null) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", BukkitVersions.MINECRAFT));
        }
        return this.internal.getAnySilentContainer();
    }

    @Nullable
    public InventoryView openInventory(@NotNull Player player, @NotNull ISpecialInventory inventory, boolean viewOnly) {
        if (this.internal == null) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", BukkitVersions.MINECRAFT));
        }
        return this.internal.getPlayerManager().openInventory(player, inventory, viewOnly);
    }

    @NotNull
    PlayerManager getPlayerDataManager() {
        if (this.internal == null) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", BukkitVersions.MINECRAFT));
        }
        return this.internal.getPlayerManager();
    }

    ISpecialEnderChest createEnderChest(Player player) {
        if (this.internal == null) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", BukkitVersions.MINECRAFT));
        }
        return this.internal.createEnderChest(player);
    }

    ISpecialPlayerInventory createInventory(Player player) {
        if (this.internal == null) {
            throw new IllegalStateException(String.format("Unsupported server version %s!", BukkitVersions.MINECRAFT));
        }
        return this.internal.createPlayerInventory(player);
    }
}

