/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.listener;

import com.google.errorprone.annotations.Keep;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.util.AccessEqualMode;
import com.lishid.openinv.util.InventoryAccess;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.config.Config;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyInventoryListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Config config;

    public LegacyInventoryListener(@NotNull Plugin plugin, @NotNull Config config) {
        this.plugin = plugin;
        this.config = config;
    }

    @Keep
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onInventoryClick(@NotNull InventoryClickEvent event) {
        if (this.handleInventoryInteract((InventoryInteractEvent)event)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        ItemStack clone = currentItem.clone();
        event.setCurrentItem(null);
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> player.getInventory().addItem(new ItemStack[]{clone}));
    }

    @Keep
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    private void onInventoryDrag(@NotNull InventoryDragEvent event) {
        if (this.handleInventoryInteract((InventoryInteractEvent)event)) {
            return;
        }
        InventoryView view = event.getView();
        if (view.getCursor() == null) {
            return;
        }
        int topSize = view.getTopInventory().getSize();
        Set slots = event.getRawSlots().stream().filter(slot -> slot >= topSize).map(slot -> LegacyInventoryListener.convertToPlayerSlot(view, slot)).collect(Collectors.toSet());
        int overlapLosses = 0;
        for (Map.Entry newItem : event.getNewItems().entrySet()) {
            int convertedSlot;
            int rawSlot = (Integer)newItem.getKey();
            if (rawSlot >= topSize || !slots.contains(convertedSlot = LegacyInventoryListener.convertToPlayerSlot(view, rawSlot))) continue;
            overlapLosses += this.getCountDiff(view.getItem(rawSlot), (ItemStack)newItem.getValue());
        }
        if (overlapLosses < 1) {
            return;
        }
        ItemStack lost = view.getCursor().clone();
        lost.setAmount(overlapLosses);
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
            InventoryView currentOpen = event.getWhoClicked().getOpenInventory();
            if (!currentOpen.equals(view)) {
                event.getWhoClicked().getWorld().dropItem(event.getWhoClicked().getLocation(), lost).setPickupDelay(0);
                return;
            }
            ItemStack cursor = currentOpen.getCursor();
            if (cursor == null) {
                currentOpen.setCursor(lost);
            } else if (lost.isSimilar(cursor)) {
                cursor.setAmount(cursor.getAmount() + lost.getAmount());
                currentOpen.setCursor(cursor);
            } else {
                event.getWhoClicked().getWorld().dropItem(event.getWhoClicked().getLocation(), lost).setPickupDelay(0);
            }
        });
    }

    private int getCountDiff(@Nullable ItemStack original, @NotNull ItemStack result) {
        if (original == null || original.getType() != result.getType()) {
            return result.getAmount();
        }
        return result.getAmount() - original.getAmount();
    }

    private boolean handleInventoryInteract(@NotNull InventoryInteractEvent event) {
        Permissions edit;
        HumanEntity viewer = event.getWhoClicked();
        Inventory inventory = event.getView().getTopInventory();
        ISpecialInventory backing = InventoryAccess.getInventory(inventory);
        if (backing == null) {
            return true;
        }
        HumanEntity target = backing.getPlayer();
        boolean ownContainer = viewer.equals((Object)target);
        if (backing instanceof ISpecialPlayerInventory) {
            edit = ownContainer ? Permissions.INVENTORY_EDIT_SELF : Permissions.INVENTORY_EDIT_OTHER;
        } else if (backing instanceof ISpecialEnderChest) {
            edit = ownContainer ? Permissions.ENDERCHEST_EDIT_SELF : Permissions.ENDERCHEST_OPEN_OTHER;
        } else {
            return true;
        }
        if (!edit.hasPermission((Permissible)viewer)) {
            event.setCancelled(true);
            return true;
        }
        if (this.config.getAccessEqualMode() != AccessEqualMode.VIEW) {
            return !ownContainer || !(backing instanceof ISpecialPlayerInventory);
        }
        for (int level = 4; level > 0; --level) {
            String permission = "openinv.access.level." + level;
            if (!target.hasPermission(permission)) {
                if (!viewer.hasPermission(permission)) continue;
                break;
            }
            event.setCancelled(true);
            return true;
        }
        return !ownContainer || !(backing instanceof ISpecialPlayerInventory);
    }

    private static int convertToPlayerSlot(InventoryView view, int rawSlot) {
        int topSize = view.getTopInventory().getSize();
        if (topSize <= rawSlot) {
            return view.convertSlot(rawSlot);
        }
        if (rawSlot < 27) {
            return rawSlot + 9;
        }
        if (rawSlot < 36) {
            return rawSlot - 27;
        }
        if (rawSlot < 40) {
            return 36 + (39 - rawSlot);
        }
        if (rawSlot == 40) {
            return 40;
        }
        return -1;
    }
}

