/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.player;

import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.v1_21_R1.container.OpenEnderChest;
import com.lishid.openinv.internal.v1_21_R1.container.OpenInventory;
import com.lishid.openinv.internal.v1_21_R1.player.OpenPlayer;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManager
implements com.lishid.openinv.internal.PlayerManager {
    private static boolean paper;
    @NotNull
    private final Logger logger;
    @Nullable
    private Field bukkitEntity;

    public PlayerManager(@NotNull Logger logger) {
        this.logger = logger;
        try {
            this.bukkitEntity = Entity.class.getDeclaredField("bukkitEntity");
        }
        catch (NoSuchFieldException e) {
            logger.warning("Unable to obtain field to inject custom save process - certain player data may be lost when saving!");
            logger.log(Level.WARNING, e.getMessage(), e);
            this.bukkitEntity = null;
        }
    }

    @NotNull
    public static EntityPlayer getHandle(Player player) {
        if (player instanceof CraftPlayer) {
            return ((CraftPlayer)player).getHandle();
        }
        Server server = player.getServer();
        EntityPlayer nmsPlayer = null;
        if (server instanceof CraftServer) {
            nmsPlayer = ((CraftServer)server).getHandle().a(player.getUniqueId());
        }
        if (nmsPlayer == null) {
            throw new RuntimeException("Unable to fetch EntityPlayer from Player implementation " + player.getClass().getName());
        }
        return nmsPlayer;
    }

    @Override
    @Nullable
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer worldServer = server.a(World.h);
        if (worldServer == null) {
            return null;
        }
        EntityPlayer entity = this.createNewPlayer((MinecraftServer)server, worldServer, offline);
        entity.R().a();
        if (this.loadData(entity)) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    @NotNull
    private EntityPlayer createNewPlayer(@NotNull MinecraftServer server, @NotNull WorldServer worldServer, @NotNull OfflinePlayer offline) {
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        ClientInformation dummyInfo = new ClientInformation("en_us", 1, EnumChatVisibility.c, false, 0, EntityPlayer.bH, true, false);
        EntityPlayer entity = new EntityPlayer(server, worldServer, profile, dummyInfo);
        try {
            this.injectPlayer(entity);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
        }
        return entity;
    }

    boolean loadData(@NotNull EntityPlayer player) {
        NBTTagCompound loadedData = player.d.ah().t.b((EntityHuman)player).orElse(null);
        if (loadedData == null) {
            return false;
        }
        player.g(loadedData);
        player.a(loadedData);
        player.c(loadedData);
        if (paper) {
            this.parseWorld(player, loadedData);
        }
        return true;
    }

    private void parseWorld(@NotNull EntityPlayer player, @NotNull NBTTagCompound loadedData) {
        org.bukkit.World bukkitWorld;
        if (loadedData.e("WorldUUIDMost") && loadedData.e("WorldUUIDLeast")) {
            bukkitWorld = Bukkit.getServer().getWorld(new UUID(loadedData.i("WorldUUIDMost"), loadedData.i("WorldUUIDLeast")));
        } else if (loadedData.b("world", 8)) {
            bukkitWorld = Bukkit.getServer().getWorld(loadedData.l("world"));
        } else {
            DimensionManager.a((Dynamic)new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)loadedData.c("Dimension"))).resultOrPartial(this.logger::warning).map(arg_0 -> ((MinecraftServer)player.d).a(arg_0)).ifPresentOrElse(arg_0 -> ((EntityPlayer)player).a(arg_0), () -> player.spawnIn(null));
            return;
        }
        if (bukkitWorld == null) {
            player.spawnIn(null);
            return;
        }
        player.a(((CraftWorld)bukkitWorld).getHandle());
    }

    private void injectPlayer(EntityPlayer player) throws IllegalAccessException {
        if (this.bukkitEntity == null) {
            return;
        }
        this.bukkitEntity.setAccessible(true);
        this.bukkitEntity.set(player, (Object)new OpenPlayer(player.d.server, player, this));
    }

    @Override
    @NotNull
    public Player inject(@NotNull Player player) {
        try {
            EntityPlayer nmsPlayer = PlayerManager.getHandle(player);
            CraftPlayer craftPlayer = nmsPlayer.getBukkitEntity();
            if (craftPlayer instanceof OpenPlayer) {
                OpenPlayer openPlayer = (OpenPlayer)craftPlayer;
                return openPlayer;
            }
            this.injectPlayer(nmsPlayer);
            return nmsPlayer.getBukkitEntity();
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.WARNING, e, () -> "Unable to inject ServerPlayer, certain player data may be lost when saving!");
            return player;
        }
    }

    @Override
    @Nullable
    public InventoryView openInventory(@NotNull Player bukkitPlayer, @NotNull ISpecialInventory inventory, boolean viewOnly) {
        IChatBaseComponent title;
        Container menu;
        EntityPlayer player = PlayerManager.getHandle(bukkitPlayer);
        if (player.c == null) {
            return null;
        }
        if (inventory instanceof OpenInventory) {
            OpenInventory playerInv = (OpenInventory)inventory;
            menu = playerInv.createMenu((EntityHuman)player, player.nextContainerCounter(), viewOnly);
            title = playerInv.getTitle(player);
        } else if (inventory instanceof OpenEnderChest) {
            OpenEnderChest enderChest = (OpenEnderChest)inventory;
            menu = enderChest.createMenu((EntityHuman)player, player.nextContainerCounter(), viewOnly);
            title = enderChest.getTitle();
        } else {
            return null;
        }
        if (menu == null) {
            return null;
        }
        menu.setTitle(title);
        menu = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)player, (Container)menu, (boolean)false);
        if (menu == null) {
            return null;
        }
        player.cd = menu;
        player.c.b((Packet)new PacketPlayOutOpenWindow(menu.j, menu.a(), menu.getTitle()));
        player.a(menu);
        return menu.getBukkitView();
    }

    static {
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
            paper = true;
        }
        catch (ClassNotFoundException ignored) {
            paper = false;
        }
    }
}

