/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1.container;

import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.InternalOwned;
import com.lishid.openinv.internal.v1_21_R1.container.menu.OpenEnderChestMenu;
import com.lishid.openinv.internal.v1_21_R1.player.PlayerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenEnderChest
implements IInventory,
AutoRecipeOutput,
InternalOwned<EntityPlayer>,
ISpecialEnderChest {
    private CraftInventory inventory;
    @NotNull
    private EntityPlayer owner;
    private NonNullList<ItemStack> items;
    private int maxStack = 64;
    private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    public OpenEnderChest(@NotNull Player player) {
        this.owner = PlayerManager.getHandle(player);
        this.items = this.owner.gl().c;
    }

    @Override
    @NotNull
    public EntityPlayer getOwnerHandle() {
        return this.owner;
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        if (this.inventory == null) {
            this.inventory = new CraftInventory(this, this){

                @NotNull
                public InventoryType getType() {
                    return InventoryType.ENDER_CHEST;
                }
            };
        }
        return this.inventory;
    }

    @Override
    public void setPlayerOnline(@NotNull Player player) {
        this.owner = PlayerManager.getHandle(player);
        NonNullList activeItems = this.owner.gl().c;
        int max = Math.min(this.items.size(), activeItems.size());
        for (int index = 0; index < max; ++index) {
            activeItems.set(index, (Object)((ItemStack)this.items.get(index)));
        }
        this.items = activeItems;
    }

    @Override
    public void setPlayerOffline() {
    }

    @NotNull
    public Player getPlayer() {
        return this.owner.getBukkitEntity();
    }

    public int b() {
        return this.items.size();
    }

    public boolean c() {
        return this.items.stream().allMatch(ItemStack::e);
    }

    public ItemStack a(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.l;
    }

    public ItemStack a(int index, int amount) {
        ItemStack itemstack = ContainerUtil.a(this.items, (int)index, (int)amount);
        if (!itemstack.e()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack b(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.set(index, (Object)ItemStack.l) : ItemStack.l;
    }

    public void a(int index, ItemStack itemStack) {
        if (index >= 0 && index < this.items.size()) {
            this.items.set(index, (Object)itemStack);
        }
    }

    public int al_() {
        return this.maxStack;
    }

    public void e() {
        this.owner.gl().e();
    }

    public boolean a(EntityHuman player) {
        return true;
    }

    public List<ItemStack> getContents() {
        return this.items;
    }

    public void onOpen(CraftHumanEntity craftHumanEntity) {
        this.transaction.add((HumanEntity)craftHumanEntity);
    }

    public void onClose(CraftHumanEntity craftHumanEntity) {
        this.transaction.remove(craftHumanEntity);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public Player getOwner() {
        return this.getPlayer();
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Nullable
    public Location getLocation() {
        return null;
    }

    public void a() {
        this.items.clear();
        this.e();
    }

    public void a(AutoRecipeStackManager stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.b(itemstack);
        }
    }

    public IChatBaseComponent getTitle() {
        return IChatBaseComponent.a((String)"openinv.container.enderchest.prefix", (String)"", (Object[])new Object[]{this.owner.ah()}).b((IChatBaseComponent)IChatBaseComponent.c((String)"container.enderchest")).b((IChatBaseComponent)IChatBaseComponent.a((String)"openinv.container.enderchest.suffix", (String)" - %s", (Object[])new Object[]{this.owner.ah()}));
    }

    @Nullable
    public Container createMenu(EntityHuman player, int i, boolean viewOnly) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            return new OpenEnderChestMenu(this, serverPlayer, i, viewOnly);
        }
        return null;
    }
}

