/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_21_R1;

import com.lishid.openinv.internal.Accessor;
import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.v1_21_R1.container.AnySilentContainer;
import com.lishid.openinv.internal.v1_21_R1.container.OpenEnderChest;
import com.lishid.openinv.internal.v1_21_R1.container.OpenInventory;
import com.lishid.openinv.internal.v1_21_R1.container.Placeholders;
import com.lishid.openinv.internal.v1_21_R1.player.PlayerManager;
import com.lishid.openinv.util.lang.LanguageManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.world.IInventory;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalAccessor
implements Accessor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final PlayerManager manager;
    @NotNull
    private final AnySilentContainer anySilentContainer;

    public InternalAccessor(@NotNull Logger logger, @NotNull LanguageManager lang) {
        this.logger = logger;
        this.manager = new PlayerManager(logger);
        this.anySilentContainer = new AnySilentContainer(logger, lang);
    }

    @Override
    @NotNull
    public PlayerManager getPlayerManager() {
        return this.manager;
    }

    @Override
    @NotNull
    public IAnySilentContainer getAnySilentContainer() {
        return this.anySilentContainer;
    }

    @Override
    @NotNull
    public ISpecialPlayerInventory createPlayerInventory(@NotNull Player player) {
        return new OpenInventory(player);
    }

    @Override
    @NotNull
    public ISpecialEnderChest createEnderChest(@NotNull Player player) {
        return new OpenEnderChest(player);
    }

    @Override
    @Nullable
    public <T extends ISpecialInventory> T get(@NotNull Inventory bukkitInventory, @NotNull Class<T> clazz) {
        if (!(bukkitInventory instanceof CraftInventory)) {
            return null;
        }
        CraftInventory craftInventory = (CraftInventory)bukkitInventory;
        IInventory container = craftInventory.getInventory();
        if (clazz.isInstance(container)) {
            return (T)((ISpecialInventory)clazz.cast(container));
        }
        return null;
    }

    @Override
    public void reload(@NotNull ConfigurationSection config) {
        ConfigurationSection placeholders = config.getConfigurationSection("placeholders");
        if (placeholders != null) {
            try {
                Placeholders.load(placeholders);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Caught exception loading placeholder overrides!", e);
            }
        }
    }
}

