/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_20_R4;

import com.google.common.collect.ImmutableList;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.v1_20_R4.PlayerManager;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialPlayerInventory
extends PlayerInventory
implements ISpecialPlayerInventory {
    private final CraftInventory inventory = new CraftInventory((IInventory)this);
    private boolean playerOnline;
    private EntityHuman player;
    private NonNullList<ItemStack> items;
    private NonNullList<ItemStack> armor;
    private NonNullList<ItemStack> offhand;
    private List<NonNullList<ItemStack>> compartments;

    public SpecialPlayerInventory(@NotNull Player bukkitPlayer, @NotNull Boolean online) {
        super((EntityHuman)PlayerManager.getHandle(bukkitPlayer));
        this.playerOnline = online;
        this.player = this.l;
        this.k = this.player.gc().k;
        this.items = this.player.gc().h;
        this.armor = this.player.gc().i;
        this.offhand = this.player.gc().j;
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    }

    @Override
    public void setPlayerOnline(@NotNull Player player) {
        if (this.playerOnline) {
            return;
        }
        EntityHuman offlinePlayer = this.player;
        EntityPlayer onlinePlayer = PlayerManager.getHandle(player);
        onlinePlayer.gc().transaction.addAll(this.transaction);
        this.player = onlinePlayer;
        PlayerInventory onlineInventory = onlinePlayer.gc();
        for (int i = 0; i < this.b(); ++i) {
            onlineInventory.a(i, this.getRawItem(i));
        }
        onlineInventory.k = this.k;
        this.items = onlineInventory.h;
        this.armor = onlineInventory.i;
        this.offhand = onlineInventory.j;
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand);
        PlayerInventory offlineInventory = offlinePlayer.gc();
        offlineInventory.transaction.remove(offlinePlayer.getBukkitEntity());
        onlineInventory.transaction.addAll(offlineInventory.transaction);
        this.playerOnline = true;
    }

    @NotNull
    public CraftInventory getBukkitInventory() {
        return this.inventory;
    }

    @Override
    public void setPlayerOffline() {
        this.playerOnline = false;
    }

    @Override
    @NotNull
    public HumanEntity getPlayer() {
        return this.player.getBukkitEntity();
    }

    @NotNull
    private ItemStack getRawItem(int i) {
        if (i < 0) {
            return ItemStack.l;
        }
        for (NonNullList<ItemStack> list : this.compartments) {
            if (i < list.size()) {
                return (ItemStack)list.get(i);
            }
            i -= list.size();
        }
        return ItemStack.l;
    }

    private void setRawItem(int i, @NotNull ItemStack itemStack) {
        if (i < 0) {
            return;
        }
        for (NonNullList<ItemStack> list : this.compartments) {
            if (i < list.size()) {
                list.set(i, (Object)itemStack);
            }
            i -= list.size();
        }
    }

    @NotNull
    private IndexedCompartment getIndexedContent(int index) {
        if (index < this.items.size()) {
            return new IndexedCompartment(this.items, this.getReversedItemSlotNum(index));
        }
        if ((index -= this.items.size()) < this.armor.size()) {
            return new IndexedCompartment(this.armor, this.getReversedArmorSlotNum(index));
        }
        if ((index -= this.armor.size()) < this.offhand.size()) {
            return new IndexedCompartment(this.offhand, index);
        }
        return new IndexedCompartment(null, index -= this.offhand.size());
    }

    private int getReversedArmorSlotNum(int i) {
        if (i == 0) {
            return 3;
        }
        if (i == 1) {
            return 2;
        }
        if (i == 2) {
            return 1;
        }
        if (i == 3) {
            return 0;
        }
        return i;
    }

    private int getReversedItemSlotNum(int i) {
        if (i >= 27) {
            return i - 27;
        }
        return i + 9;
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return this.compartments.stream().flatMap(Collection::stream).anyMatch(predicate);
    }

    public List<ItemStack> getArmorContents() {
        return this.armor;
    }

    public void onOpen(CraftHumanEntity who) {
        this.player.gc().onOpen(who);
    }

    public void onClose(CraftHumanEntity who) {
        this.player.gc().onClose(who);
    }

    public List<HumanEntity> getViewers() {
        return this.player.gc().getViewers();
    }

    public InventoryHolder getOwner() {
        return this.player.getBukkitEntity();
    }

    public int ah_() {
        return this.player.gc().ah_();
    }

    public void setMaxStackSize(int size) {
        this.player.gc().setMaxStackSize(size);
    }

    public Location getLocation() {
        return this.player.getBukkitEntity().getLocation();
    }

    public boolean ag() {
        return false;
    }

    public List<ItemStack> getContents() {
        return this.compartments.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public ItemStack f() {
        return SpecialPlayerInventory.d((int)this.k) ? (ItemStack)this.items.get(this.k) : ItemStack.l;
    }

    private boolean hasRemainingSpaceForItem(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.e() && ItemStack.c((ItemStack)itemstack, (ItemStack)itemstack1) && itemstack.k() && itemstack.I() < itemstack.j() && itemstack.I() < this.ah_();
    }

    public int canHold(ItemStack itemstack) {
        int remains = itemstack.I();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack1 = this.getRawItem(i);
            if (itemstack1.e()) {
                return itemstack.I();
            }
            if (this.hasRemainingSpaceForItem(itemstack1, itemstack)) {
                remains -= (itemstack1.j() < this.ah_() ? itemstack1.j() : this.ah_()) - itemstack1.I();
            }
            if (remains > 0) continue;
            return itemstack.I();
        }
        ItemStack offhandItemStack = this.getRawItem(this.items.size() + this.armor.size());
        if (this.hasRemainingSpaceForItem(offhandItemStack, itemstack)) {
            remains -= (offhandItemStack.j() < this.ah_() ? offhandItemStack.j() : this.ah_()) - offhandItemStack.I();
        }
        return remains <= 0 ? itemstack.I() : itemstack.I() - remains;
    }

    public int h() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).e()) continue;
            return i;
        }
        return -1;
    }

    public void b(ItemStack itemstack) {
        int i = this.c(itemstack);
        if (SpecialPlayerInventory.d((int)i)) {
            this.k = i;
        } else if (i == -1) {
            int j;
            this.k = this.i();
            if (!((ItemStack)this.items.get(this.k)).e() && (j = this.h()) != -1) {
                this.items.set(j, (Object)((ItemStack)this.items.get(this.k)));
            }
            this.items.set(this.k, (Object)itemstack);
        } else {
            this.c(i);
        }
    }

    public void c(int i) {
        this.k = this.i();
        ItemStack itemstack = (ItemStack)this.items.get(this.k);
        this.items.set(this.k, (Object)((ItemStack)this.items.get(i)));
        this.items.set(i, (Object)itemstack);
    }

    public int c(ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).e() || !ItemStack.c((ItemStack)itemstack, (ItemStack)((ItemStack)this.items.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int d(ItemStack itemStack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack localItem = (ItemStack)this.items.get(i);
            if (((ItemStack)this.items.get(i)).e() || !ItemStack.c((ItemStack)itemStack, (ItemStack)((ItemStack)this.items.get(i))) || ((ItemStack)this.items.get(i)).m() || localItem.B() || localItem.b(DataComponents.g)) continue;
            return i;
        }
        return -1;
    }

    public int i() {
        int i;
        int j;
        for (j = 0; j < 9; ++j) {
            i = (this.k + j) % 9;
            if (!((ItemStack)this.items.get(i)).e()) continue;
            return i;
        }
        for (j = 0; j < 9; ++j) {
            i = (this.k + j) % 9;
            if (((ItemStack)this.items.get(i)).B()) continue;
            return i;
        }
        return this.k;
    }

    public void a(double d0) {
        int i = (int)Math.signum(d0);
        this.k -= i;
        while (this.k < 0) {
            this.k += 9;
        }
        while (this.k >= 9) {
            this.k -= 9;
        }
    }

    public int a(Predicate<ItemStack> predicate, int i, IInventory container) {
        int b0 = 0;
        boolean flag = i == 0;
        int j = b0 + ContainerUtil.a((IInventory)this, predicate, (int)(i - b0), (boolean)flag);
        j += ContainerUtil.a((IInventory)container, predicate, (int)(i - j), (boolean)flag);
        ItemStack itemstack = this.player.cb.g();
        j += ContainerUtil.a((ItemStack)itemstack, predicate, (int)(i - j), (boolean)flag);
        if (itemstack.e()) {
            this.player.cb.b(ItemStack.l);
        }
        return j;
    }

    private int addResource(ItemStack itemstack) {
        int i = this.e(itemstack);
        if (i == -1) {
            i = this.h();
        }
        return i == -1 ? itemstack.I() : this.addResource(i, itemstack);
    }

    private int addResource(int i, ItemStack itemstack) {
        int k;
        int j = itemstack.I();
        ItemStack localItemStack = this.getRawItem(i);
        if (localItemStack.e()) {
            localItemStack = itemstack.c(0);
            this.setRawItem(i, localItemStack);
        }
        if ((k = Math.min(j, this.e_(localItemStack) - localItemStack.I())) != 0) {
            j -= k;
            localItemStack.g(k);
            localItemStack.d(5);
        }
        return j;
    }

    public int e(ItemStack itemstack) {
        if (this.hasRemainingSpaceForItem(this.getRawItem(this.k), itemstack)) {
            return this.k;
        }
        if (this.hasRemainingSpaceForItem(this.getRawItem(40), itemstack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem((ItemStack)this.items.get(i), itemstack)) continue;
            return i;
        }
        return -1;
    }

    public void j() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                if (((ItemStack)compartment.get(i)).e()) continue;
                ((ItemStack)compartment.get(i)).a(this.player.dP(), (Entity)this.player, i, this.k == i);
            }
        }
    }

    public boolean f(ItemStack itemStack) {
        return this.c(-1, itemStack);
    }

    public boolean c(int i, ItemStack itemStack) {
        if (itemStack.e()) {
            return false;
        }
        try {
            int j;
            if (itemStack.m()) {
                if (i == -1) {
                    i = this.h();
                }
                if (i >= 0) {
                    this.items.set(i, (Object)itemStack.s());
                    ((ItemStack)this.items.get(i)).d(5);
                    itemStack.e(0);
                    return true;
                }
                if (this.player.fP()) {
                    itemStack.e(0);
                    return true;
                }
                return false;
            }
            do {
                j = itemStack.I();
                if (i == -1) {
                    itemStack.e(this.addResource(itemStack));
                    continue;
                }
                itemStack.e(this.addResource(i, itemStack));
            } while (!itemStack.e() && itemStack.I() < j);
            if (itemStack.I() == j && this.player.fP()) {
                itemStack.e(0);
                return true;
            }
            return itemStack.I() < j;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.a((Throwable)var6, (String)"Adding item to inventory");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Item being added");
            crashReportCategory.a("Item ID", (Object)Item.a((Item)itemStack.g()));
            crashReportCategory.a("Item data", (Object)itemStack.n());
            crashReportCategory.a("Item name", () -> itemStack.x().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void g(ItemStack itemStack) {
        this.a(itemStack, true);
    }

    public void a(ItemStack itemStack, boolean flag) {
        while (!itemStack.e()) {
            int i = this.e(itemStack);
            if (i == -1) {
                i = this.h();
            }
            if (i != -1) {
                int j = itemStack.j() - this.getRawItem(i).I();
                if (!this.c(i, itemStack.a(j)) || !flag || !(this.player instanceof EntityPlayer)) continue;
                ((EntityPlayer)this.player).c.b((Packet)new PacketPlayOutSetSlot(-2, 0, i, this.getRawItem(i)));
                continue;
            }
            this.player.a(itemStack, false);
            break;
        }
    }

    public ItemStack a(int rawIndex, int j) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null || ((ItemStack)indexedCompartment.compartment().get(indexedCompartment.index())).e()) {
            return ItemStack.l;
        }
        return ContainerUtil.a(indexedCompartment.compartment(), (int)indexedCompartment.index(), (int)j);
    }

    public void h(ItemStack itemStack) {
        block0: for (NonNullList<ItemStack> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                if (compartment.get(i) != itemStack) continue;
                compartment.set(i, (Object)ItemStack.l);
                continue block0;
            }
        }
    }

    public ItemStack b(int rawIndex) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null) {
            return ItemStack.l;
        }
        ItemStack removed = (ItemStack)indexedCompartment.compartment().set(indexedCompartment.index(), (Object)ItemStack.l);
        if (removed.e()) {
            return ItemStack.l;
        }
        return removed;
    }

    public void a(int rawIndex, ItemStack itemStack) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null) {
            this.player.a(itemStack, true);
            return;
        }
        indexedCompartment.compartment().set(indexedCompartment.index(), (Object)itemStack);
    }

    public float a(IBlockData blockState) {
        return ((ItemStack)this.items.get(this.k)).a(blockState);
    }

    public NBTTagList a(NBTTagList listTag) {
        NBTTagCompound compoundTag;
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).e()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).b((HolderLookup.a)this.player.dR(), (NBTBase)compoundTag);
            listTag.add((Object)compoundTag);
        }
        for (i = 0; i < this.armor.size(); ++i) {
            if (((ItemStack)this.armor.get(i)).e()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)(i + 100));
            ((ItemStack)this.armor.get(i)).b((HolderLookup.a)this.player.dR(), (NBTBase)compoundTag);
            listTag.add((Object)compoundTag);
        }
        for (i = 0; i < this.offhand.size(); ++i) {
            if (((ItemStack)this.offhand.get(i)).e()) continue;
            compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)(i + 150));
            ((ItemStack)this.offhand.get(i)).b((HolderLookup.a)this.player.dR(), (NBTBase)compoundTag);
            listTag.add((Object)compoundTag);
        }
        return listTag;
    }

    public void b(NBTTagList listTag) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            NBTTagCompound compoundTag = listTag.a(i);
            int j = compoundTag.f("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.a((HolderLookup.a)this.player.dR(), (NBTBase)compoundTag).orElse(ItemStack.l);
            if (j < this.items.size()) {
                this.items.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.offhand.size() + 150) continue;
            this.offhand.set(j - 150, (Object)itemstack);
        }
    }

    public int b() {
        return 45;
    }

    public boolean c() {
        return !this.b((ItemStack itemStack) -> !itemStack.e());
    }

    public ItemStack a(int rawIndex) {
        IndexedCompartment indexedCompartment = this.getIndexedContent(rawIndex);
        if (indexedCompartment.compartment() == null) {
            return ItemStack.l;
        }
        return (ItemStack)indexedCompartment.compartment().get(indexedCompartment.index());
    }

    public IChatBaseComponent af() {
        return this.player.af();
    }

    public ItemStack e(int index) {
        return (ItemStack)this.armor.get(index);
    }

    public void k() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            for (int i = 0; i < compartment.size(); ++i) {
                ItemStack itemstack = (ItemStack)compartment.get(i);
                if (itemstack.e()) continue;
                this.player.a(itemstack, true, false);
                compartment.set(i, (Object)ItemStack.l);
            }
        }
    }

    public void e() {
        super.e();
    }

    public int l() {
        return super.l();
    }

    public boolean a(EntityHuman player) {
        return true;
    }

    public boolean i(ItemStack itemstack) {
        return this.b((ItemStack itemStack) -> !itemStack.e() && ItemStack.c((ItemStack)itemstack, (ItemStack)itemStack));
    }

    public boolean a(TagKey<Item> tagKey) {
        return this.b((ItemStack itemStack) -> !itemStack.e() && itemStack.a(tagKey));
    }

    public void a(PlayerInventory inventory) {
        Function<Integer, ItemStack> getter;
        if (inventory instanceof SpecialPlayerInventory) {
            SpecialPlayerInventory specialPlayerInventory = (SpecialPlayerInventory)inventory;
            getter = specialPlayerInventory::getRawItem;
        } else {
            getter = arg_0 -> ((PlayerInventory)inventory).a(arg_0);
        }
        for (int i = 0; i < this.b(); ++i) {
            this.setRawItem(i, getter.apply(i));
        }
        this.k = inventory.k;
    }

    public void a() {
        for (NonNullList<ItemStack> compartment : this.compartments) {
            compartment.clear();
        }
    }

    public void a(AutoRecipeStackManager stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.a(itemstack);
        }
    }

    public ItemStack a(boolean dropWholeStack) {
        ItemStack itemstack = this.f();
        return itemstack.e() ? ItemStack.l : this.a(this.k, dropWholeStack ? itemstack.I() : 1);
    }

    private record IndexedCompartment(@Nullable NonNullList<ItemStack> compartment, int index) {
    }
}

