/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal;

import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum InventoryViewTitle {
    PLAYER_INVENTORY("container.player", "'s Inventory"),
    ENDER_CHEST("container.enderchest", "'s Ender Chest");

    private final String localizationKey;
    private final String defaultSuffix;

    private InventoryViewTitle(String localizationKey, String defaultSuffix) {
        this.localizationKey = localizationKey;
        this.defaultSuffix = defaultSuffix;
    }

    @NotNull
    public String getTitle(@NotNull LanguageManager lang, @NotNull Player viewer, @NotNull ISpecialInventory inventory) {
        HumanEntity owner = inventory.getPlayer();
        String localTitle = lang.getLocalizedMessage((CommandSender)viewer, this.localizationKey, new Replacement("%player%", owner.getName()));
        return Objects.requireNonNullElseGet(localTitle, () -> owner.getName() + this.defaultSuffix);
    }

    @Nullable
    public static InventoryViewTitle of(@NotNull ISpecialInventory inventory) {
        if (inventory instanceof ISpecialPlayerInventory) {
            return PLAYER_INVENTORY;
        }
        if (inventory instanceof ISpecialEnderChest) {
            return ENDER_CHEST;
        }
        return null;
    }
}

