/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal;

import com.lishid.openinv.internal.IAnySilentContainer;
import java.lang.reflect.Method;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.EnderChest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnySilentContainerBase
implements IAnySilentContainer {
    @Nullable
    private static final Method BLOCK_GET_STATE_BOOLEAN;

    private static BlockState getBlockState(Block block) {
        if (BLOCK_GET_STATE_BOOLEAN != null) {
            try {
                return (BlockState)BLOCK_GET_STATE_BOOLEAN.invoke((Object)block, false);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return block.getState();
    }

    @Override
    public boolean isAnyContainerNeeded(@NotNull Block block) {
        Chest chest;
        BlockState blockState = AnySilentContainerBase.getBlockState(block);
        if (blockState instanceof Barrel) {
            return false;
        }
        if (blockState instanceof EnderChest) {
            return block.getRelative(0, 1, 0).getType().isOccluding();
        }
        if (blockState instanceof ShulkerBox) {
            return this.isShulkerBlocked(block);
        }
        if (!(blockState instanceof org.bukkit.block.Chest)) {
            return false;
        }
        if (this.isChestBlocked(block)) {
            return true;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Chest) || (chest = (Chest)blockData).getType() == Chest.Type.SINGLE) {
            return false;
        }
        BlockFace relativeFace = switch (chest.getFacing()) {
            case BlockFace.NORTH -> {
                if (chest.getType() == Chest.Type.RIGHT) {
                    yield BlockFace.WEST;
                }
                yield BlockFace.EAST;
            }
            case BlockFace.EAST -> {
                if (chest.getType() == Chest.Type.RIGHT) {
                    yield BlockFace.NORTH;
                }
                yield BlockFace.SOUTH;
            }
            case BlockFace.SOUTH -> {
                if (chest.getType() == Chest.Type.RIGHT) {
                    yield BlockFace.EAST;
                }
                yield BlockFace.WEST;
            }
            case BlockFace.WEST -> {
                if (chest.getType() == Chest.Type.RIGHT) {
                    yield BlockFace.SOUTH;
                }
                yield BlockFace.NORTH;
            }
            default -> BlockFace.SELF;
        };
        Block relative = block.getRelative(relativeFace);
        if (relative.getType() != block.getType()) {
            return false;
        }
        BlockData relativeData = relative.getBlockData();
        if (!(relativeData instanceof Chest)) {
            return false;
        }
        Chest relativeChest = (Chest)relativeData;
        if (relativeChest.getFacing() != chest.getFacing() || relativeChest.getType() != (chest.getType() == Chest.Type.RIGHT ? Chest.Type.LEFT : Chest.Type.RIGHT)) {
            return false;
        }
        return this.isChestBlocked(relative);
    }

    @Override
    public boolean isAnySilentContainer(@NotNull Block block) {
        return this.isAnySilentContainer(AnySilentContainerBase.getBlockState(block));
    }

    static {
        Method getState;
        try {
            getState = Block.class.getMethod("getState", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            getState = null;
        }
        BLOCK_GET_STATE_BOOLEAN = getState;
    }
}

