/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.event;

import com.lishid.openinv.event.OpenPlayerSaveEvent;
import com.lishid.openinv.event.PlayerSaveEvent;
import com.lishid.openinv.event.PlayerToggledEvent;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.util.setting.PlayerToggle;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public final class OpenEvents {
    public static boolean saveCancelled(@NotNull Player player) {
        return OpenEvents.call(new PlayerSaveEvent(player));
    }

    public static boolean saveCancelled(@NotNull ISpecialInventory inventory) {
        return OpenEvents.call(new OpenPlayerSaveEvent((Player)inventory.getPlayer(), inventory));
    }

    public static void notifyPlayerToggle(@NotNull PlayerToggle toggle, @NotNull UUID uuid, boolean state) {
        Bukkit.getPluginManager().callEvent((Event)new PlayerToggledEvent(toggle, uuid, state));
    }

    private static <T extends Event> boolean call(T event) {
        Bukkit.getPluginManager().callEvent(event);
        return ((Cancellable)event).isCancelled();
    }

    private OpenEvents() {
        throw new IllegalStateException("Cannot create instance of utility class.");
    }
}

