/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.command;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.util.AccessEqualMode;
import com.lishid.openinv.util.InventoryManager;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.PlayerLoader;
import com.lishid.openinv.util.TabCompleter;
import com.lishid.openinv.util.config.Config;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.lang.Replacement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class OpenInvCommand
implements TabExecutor {
    @NotNull
    private final OpenInv plugin;
    @NotNull
    private final Config config;
    @NotNull
    private final InventoryManager manager;
    @NotNull
    private final LanguageManager lang;
    @NotNull
    private final PlayerLoader playerLoader;
    private final HashMap<Player, String> openInvHistory = new HashMap();
    private final HashMap<Player, String> openEnderHistory = new HashMap();

    public OpenInvCommand(@NotNull OpenInv plugin, @NotNull Config config, @NotNull InventoryManager manager, @NotNull LanguageManager lang, @NotNull PlayerLoader playerLoader) {
        this.plugin = plugin;
        this.config = config;
        this.manager = manager;
        this.lang = lang;
        this.playerLoader = playerLoader;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String noArgValue;
        final boolean openInv = command.getName().equals("openinv");
        if (openInv && args.length > 0 && (args[0].equalsIgnoreCase("help") || args[0].equals("?"))) {
            this.showHelp(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            this.lang.sendMessage(sender, "messages.error.consoleUnsupported");
            return true;
        }
        final Player player = (Player)sender;
        if (this.config.doesNoArgsOpenSelf()) {
            noArgValue = player.getUniqueId().toString();
        } else {
            noArgValue = (openInv ? this.openInvHistory : this.openEnderHistory).get(player);
            if (noArgValue == null || noArgValue.isEmpty()) {
                noArgValue = player.getUniqueId().toString();
                (openInv ? this.openInvHistory : this.openEnderHistory).put(player, noArgValue);
            }
        }
        final String name = args.length < 1 ? noArgValue : args[0];
        new BukkitRunnable(){

            public void run() {
                final OfflinePlayer offlinePlayer = OpenInvCommand.this.playerLoader.match(name);
                if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore() && !offlinePlayer.isOnline()) {
                    OpenInvCommand.this.lang.sendMessage((CommandSender)player, "messages.error.invalidPlayer");
                    return;
                }
                new BukkitRunnable(){

                    public void run() {
                        if (!player.isOnline()) {
                            return;
                        }
                        OpenInvCommand.this.openInventory(player, offlinePlayer, openInv);
                    }
                }.runTask((Plugin)OpenInvCommand.this.plugin);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
        return true;
    }

    private void showHelp(CommandSender sender) {
        for (String commandName : this.plugin.getDescription().getCommands().keySet()) {
            PluginCommand command = this.plugin.getCommand(commandName);
            if (command == null || !command.testPermissionSilent(sender)) continue;
            sender.sendMessage(command.getUsage().replace("<command>", commandName));
            List aliases = command.getAliases();
            if (aliases.isEmpty()) continue;
            StringJoiner aliasJoiner = new StringJoiner(", ", "   (aliases: ", ")");
            for (String alias : aliases) {
                aliasJoiner.add(alias);
            }
            sender.sendMessage(aliasJoiner.toString());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openInventory(Player player, OfflinePlayer target, boolean openinv) {
        ISpecialInventory iSpecialInventory;
        Player onlineTarget;
        block15: {
            boolean online = target.isOnline();
            if (!online) {
                if (!this.config.isOfflineDisabled() && Permissions.ACCESS_OFFLINE.hasPermission((Permissible)player)) {
                    onlineTarget = this.playerLoader.load(target);
                    break block15;
                } else {
                    this.lang.sendMessage((CommandSender)player, "messages.error.permissionPlayerOffline");
                    return;
                }
            }
            if (!Permissions.ACCESS_ONLINE.hasPermission((Permissible)player)) {
                this.lang.sendMessage((CommandSender)player, "messages.error.permissionPlayerOnline");
                return;
            }
            onlineTarget = target.getPlayer();
        }
        if (onlineTarget == null) {
            this.lang.sendMessage((CommandSender)player, "messages.error.invalidPlayer");
            return;
        }
        if (onlineTarget.equals((Object)player)) {
            if (!(openinv ? Permissions.INVENTORY_OPEN_SELF : Permissions.ENDERCHEST_OPEN_SELF).hasPermission((Permissible)player)) {
                this.lang.sendMessage((CommandSender)player, "messages.error.permissionOpenSelf");
                return;
            }
        } else {
            void var6_7;
            if (!(openinv ? Permissions.INVENTORY_OPEN_OTHER : Permissions.ENDERCHEST_OPEN_OTHER).hasPermission((Permissible)player)) {
                this.lang.sendMessage((CommandSender)player, "messages.error.permissionOpenOther");
                return;
            }
            int n = 4;
            while (var6_7 > 0) {
                String permission = "openinv.access.level." + (int)var6_7;
                if (onlineTarget.hasPermission(permission) && (!player.hasPermission(permission) || this.config.getAccessEqualMode() == AccessEqualMode.DENY)) {
                    this.lang.sendMessage((CommandSender)player, "messages.error.permissionExempt", new Replacement("%target%", onlineTarget.getDisplayName()));
                    return;
                }
                --var6_7;
            }
            if (!Permissions.ACCESS_CROSSWORLD.hasPermission((Permissible)player) && !onlineTarget.getWorld().equals((Object)player.getWorld())) {
                this.lang.sendMessage((CommandSender)player, "messages.error.permissionCrossWorld", new Replacement("%target%", onlineTarget.getDisplayName()));
                return;
            }
        }
        if (!this.config.doesNoArgsOpenSelf()) {
            (openinv ? this.openInvHistory : this.openEnderHistory).put(player, target.getUniqueId().toString());
        }
        try {
            iSpecialInventory = openinv ? this.manager.getInventory(onlineTarget) : this.manager.getEnderChest(onlineTarget);
        }
        catch (Exception e) {
            this.lang.sendMessage((CommandSender)player, "messages.error.commandException");
            this.plugin.getLogger().log(Level.WARNING, "Unable to create ISpecialInventory", e);
            return;
        }
        this.plugin.openInventory(player, iSpecialInventory);
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.testPermissionSilent(sender) || args.length != 1) {
            return Collections.emptyList();
        }
        return TabCompleter.completeOnlinePlayer(sender, args[0]);
    }
}

