/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.github.jikoo.openinv.planarwrappers.util.version.BukkitVersions;
import com.github.jikoo.openinv.planarwrappers.util.version.Version;
import com.lishid.openinv.IOpenInv;
import com.lishid.openinv.command.ContainerSettingCommand;
import com.lishid.openinv.command.OpenInvCommand;
import com.lishid.openinv.command.SearchContainerCommand;
import com.lishid.openinv.command.SearchEnchantCommand;
import com.lishid.openinv.command.SearchInvCommand;
import com.lishid.openinv.internal.IAnySilentContainer;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialInventory;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.listener.ContainerListener;
import com.lishid.openinv.listener.LegacyInventoryListener;
import com.lishid.openinv.listener.ToggleListener;
import com.lishid.openinv.util.AccessEqualMode;
import com.lishid.openinv.util.InternalAccessor;
import com.lishid.openinv.util.InventoryManager;
import com.lishid.openinv.util.Permissions;
import com.lishid.openinv.util.PlayerLoader;
import com.lishid.openinv.util.config.Config;
import com.lishid.openinv.util.config.ConfigUpdater;
import com.lishid.openinv.util.lang.LangMigrator;
import com.lishid.openinv.util.lang.LanguageManager;
import com.lishid.openinv.util.setting.PlayerToggle;
import com.lishid.openinv.util.setting.PlayerToggles;
import java.nio.file.Path;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryView;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInv
extends JavaPlugin
implements IOpenInv {
    private InternalAccessor accessor;
    private Config config;
    private InventoryManager inventoryManager;
    private LanguageManager languageManager;
    private PlayerLoader playerLoader;
    private boolean isSpigot = false;

    public void reloadConfig() {
        super.reloadConfig();
        this.config.reload((Configuration)this.getConfig());
        this.languageManager.reload();
        if (this.accessor != null && this.accessor.isSupported()) {
            this.accessor.reload((ConfigurationSection)this.getConfig());
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        block3: {
            block2: {
                if (!this.isSpigot) break block2;
                if (this.accessor.isSupported()) break block3;
            }
            this.sendVersionError(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            return true;
        }
        return false;
    }

    public void onDisable() {
        this.inventoryManager.evictAll();
    }

    public void onEnable() {
        this.saveDefaultConfig();
        Path dataFolder = this.getDataFolder().toPath();
        new LangMigrator(dataFolder, dataFolder.resolve("locale"), this.getLogger()).migrate();
        this.config = new Config();
        this.languageManager = new LanguageManager((Plugin)this, "en");
        this.accessor = new InternalAccessor(this.getLogger(), this.languageManager);
        this.reloadConfig();
        this.inventoryManager = new InventoryManager((Plugin)this, this.config, this.accessor);
        this.playerLoader = new PlayerLoader((Plugin)this, this.config, this.inventoryManager, this.accessor, this.getLogger());
        try {
            Class.forName("org.bukkit.entity.Player$Spigot");
            this.isSpigot = true;
        }
        catch (ClassNotFoundException e) {
            this.isSpigot = false;
        }
        if (this.isSpigot && this.accessor.isSupported()) {
            this.reloadConfig();
            new ConfigUpdater((Plugin)this).checkForUpdates();
            this.registerEvents();
            this.registerCommands();
        } else {
            this.sendVersionError(this.getLogger()::warning);
        }
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (BukkitVersions.MINECRAFT.lessThan(Version.of(1, 21))) {
            pluginManager.registerEvents((Listener)new LegacyInventoryListener((Plugin)this, this.config), (Plugin)this);
        }
        pluginManager.registerEvents((Listener)this.playerLoader, (Plugin)this);
        pluginManager.registerEvents((Listener)this.inventoryManager, (Plugin)this);
        pluginManager.registerEvents((Listener)new ContainerListener(this.accessor, this.languageManager), (Plugin)this);
        pluginManager.registerEvents((Listener)new ToggleListener(), (Plugin)this);
    }

    private void registerCommands() {
        this.setCommandExecutor((CommandExecutor)new OpenInvCommand(this, this.config, this.inventoryManager, this.languageManager, this.playerLoader), "openinv", "openender");
        this.setCommandExecutor((CommandExecutor)new SearchContainerCommand((Plugin)this, this.languageManager), "searchcontainer");
        this.setCommandExecutor((CommandExecutor)new SearchInvCommand(this.languageManager), "searchinv", "searchender");
        this.setCommandExecutor((CommandExecutor)new SearchEnchantCommand(this.languageManager), "searchenchant");
        ContainerSettingCommand settingCommand = new ContainerSettingCommand(this.languageManager);
        for (PlayerToggle toggle : PlayerToggles.get()) {
            this.setCommandExecutor((CommandExecutor)settingCommand, toggle.getName().toLowerCase(Locale.ENGLISH));
        }
    }

    private void setCommandExecutor(@NotNull CommandExecutor executor, String ... commands) {
        for (String commandName : commands) {
            PluginCommand command = this.getCommand(commandName);
            if (command == null) continue;
            command.setExecutor(executor);
        }
    }

    private void sendVersionError(@NotNull Consumer<String> messageMethod) {
        if (!this.accessor.isSupported()) {
            messageMethod.accept("Your server version (" + this.accessor.getVersion() + ") is not supported.");
            messageMethod.accept("Please download the correct version of OpenInv here: " + this.accessor.getReleasesLink());
            if (Boolean.getBoolean("paper.disable-plugin-rewriting")) {
                messageMethod.accept("OpenInv uses Spigot-mapped internals, but you have disabled plugin rewriting in Paper!");
                messageMethod.accept("Please set system property 'paper.disable-plugin-rewriting' to false.");
            }
        }
        if (!this.isSpigot) {
            messageMethod.accept("OpenInv requires that you use Spigot or a Spigot fork. Per the 1.14 update thread");
            messageMethod.accept("(https://www.spigotmc.org/threads/369724/ \"A Note on CraftBukkit\"), if you are");
            messageMethod.accept("encountering an inconsistency with vanilla that prevents you from using Spigot,");
            messageMethod.accept("that is considered a Spigot bug and should be reported as such.");
        }
    }

    @Override
    public boolean isSupportedVersion() {
        return this.accessor != null && this.accessor.isSupported();
    }

    @Override
    public boolean disableSaving() {
        return this.config.isSaveDisabled();
    }

    @Override
    public boolean disableOfflineAccess() {
        return this.config.isOfflineDisabled();
    }

    @Override
    public boolean noArgsOpensSelf() {
        return this.config.doesNoArgsOpenSelf();
    }

    @Override
    @NotNull
    public IAnySilentContainer getAnySilentContainer() {
        return this.accessor.getAnySilentContainer();
    }

    @Override
    public boolean getAnyContainerStatus(@NotNull OfflinePlayer offline) {
        return PlayerToggles.any().is(offline.getUniqueId());
    }

    @Override
    public void setAnyContainerStatus(@NotNull OfflinePlayer offline, boolean status) {
        PlayerToggles.any().set(offline.getUniqueId(), status);
    }

    @Override
    public boolean getSilentContainerStatus(@NotNull OfflinePlayer offline) {
        return PlayerToggles.silent().is(offline.getUniqueId());
    }

    @Override
    public void setSilentContainerStatus(@NotNull OfflinePlayer offline, boolean status) {
        PlayerToggles.silent().set(offline.getUniqueId(), status);
    }

    @Override
    @NotNull
    public ISpecialEnderChest getSpecialEnderChest(@NotNull Player player, boolean online) {
        return this.inventoryManager.getEnderChest(player);
    }

    @Override
    @NotNull
    public ISpecialPlayerInventory getSpecialInventory(@NotNull Player player, boolean online) {
        return this.inventoryManager.getInventory(player);
    }

    @Override
    @Nullable
    public InventoryView openInventory(@NotNull Player player, @NotNull ISpecialInventory inventory) {
        boolean viewOnly;
        Permissions edit = null;
        HumanEntity target = inventory.getPlayer();
        boolean ownContainer = player.equals((Object)target);
        if (inventory instanceof ISpecialPlayerInventory) {
            edit = ownContainer ? Permissions.INVENTORY_EDIT_SELF : Permissions.INVENTORY_EDIT_OTHER;
        } else if (inventory instanceof ISpecialEnderChest) {
            edit = ownContainer ? Permissions.ENDERCHEST_EDIT_SELF : Permissions.ENDERCHEST_OPEN_OTHER;
        }
        boolean bl = viewOnly = edit != null && !edit.hasPermission((Permissible)player);
        if (!ownContainer && !viewOnly) {
            for (int level = 4; level > 0; --level) {
                String permission = "openinv.access.level." + level;
                if (!target.hasPermission(permission)) {
                    if (!player.hasPermission(permission)) continue;
                    break;
                }
                if (!player.hasPermission(permission) || this.config.getAccessEqualMode() == AccessEqualMode.DENY) {
                    return null;
                }
                if (this.config.getAccessEqualMode() != AccessEqualMode.VIEW) break;
                viewOnly = true;
                break;
            }
        }
        return this.accessor.openInventory(player, inventory, viewOnly);
    }

    @Override
    public boolean isPlayerLoaded(@NotNull UUID playerUuid) {
        return this.inventoryManager.getLoadedPlayer(playerUuid) != null;
    }

    @Override
    @Nullable
    public Player loadPlayer(@NotNull OfflinePlayer offline) {
        return this.playerLoader.load(offline);
    }

    @Override
    @Nullable
    public OfflinePlayer matchPlayer(@NotNull String name) {
        return this.playerLoader.match(name);
    }

    @Override
    public void unload(@NotNull OfflinePlayer offline) {
        this.inventoryManager.unload(offline.getUniqueId());
    }
}

