/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.openinv.planarwrappers.util.version;

import com.github.jikoo.openinv.planarwrappers.util.AlphanumComparator;
import com.github.jikoo.openinv.planarwrappers.util.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StringVersion
implements Version {
    static final AlphanumComparator COMPARATOR = new AlphanumComparator(){

        @Override
        protected int compareTail(AlphanumComparator.CompareData data1, AlphanumComparator.CompareData data2) {
            if (data1.getMarker() < data1.getLength()) {
                return this.compareSnapshot(data1, data2);
            }
            if (data2.getMarker() < data2.getLength()) {
                return -this.compareSnapshot(data2, data1);
            }
            return 0;
        }

        private int compareSnapshot(AlphanumComparator.CompareData longer, AlphanumComparator.CompareData shorter) {
            if (shorter.getLength() == 0) {
                return 1;
            }
            if (!this.isDigit(shorter.getString().charAt(shorter.getLength() - 1)) || shorter.getString().indexOf(45) != -1) {
                return 1;
            }
            char nextChar = longer.getString().charAt(longer.getLength() - 1);
            return this.isDigit(nextChar) || nextChar == '.' ? 1 : -1;
        }
    };
    @NotNull
    private final String versionText;

    StringVersion(@NotNull String version) {
        this.versionText = version;
    }

    public boolean equals(@Nullable Object obj) {
        Version that;
        return this == obj || obj instanceof Version && this.compareTo(that = (Version)obj) == 0;
    }

    public int hashCode() {
        return this.versionText.hashCode();
    }

    public String toString() {
        return this.versionText;
    }

    @Override
    public int compareTo(@NotNull Version that) {
        return COMPARATOR.compare(this.versionText, that.toString());
    }
}

