/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.openinv.planarwrappers.util.version;

import com.github.jikoo.openinv.planarwrappers.util.version.IntVersion;
import com.github.jikoo.openinv.planarwrappers.util.version.Version;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class BukkitVersions {
    public static final Version MINECRAFT;
    @Deprecated
    public static final Version CRAFTBUKKIT_PACKAGE;

    @VisibleForTesting
    @Contract(value="_ -> new")
    @NotNull
    static Version parseMinecraftVersion(Server server) {
        String versionString;
        Pattern semVerRelease = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?-.*$");
        try {
            MethodHandle getMcVer = MethodHandles.publicLookup().findVirtual(Server.class, "getMinecraftVersion", MethodType.methodType(String.class));
            versionString = getMcVer.invoke(server);
        }
        catch (Throwable e) {
            versionString = Bukkit.getBukkitVersion();
        }
        Matcher matcher = semVerRelease.matcher(versionString);
        if (matcher.find()) {
            return new IntVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(4)));
        }
        return Version.of(BukkitVersions.stripExtraData(versionString));
    }

    @VisibleForTesting
    @NotNull
    static Version parseCraftbukkitVersion(@NotNull String craftbukkitPackage) {
        Pattern packageVer = Pattern.compile("^org\\.bukkit\\.craftbukkit\\.v(\\d+)_(\\d+)_R?(\\d+)");
        Matcher matcher = packageVer.matcher(craftbukkitPackage);
        if (matcher.find()) {
            return new IntVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
        }
        return MINECRAFT;
    }

    @NotNull
    private static String stripExtraData(@NotNull String version) {
        int preReleaseStart = version.indexOf(45);
        int metadataStart = version.indexOf(43);
        if (preReleaseStart > -1) {
            if (metadataStart > -1) {
                return version.substring(0, Math.min(preReleaseStart, metadataStart));
            }
            return version.substring(0, preReleaseStart);
        }
        if (metadataStart > -1) {
            return version.substring(0, metadataStart);
        }
        return version;
    }

    private BukkitVersions() {
        throw new IllegalStateException("Cannot instantiate static utility classes!");
    }

    static {
        Server server = Bukkit.getServer();
        MINECRAFT = BukkitVersions.parseMinecraftVersion(server);
        String packageString = server.getClass().getPackage().toString();
        CRAFTBUKKIT_PACKAGE = BukkitVersions.parseCraftbukkitVersion(packageString);
    }
}

