/*
 * Decompiled with CFR 0.152.
 */
package me.mrhuncy;

import java.util.Random;
import me.mrhuncy.MobEvolution;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobEvolutionListener
implements Listener {
    private final MobEvolution plugin;
    private final Random random = new Random();

    public MobEvolutionListener(MobEvolution plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        int level = this.plugin.getDaysPassed() + 1;
        this.evolveMob(entity, level);
        this.setMobLevelTag(entity, level);
    }

    private void evolveMob(LivingEntity entity, int level) {
        AttributeInstance speedAttribute;
        AttributeInstance damageAttribute;
        double healthMultiplier = this.plugin.getConfig().getDouble("health_multiplier", 1.2);
        double damageMultiplier = this.plugin.getConfig().getDouble("damage_multiplier", 1.2);
        double speedMultiplier = this.plugin.getConfig().getDouble("speed_multiplier", 1.1);
        AttributeInstance healthAttribute = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (healthAttribute != null) {
            double healthBoost = healthAttribute.getBaseValue() * Math.pow(healthMultiplier, level - 1);
            healthAttribute.setBaseValue(healthBoost);
            entity.setHealth(healthBoost);
        }
        if ((damageAttribute = entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE)) != null) {
            double damageBoost = damageAttribute.getBaseValue() * Math.pow(damageMultiplier, level - 1);
            damageAttribute.setBaseValue(damageBoost);
        }
        if ((speedAttribute = entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)) != null) {
            double speedBoost = speedAttribute.getBaseValue() * Math.pow(speedMultiplier, level - 1);
            speedAttribute.setBaseValue(speedBoost);
        }
    }

    private void setMobLevelTag(LivingEntity entity, int level) {
        entity.setCustomName("Lvl " + level + " " + entity.getType());
        entity.setCustomNameVisible(true);
    }
}

