/*
 * Decompiled with CFR 0.152.
 */
package me.mrhuncy;

import me.mrhuncy.MobEvolutionListener;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MobEvolution
extends JavaPlugin {
    private int daysPassed;
    private long initialWorldTime;

    public void onEnable() {
        this.saveDefaultConfig();
        this.daysPassed = this.getConfig().getInt("days_passed", 0);
        if (!this.getConfig().contains("initial_world_time")) {
            this.initialWorldTime = ((World)Bukkit.getWorlds().get(0)).getFullTime();
            this.getConfig().set("initial_world_time", (Object)this.initialWorldTime);
            this.saveConfig();
        } else {
            this.initialWorldTime = this.getConfig().getLong("initial_world_time");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new MobEvolutionListener(this), (Plugin)this);
        this.startDayCounter();
    }

    public void onDisable() {
        this.getConfig().set("days_passed", (Object)this.daysPassed);
        this.saveConfig();
    }

    private void startDayCounter() {
        new BukkitRunnable(){

            public void run() {
                World world = (World)Bukkit.getWorlds().get(0);
                long currentTime = world.getFullTime();
                int currentDay = (int)((currentTime - MobEvolution.this.initialWorldTime) / 24000L);
                if (currentDay > MobEvolution.this.daysPassed) {
                    MobEvolution.this.daysPassed = currentDay;
                    MobEvolution.this.getLogger().info("\u00daj Minecraft nap kezd\u0151d\u00f6tt, jelenlegi napok sz\u00e1ma: " + MobEvolution.this.daysPassed);
                    MobEvolution.this.getConfig().set("days_passed", (Object)MobEvolution.this.daysPassed);
                    MobEvolution.this.saveConfig();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1200L);
    }

    public int getDaysPassed() {
        return this.daysPassed;
    }
}

