/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.inventory.util;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.util.AdventureUtils;
import java.util.List;
import net.Indyuce.inventory.MMOInventory;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryButton {
    private final ItemStack item;
    public static final NamespacedKey NAMESPACED_KEY = new NamespacedKey((Plugin)MMOInventory.plugin, "Button");

    public InventoryButton(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        Validate.isTrue((boolean)config.contains("material"), (String)"Could not find item material");
        this.item = new ItemStack(Material.valueOf((String)config.getString("material")));
        ItemMeta meta = this.item.getItemMeta();
        if (config.contains("name")) {
            AdventureUtils.setDisplayName((ItemMeta)meta, (String)config.getString("name"));
        }
        if (config.contains("lore")) {
            AdventureUtils.setLore((ItemMeta)meta, (List)config.getStringList("lore"));
        }
        if (config.contains("skull-texture") && meta instanceof SkullMeta) {
            UtilityMethods.setTextureValue((SkullMeta)((SkullMeta)meta), (String)config.getString("skull-texture"));
        }
        if (config.contains("custom-model-data")) {
            meta.setCustomModelData(Integer.valueOf(config.getInt("custom-model-data")));
        }
        meta.getPersistentDataContainer().set(NAMESPACED_KEY, PersistentDataType.BYTE, (Object)1);
        this.item.setItemMeta(meta);
    }

    public ItemStack getItem() {
        return this.item;
    }
}

