/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.inventory.slot.restriction;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import net.Indyuce.inventory.inventory.InventoryHandler;
import net.Indyuce.inventory.slot.CustomSlot;
import net.Indyuce.inventory.slot.restriction.SlotRestriction;
import net.Indyuce.inventory.util.LineConfig;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LoreTagRestriction
extends SlotRestriction {
    private final String loreTag;
    private final CheckType checkType;

    public LoreTagRestriction(LineConfig config) {
        config.validate("tag");
        this.loreTag = MythicLib.plugin.parseColors(config.getString("tag"));
        this.checkType = config.contains("check") ? CheckType.valueOf(UtilityMethods.enumName((String)config.getString("check"))) : CheckType.EQUALS;
    }

    @Override
    public boolean isVerified(InventoryHandler provider, CustomSlot slot, ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasLore()) {
            return false;
        }
        for (String checked : meta.getLore()) {
            if (!this.checkType.operation.check(checked, this.loreTag)) continue;
            return true;
        }
        return false;
    }

    static enum CheckType {
        EQUALS(String::equals),
        CONTAINS(String::contains),
        STARTS_WITH(String::startsWith),
        ENDS_WITH(String::endsWith);

        final Operation operation;

        private CheckType(Operation operation) {
            this.operation = operation;
        }
    }

    @FunctionalInterface
    static interface Operation {
        public boolean check(String var1, String var2);
    }
}

