/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.inventory.listener;

import io.lumine.mythic.lib.MythicLib;
import net.Indyuce.inventory.MMOInventory;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;

public class ResourcePack
implements Listener {
    private final String url;
    private final int delay;

    public ResourcePack(ConfigurationSection config) {
        this.url = config.getString("url");
        this.delay = config.getInt("delay");
        Validate.notNull((Object)this.url, (String)"Could not load resource pack URL");
        if (config.getBoolean("kick.enabled")) {
            Bukkit.getPluginManager().registerEvents((Listener)new KickIfDisabled(config.getConfigurationSection("kick")), (Plugin)MMOInventory.plugin);
        }
    }

    @EventHandler
    public void sendResourcePack(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MMOInventory.plugin, () -> player.setResourcePack(this.url), (long)this.delay);
    }

    public class KickIfDisabled
    implements Listener {
        private final String message;

        public KickIfDisabled(ConfigurationSection config) {
            Validate.notNull((Object)config.getString("message"), (String)"Could not read kick message");
            this.message = MythicLib.plugin.parseColors(config.getString("message"));
        }

        @EventHandler
        public void kickPlayer(PlayerResourcePackStatusEvent event) {
            if (event.getStatus() == PlayerResourcePackStatusEvent.Status.DECLINED || event.getStatus() == PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD) {
                event.getPlayer().kickPlayer(this.message);
            }
        }
    }
}

