/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.inventory.listener;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.Indyuce.inventory.MMOInventory;
import net.Indyuce.inventory.api.event.ItemEquipEvent;
import net.Indyuce.inventory.inventory.InventoryHandler;
import net.Indyuce.inventory.slot.CustomSlot;
import net.Indyuce.inventory.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NoCustomInventory
implements Listener {
    private static final List<InventoryAction> supported = Arrays.asList(InventoryAction.PICKUP_ALL, InventoryAction.PLACE_ALL, InventoryAction.SWAP_WITH_CURSOR);

    @EventHandler
    public void giveItemsOnJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (CustomSlot slot : MMOInventory.plugin.getSlotManager().getCustomSlots()) {
            if (!UtilityMethods.isAir((ItemStack)player.getInventory().getItem(slot.getIndex()))) continue;
            player.getInventory().setItem(slot.getIndex(), slot.displayItem(player));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void placeBackSlotItems(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!player.getInventory().equals((Object)event.getClickedInventory())) {
            return;
        }
        CustomSlot slot = MMOInventory.plugin.getSlotManager().get(event.getSlot());
        if (slot == null) {
            return;
        }
        if (!supported.contains(event.getAction())) {
            event.setCancelled(true);
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (UtilityMethods.isAir((ItemStack)event.getCursor()) && Utils.isGuiItem(item)) {
            event.setCancelled(true);
            return;
        }
        ItemStack cursor = event.getCursor();
        if (!UtilityMethods.isAir((ItemStack)event.getCursor())) {
            if (MMOInventory.plugin.getConfig().getBoolean("disable-equiping-stacked-items", true) && event.getCursor().getAmount() > 1) {
                event.setCancelled(true);
                return;
            }
            if (!slot.canHost((InventoryHandler)MMOInventory.plugin.getDataManager().get((OfflinePlayer)player), cursor)) {
                event.setCancelled(true);
                return;
            }
        }
        ItemEquipEvent.EquipAction action = UtilityMethods.isAir((ItemStack)event.getCursor()) ? ItemEquipEvent.EquipAction.UNEQUIP : (Utils.isGuiItem(cursor) ? ItemEquipEvent.EquipAction.EQUIP : ItemEquipEvent.EquipAction.SWAP_ITEMS);
        ItemEquipEvent called = new ItemEquipEvent(player, event.getCursor(), slot, action);
        Bukkit.getPluginManager().callEvent((Event)called);
        if (called.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (Utils.isGuiItem(item)) {
            event.setCurrentItem(null);
        }
        if (UtilityMethods.isAir((ItemStack)event.getCursor())) {
            Bukkit.getScheduler().runTask((Plugin)MMOInventory.plugin, () -> player.getInventory().setItem(slot.getIndex(), slot.displayItem(player)));
        }
        MMOInventory.plugin.updateInventory(player);
    }

    @EventHandler
    public void removeGuiDrops(PlayerDeathEvent event) {
        if (event.getKeepInventory()) {
            return;
        }
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack next = (ItemStack)iterator.next();
            if (!Utils.isGuiItem(next)) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void giveItemsOnRespawn(PlayerRespawnEvent event) {
        this.giveItemsOnJoin(new PlayerJoinEvent(event.getPlayer(), "You found a secret dev easter egg"));
    }
}

