/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.inventory.listener;

import java.util.Iterator;
import net.Indyuce.inventory.MMOInventory;
import net.Indyuce.inventory.gui.PlayerInventoryView;
import net.Indyuce.inventory.util.InventoryButton;
import net.Indyuce.inventory.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryButtonListener
implements Listener {
    private final ItemStack icon;
    private final int slot;

    public InventoryButtonListener(ConfigurationSection config) {
        this.slot = config.getInt("slot");
        this.icon = new InventoryButton(config.getConfigurationSection("item")).getItem();
    }

    @EventHandler
    public void giveItemsOnJoin(PlayerJoinEvent event) {
        event.getPlayer().getInventory().setItem(this.slot, this.icon);
    }

    @EventHandler
    public void giveItemsOnRespawn(PlayerRespawnEvent event) {
        event.getPlayer().getInventory().setItem(this.slot, this.icon);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void blockInteractions(InventoryClickEvent event) {
        if (Utils.isButton(event.getCurrentItem())) {
            event.setCancelled(true);
            Bukkit.getScheduler().runTask((Plugin)MMOInventory.plugin, () -> new PlayerInventoryView((Player)event.getWhoClicked()).open());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void blockDrop(PlayerDeathEvent event) {
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack next = (ItemStack)iterator.next();
            if (!Utils.isButton(next)) continue;
            iterator.remove();
        }
    }
}

