/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests.tasks;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.data.ProfileExtensions;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.core.placeholder.PlayerPlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextExtensions;
import com.willfp.eco.util.NumberUtilsExtensions;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecoquests.api.event.PlayerTaskCompleteEvent;
import com.willfp.ecoquests.api.event.PlayerTaskExpGainEvent;
import com.willfp.ecoquests.quests.Quest;
import com.willfp.ecoquests.quests.Quests;
import com.willfp.ecoquests.tasks.Task;
import com.willfp.ecoquests.tasks.TaskTemplate;
import com.willfp.libreforge.counters.Accumulator;
import com.willfp.libreforge.counters.Counter;
import com.willfp.libreforge.effects.Chain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cJ\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010%\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J\u000e\u0010&\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0016\u0010*\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cJ\u000e\u0010+\u001a\u00020\u00102\u0006\u0010!\u001a\u00020(J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020(J\u0006\u0010-\u001a\u00020\u001fR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u001c0\u001c0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u001c0\u001c0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/willfp/ecoquests/tasks/Task;", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "template", "Lcom/willfp/ecoquests/tasks/TaskTemplate;", "quest", "Lcom/willfp/ecoquests/quests/Quest;", "xpExpr", "", "(Lcom/willfp/eco/core/EcoPlugin;Lcom/willfp/ecoquests/tasks/TaskTemplate;Lcom/willfp/ecoquests/quests/Quest;Ljava/lang/String;)V", "accumulator", "com/willfp/ecoquests/tasks/Task$accumulator$1", "Lcom/willfp/ecoquests/tasks/Task$accumulator$1;", "hasCompletedKey", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "", "kotlin.jvm.PlatformType", "getQuest", "()Lcom/willfp/ecoquests/quests/Quest;", "getTemplate", "()Lcom/willfp/ecoquests/tasks/TaskTemplate;", "getXpExpr$core_plugin", "()Ljava/lang/String;", "xpGainMethods", "", "Lcom/willfp/libreforge/counters/Counter;", "xpKey", "", "xpRequiredKey", "bind", "", "gainExperience", "player", "Lorg/bukkit/entity/Player;", "amount", "generateExperienceRequired", "getCompletedDescription", "getDescription", "getExperience", "Lorg/bukkit/OfflinePlayer;", "getExperienceRequired", "giveExperience", "hasCompleted", "reset", "unbind", "core-plugin"})
public final class Task {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final TaskTemplate template;
    @NotNull
    private final Quest quest;
    @NotNull
    private final String xpExpr;
    @NotNull
    private final PersistentDataKey<Double> xpKey;
    @NotNull
    private final PersistentDataKey<Double> xpRequiredKey;
    @NotNull
    private final PersistentDataKey<Boolean> hasCompletedKey;
    @NotNull
    private final List<Counter> xpGainMethods;
    @NotNull
    private final accumulator.1 accumulator;

    public Task(@NotNull EcoPlugin ecoPlugin, @NotNull TaskTemplate taskTemplate, @NotNull Quest quest, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)ecoPlugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)taskTemplate, (String)"template");
        Intrinsics.checkNotNullParameter((Object)quest, (String)"quest");
        Intrinsics.checkNotNullParameter((Object)string, (String)"xpExpr");
        this.plugin = ecoPlugin;
        this.template = taskTemplate;
        this.quest = quest;
        this.xpExpr = string;
        this.xpKey = new PersistentDataKey(this.plugin.createNamespacedKey(this.quest.getId() + "_task_" + this.template.getId() + "_xp"), PersistentDataKeyType.DOUBLE, (Object)0.0);
        this.xpRequiredKey = new PersistentDataKey(this.plugin.createNamespacedKey(this.quest.getId() + "_task_" + this.template.getId() + "_xp_required"), PersistentDataKeyType.DOUBLE, (Object)0.0);
        this.hasCompletedKey = new PersistentDataKey(this.plugin.createNamespacedKey(this.quest.getId() + "_task_" + this.template.getId() + "_has_completed"), PersistentDataKeyType.BOOLEAN, (Object)false);
        Iterable iterable = this.template.getXpGainMethods();
        Task task = this;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            Counter counter = (Counter)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(counter.clone());
        }
        task.xpGainMethods = (List)collection;
        this.accumulator = new Accumulator(this){
            final /* synthetic */ Task this$0;
            {
                this.this$0 = task;
            }

            public void accept(@NotNull Player player, double d) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                if (!this.this$0.getQuest().hasActive((OfflinePlayer)player)) {
                    return;
                }
                this.this$0.gainExperience(player, d);
            }
        };
        new PlayerPlaceholder(this.plugin, this.quest.getId() + "_task_" + this.template.getId() + "_required_xp", arg_0 -> Task._init_$lambda-1(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, this.quest.getId() + "_task_" + this.template.getId() + "_xp", arg_0 -> Task._init_$lambda-2(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, this.quest.getId() + "_task_" + this.template.getId() + "_description", arg_0 -> Task._init_$lambda-3(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, this.quest.getId() + "_task_" + this.template.getId() + "_completed", arg_0 -> Task._init_$lambda-4(this, arg_0)).register();
    }

    @NotNull
    public final TaskTemplate getTemplate() {
        return this.template;
    }

    @NotNull
    public final Quest getQuest() {
        return this.quest;
    }

    @NotNull
    public final String getXpExpr$core_plugin() {
        return this.xpExpr;
    }

    public final void bind() {
        for (Counter counter : this.xpGainMethods) {
            counter.bind((Accumulator)this.accumulator);
        }
    }

    public final void unbind() {
        for (Counter counter : this.xpGainMethods) {
            counter.unbind();
        }
    }

    public final void reset(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).write(this.xpKey, (Object)0.0);
        ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).write(this.hasCompletedKey, (Object)false);
    }

    public final boolean hasCompleted(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).read(this.hasCompletedKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(hasCompletedKey)");
        return (Boolean)object;
    }

    private final double generateExperienceRequired(Player player) {
        return NumberUtilsExtensions.evaluateExpression((String)this.xpExpr, (PlaceholderContext)PlaceholderContextExtensions.placeholderContext$default((Player)player, null, null, null, (int)14, null));
    }

    public final double getExperienceRequired(@NotNull Player player) {
        double d;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).read(this.xpRequiredKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(xpRequiredKey)");
        double d2 = ((Number)object).doubleValue();
        if (d2 <= 0.0) {
            double d3 = this.generateExperienceRequired(player);
            if (d3 <= 0.0) {
                throw new IllegalStateException("Invalid XP Required for task " + this.template.getId() + " in quest " + this.quest.getId() + "(Requirement was " + d3 + ", which is less than or equal to 0)");
            }
            ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.xpRequiredKey, (Object)d3);
            d = d3;
        } else {
            d = d2;
        }
        return d;
    }

    public final double getExperience(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).read(this.xpKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(xpKey)");
        return ((Number)object).doubleValue();
    }

    public final void gainExperience(@NotNull Player player, double d) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerTaskExpGainEvent playerTaskExpGainEvent = new PlayerTaskExpGainEvent(player, this.template, this.quest, d);
        Bukkit.getPluginManager().callEvent((Event)playerTaskExpGainEvent);
        if (playerTaskExpGainEvent.isCancelled()) {
            return;
        }
        this.giveExperience(player, playerTaskExpGainEvent.getAmount());
    }

    public final void giveExperience(@NotNull Player player, double d) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        double d2 = this.getExperienceRequired(player);
        double d3 = ((Number)ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).read(this.xpKey)).doubleValue() + d;
        ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.xpKey, (Object)Math.min(d3, d2));
        if (d3 >= d2) {
            ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.hasCompletedKey, (Object)true);
            Chain chain = this.template.getOnComplete();
            if (chain != null) {
                Chain.trigger$default((Chain)chain, (Player)player, null, null, null, (int)14, null);
            }
            Bukkit.getPluginManager().callEvent((Event)new PlayerTaskCompleteEvent(player, this.template, this.quest));
            for (Quest quest : Quests.INSTANCE.values()) {
                quest.checkCompletion(player);
            }
        }
    }

    @NotNull
    public final String getDescription(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = this.template.getConfig().getString("description");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"template.config.getString(\"description\")");
        return StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%xp%", (String)StringUtilsExtensions.toNiceString((Object)this.getExperience((OfflinePlayer)player)), (boolean)false, (int)4, null), (String)"%required-xp%", (String)StringUtilsExtensions.toNiceString((Object)this.getExperienceRequired(player)), (boolean)false, (int)4, null), (Player)player, (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getCompletedDescription(@NotNull Player player) {
        String string;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.hasCompleted((OfflinePlayer)player)) {
            String string2 = this.plugin.getConfigYml().getString("tasks.completed");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.configYml.getString(\"tasks.completed\")");
            string = StringsKt.replace$default((String)string2, (String)"%description%", (String)this.getDescription(player), (boolean)false, (int)4, null);
        } else {
            String string3 = this.plugin.getConfigYml().getString("tasks.not-completed");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"plugin.configYml.getString(\"tasks.not-completed\")");
            string = StringsKt.replace$default((String)string3, (String)"%description%", (String)this.getDescription(player), (boolean)false, (int)4, null);
        }
        return string;
    }

    private static final String _init_$lambda-1(Task task, Player player) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return StringUtilsExtensions.toNiceString((Object)task.getExperienceRequired(player));
    }

    private static final String _init_$lambda-2(Task task, Player player) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return StringUtilsExtensions.toNiceString((Object)task.getExperience((OfflinePlayer)player));
    }

    private static final String _init_$lambda-3(Task task, Player player) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return task.getDescription(player);
    }

    private static final String _init_$lambda-4(Task task, Player player) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return StringUtilsExtensions.toNiceString((Object)task.hasCompleted((OfflinePlayer)player));
    }
}

