/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests.quests;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.sound.PlayableSound;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecoquests.api.event.PlayerQuestStartEvent;
import com.willfp.ecoquests.quests.Quest;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/willfp/ecoquests/quests/QuestStartDisplay;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "sound", "Lcom/willfp/eco/core/sound/PlayableSound;", "Lorg/jetbrains/annotations/Nullable;", "handle", "", "event", "Lcom/willfp/ecoquests/api/event/PlayerQuestStartEvent;", "core-plugin"})
public final class QuestStartDisplay
implements Listener {
    @NotNull
    private final EcoPlugin plugin;
    @Nullable
    private final PlayableSound sound;

    public QuestStartDisplay(@NotNull EcoPlugin ecoPlugin) {
        Intrinsics.checkNotNullParameter((Object)ecoPlugin, (String)"plugin");
        this.plugin = ecoPlugin;
        this.sound = this.plugin.getConfigYml().getBool("quests.start.sound.enabled") ? PlayableSound.create((Config)this.plugin.getConfigYml().getSubsection("quests.start.sound")) : null;
    }

    @EventHandler
    public final void handle(@NotNull PlayerQuestStartEvent playerQuestStartEvent) {
        block4: {
            List<String> list;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)playerQuestStartEvent, (String)"event");
            Player player = playerQuestStartEvent.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
            Player player2 = player;
            Quest quest = playerQuestStartEvent.getQuest();
            if (!quest.getAnnouncesStart()) {
                return;
            }
            if (this.plugin.getConfigYml().getBool("quests.start.message.enabled")) {
                List list2 = this.plugin.getConfigYml().getStrings("quests.start.message.message");
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"plugin.configYml.getStri\u2026s.start.message.message\")");
                object2 = list2;
                object = quest.addPlaceholdersInto((List<String>)object2, player2);
                list = (List<String>)object;
                boolean bl = false;
                for (Object t : list) {
                    String string = (String)t;
                    boolean bl2 = false;
                    player2.sendMessage(string);
                }
            }
            if (this.plugin.getConfigYml().getBool("quests.start.title.enabled")) {
                String string = this.plugin.getConfigYml().getString("quests.start.title.title");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.configYml.getStri\u2026uests.start.title.title\")");
                object2 = string;
                String string2 = this.plugin.getConfigYml().getString("quests.start.title.subtitle");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.configYml.getStri\u2026ts.start.title.subtitle\")");
                object = string2;
                Object[] objectArray = new String[]{object2, object};
                list = quest.addPlaceholdersInto(CollectionsKt.listOf((Object[])objectArray), player2);
                player2.showTitle(Title.title((Component)StringUtilsExtensions.toComponent((String)list.get(0)), (Component)StringUtilsExtensions.toComponent((String)list.get(1)), (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)(this.plugin.getConfigYml().getDouble("quests.start.title.fade-in") * (double)1000)), (Duration)Duration.ofMillis((long)(this.plugin.getConfigYml().getDouble("quests.start.title.stay") * (double)1000)), (Duration)Duration.ofMillis((long)(this.plugin.getConfigYml().getDouble("quests.start.title.fade-out") * (double)1000)))));
            }
            PlayableSound playableSound = this.sound;
            if (playableSound == null) break block4;
            playableSound.playTo(player2);
        }
    }
}

