/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests.quests;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.data.ProfileExtensions;
import com.willfp.eco.core.data.ServerProfile;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.core.gui.GUIHelperExtensions;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.builder.ItemBuilder;
import com.willfp.eco.core.items.builder.ItemBuilderExtensions;
import com.willfp.eco.core.placeholder.PlayerPlaceholder;
import com.willfp.eco.core.placeholder.PlayerlessPlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextExtensions;
import com.willfp.eco.core.registry.KRegistrable;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecoquests.api.event.PlayerQuestCompleteEvent;
import com.willfp.ecoquests.api.event.PlayerQuestStartEvent;
import com.willfp.ecoquests.quests.Quest;
import com.willfp.ecoquests.quests.QuestKt;
import com.willfp.ecoquests.tasks.Task;
import com.willfp.ecoquests.tasks.TaskTemplate;
import com.willfp.ecoquests.tasks.Tasks;
import com.willfp.ecoquests.util.ListUtilsKt;
import com.willfp.ecoquests.util.TimeKt;
import com.willfp.libreforge.EmptyProvidedHolder;
import com.willfp.libreforge.ProvidedHolder;
import com.willfp.libreforge.ViolationContext;
import com.willfp.libreforge.conditions.ConditionList;
import com.willfp.libreforge.conditions.Conditions;
import com.willfp.libreforge.effects.Chain;
import com.willfp.libreforge.effects.Effects;
import com.willfp.libreforge.effects.executors.ChainExecutor;
import com.willfp.libreforge.effects.executors.impl.NormalExecutorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020\n2\u0006\u0010@\u001a\u00020AJ\u0010\u0010C\u001a\u00020D2\u0006\u0010@\u001a\u00020AH\u0002J\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010@\u001a\u00020AJ\u0010\u0010F\u001a\u0004\u0018\u00010\u00132\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020\u00162\u0006\u0010@\u001a\u00020JJ\u000e\u0010K\u001a\u00020\u00052\u0006\u0010@\u001a\u00020AJ\u000e\u0010L\u001a\u00020\u00162\u0006\u0010@\u001a\u00020JJ\u000e\u0010M\u001a\u00020\n2\u0006\u0010@\u001a\u00020JJ\u000e\u0010N\u001a\u00020\n2\u0006\u0010@\u001a\u00020JJ\u000e\u0010O\u001a\u00020\n2\u0006\u0010@\u001a\u00020JJ\u0010\u0010P\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J\u000e\u0010Q\u001a\u00020\n2\u0006\u0010@\u001a\u00020AJ\b\u0010R\u001a\u00020DH\u0016J\b\u0010S\u001a\u00020DH\u0016J\u0006\u0010T\u001a\u00020DJ\u000e\u0010T\u001a\u00020D2\u0006\u0010@\u001a\u00020JJ\u0006\u0010U\u001a\u00020DJ\b\u0010V\u001a\u00020DH\u0002J\u000e\u0010W\u001a\u00020\n2\u0006\u0010@\u001a\u00020AJ\u000e\u0010X\u001a\u00020D2\u0006\u0010@\u001a\u00020AJ \u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012*\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010Z\u001a\u00020\u0016H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u0017*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\n0\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\n0\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u001c\u0010!\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u00070\u0005\u00a2\u0006\u0002\b&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010)\u001a.\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00050\u0005 \u0017*\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00050\u00050\u0012\u00a2\u0006\u0002\b&0*\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010-\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00050\u0005 \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120*0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\fR\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00108\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010$R*\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006["}, d2={"Lcom/willfp/ecoquests/quests/Quest;", "Lcom/willfp/eco/core/registry/KRegistrable;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "id", "", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "(Lcom/willfp/eco/core/EcoPlugin;Ljava/lang/String;Lcom/willfp/eco/core/config/interfaces/Config;)V", "alwaysInGUI", "", "getAlwaysInGUI", "()Z", "announcesStart", "getAnnouncesStart", "autoStarts", "getAutoStarts", "availableTasks", "", "Lcom/willfp/ecoquests/tasks/Task;", "completedTimeKey", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "", "kotlin.jvm.PlatformType", "getConfig", "()Lcom/willfp/eco/core/config/interfaces/Config;", "guiItem", "Lorg/bukkit/inventory/ItemStack;", "hasCompletedKey", "hasStartedKey", "getId", "()Ljava/lang/String;", "isResettable", "lastResetTimeKey", "minutesUntilReset", "getMinutesUntilReset", "()I", "name", "Lorg/jetbrains/annotations/NotNull;", "getName", "resetTime", "rewardMessages", "", "rewards", "Lcom/willfp/libreforge/effects/Chain;", "savedTasksKey", "showsInGui", "getShowsInGui", "slot", "Lcom/willfp/eco/core/gui/slot/Slot;", "getSlot", "()Lcom/willfp/eco/core/gui/slot/Slot;", "startConditions", "Lcom/willfp/libreforge/conditions/ConditionList;", "startEffects", "startedTimeKey", "taskAmount", "getTaskAmount", "<set-?>", "tasks", "getTasks", "()Ljava/util/List;", "addPlaceholdersInto", "strings", "player", "Lorg/bukkit/entity/Player;", "checkCompletion", "complete", "", "getDescription", "getTask", "template", "Lcom/willfp/ecoquests/tasks/TaskTemplate;", "getTimeSinceCompletion", "Lorg/bukkit/OfflinePlayer;", "getTimeSincePlaceholder", "getTimeSinceStart", "hasActive", "hasCompleted", "hasStarted", "loadTasks", "meetsStartConditions", "onRegister", "onRemove", "reset", "resetIfNeeded", "saveTasks", "shouldStart", "start", "addMargin", "margin", "core-plugin"})
public final class Quest
implements KRegistrable {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final String id;
    @NotNull
    private final Config config;
    @NotNull
    private final String name;
    private final boolean announcesStart;
    private final boolean autoStarts;
    private final ItemStack guiItem;
    @NotNull
    private final Slot slot;
    private final boolean showsInGui;
    private final boolean alwaysInGUI;
    @NotNull
    private final List<Task> availableTasks;
    private final int taskAmount;
    @NotNull
    private final PersistentDataKey<List<String>> savedTasksKey;
    @NotNull
    private List<Task> tasks;
    @NotNull
    private final PersistentDataKey<Boolean> hasStartedKey;
    @NotNull
    private final PersistentDataKey<Integer> startedTimeKey;
    @NotNull
    private final PersistentDataKey<Boolean> hasCompletedKey;
    @NotNull
    private final PersistentDataKey<Integer> completedTimeKey;
    @NotNull
    private final List<String> rewardMessages;
    @Nullable
    private final Chain rewards;
    @Nullable
    private final Chain startEffects;
    @NotNull
    private final ConditionList startConditions;
    @NotNull
    private final PersistentDataKey<Integer> lastResetTimeKey;
    private final int resetTime;

    public Quest(@NotNull EcoPlugin ecoPlugin, @NotNull String string, @NotNull Config config) {
        List<Task> list;
        Intrinsics.checkNotNullParameter((Object)ecoPlugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)string, (String)"id");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.plugin = ecoPlugin;
        this.id = string;
        this.config = config;
        String string2 = this.config.getFormattedString("name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.getFormattedString(\"name\")");
        this.name = string2;
        this.announcesStart = this.config.getBool("announce-start");
        this.autoStarts = this.config.getBool("auto-start");
        this.guiItem = Items.lookup((String)this.config.getString("gui.item")).getItem();
        this.slot = GUIHelperExtensions.slot((Function2)((Function2)new Function2<Player, Menu, ItemStack>(this){
            final /* synthetic */ Quest this$0;
            {
                this.this$0 = quest;
                super(2);
            }

            @NotNull
            public final ItemStack invoke(@NotNull Player player, @NotNull Menu menu) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)menu, (String)"<anonymous parameter 1>");
                ItemStack itemStack = Quest.access$getGuiItem$p(this.this$0).clone();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"guiItem.clone()");
                return ItemBuilderExtensions.modify((ItemStack)itemStack, (Function1)((Function1)new Function1<ItemBuilder, Unit>(this.this$0, player){
                    final /* synthetic */ Quest this$0;
                    final /* synthetic */ Player $player;
                    {
                        this.this$0 = quest;
                        this.$player = player;
                        super(1);
                    }

                    public final void invoke(@NotNull ItemBuilder itemBuilder) {
                        Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"$this$modify");
                        List list = Quest.access$getPlugin$p(this.this$0).getConfigYml().getStrings("quests.icon.lore");
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"plugin.configYml.getStrings(\"quests.icon.lore\")");
                        itemBuilder.addLoreLines(this.this$0.addPlaceholdersInto(list, this.$player));
                        itemBuilder.addLoreLines(Quest.access$getStartConditions$p(this.this$0).getNotMetLines(this.$player, (ProvidedHolder)EmptyProvidedHolder.INSTANCE));
                        itemBuilder.setDisplayName((String)CollectionsKt.first(this.this$0.addPlaceholdersInto(CollectionsKt.listOf((Object)Quest.access$getPlugin$p(this.this$0).getConfigYml().getString("quests.icon.name")), this.$player)));
                    }
                }));
            }
        }), (Function1)slot.2.INSTANCE);
        this.showsInGui = this.config.getBool("gui.enabled");
        this.alwaysInGUI = this.config.getBool("gui.always");
        List list2 = this.config.getSubsections("tasks");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"config.getSubsections(\"tasks\")");
        Iterable iterable = list2;
        Quest quest = this;
        int n = 0;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl = false;
        Iterable iterable3 = iterable2;
        boolean bl2 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Task task;
            Object t;
            Object t2 = t = iterator.next();
            boolean bl3 = false;
            Config config2 = (Config)t2;
            boolean bl4 = false;
            TaskTemplate taskTemplate = Tasks.INSTANCE.get(config2.getString("task"));
            if (taskTemplate != null) {
                String string3 = config2.getString("xp");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.getString(\"xp\")");
                task = taskTemplate.create(this, string3);
            } else {
                task = null;
            }
            if (task == null) continue;
            Task task2 = task;
            boolean bl5 = false;
            collection.add(task2);
        }
        quest.availableTasks = (List)collection;
        n = this.config.getInt("task-amount");
        quest = this;
        boolean bl6 = false;
        int n2 = n < 0 ? this.availableTasks.size() : RangesKt.coerceAtMost((int)n, (int)this.availableTasks.size());
        quest.taskAmount = n2;
        this.savedTasksKey = new PersistentDataKey(this.plugin.createNamespacedKey("quest_" + this.getId() + "_tasks"), PersistentDataKeyType.STRING_LIST, (Object)CollectionsKt.emptyList());
        Quest quest2 = this;
        quest = this;
        bl6 = false;
        if (quest2.isResettable()) {
            list = quest2.loadTasks();
            if (list == null) {
                list = ListUtilsKt.randomlyPick((Collection)quest2.availableTasks, quest2.taskAmount);
            }
        } else {
            list = ListUtilsKt.randomlyPick((Collection)quest2.availableTasks, quest2.taskAmount);
        }
        quest.tasks = list;
        this.hasStartedKey = new PersistentDataKey(this.plugin.createNamespacedKey("quest_" + this.getId() + "_has_started"), PersistentDataKeyType.BOOLEAN, (Object)false);
        this.startedTimeKey = new PersistentDataKey(this.plugin.createNamespacedKey("quest_" + this.getId() + "_started_time"), PersistentDataKeyType.INT, (Object)Integer.MAX_VALUE);
        this.hasCompletedKey = new PersistentDataKey(this.plugin.createNamespacedKey("quest_" + this.getId() + "_has_completed"), PersistentDataKeyType.BOOLEAN, (Object)false);
        this.completedTimeKey = new PersistentDataKey(this.plugin.createNamespacedKey("quest_" + this.getId() + "_completed_time"), PersistentDataKeyType.INT, (Object)Integer.MAX_VALUE);
        List list3 = this.config.getStrings("reward-messages");
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"config.getStrings(\"reward-messages\")");
        this.rewardMessages = list3;
        List list4 = this.config.getSubsections("rewards");
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"config.getSubsections(\"rewards\")");
        this.rewards = Effects.INSTANCE.compileChain((Collection)list4, (ChainExecutor)NormalExecutorFactory.INSTANCE.create(), new ViolationContext(this.plugin, "quest " + this.getId() + " rewards"));
        List list5 = this.config.getSubsections("start-effects");
        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"config.getSubsections(\"start-effects\")");
        this.startEffects = Effects.INSTANCE.compileChain((Collection)list5, (ChainExecutor)NormalExecutorFactory.INSTANCE.create(), new ViolationContext(this.plugin, "quest " + this.getId() + " start-effects"));
        List list6 = this.config.getSubsections("start-conditions");
        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"config.getSubsections(\"start-conditions\")");
        this.startConditions = Conditions.INSTANCE.compile((Collection)list6, new ViolationContext(this.plugin, "quest " + this.getId() + " start-conditions"));
        this.lastResetTimeKey = new PersistentDataKey(this.plugin.createNamespacedKey("quest_" + this.getId() + "_last_reset_time"), PersistentDataKeyType.INT, (Object)0);
        this.resetTime = this.config.getInt("reset-time");
        new PlayerlessPlaceholder(this.plugin, "quest_" + this.getId() + "_name", () -> Quest._init_$lambda-3(this)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_description", arg_0 -> Quest._init_$lambda-4(this, arg_0)).register();
        new PlayerlessPlaceholder(this.plugin, "quest_" + this.getId() + "_tasks", () -> Quest._init_$lambda-5(this)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_started", arg_0 -> Quest._init_$lambda-6(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_completed", arg_0 -> Quest._init_$lambda-7(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_tasks_completed", arg_0 -> Quest._init_$lambda-9(this, arg_0)).register();
        new PlayerlessPlaceholder(this.plugin, "quest_" + this.getId() + "_time_until_reset", () -> Quest._init_$lambda-10(this)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_time_since_start", arg_0 -> Quest._init_$lambda-11(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_time_since_completed", arg_0 -> Quest._init_$lambda-12(this, arg_0)).register();
        new PlayerPlaceholder(this.plugin, "quest_" + this.getId() + "_time_since", arg_0 -> Quest._init_$lambda-13(this, arg_0)).register();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getAnnouncesStart() {
        return this.announcesStart;
    }

    public final boolean getAutoStarts() {
        return this.autoStarts;
    }

    @NotNull
    public final Slot getSlot() {
        return this.slot;
    }

    public final boolean getShowsInGui() {
        return this.showsInGui;
    }

    public final boolean getAlwaysInGUI() {
        return this.alwaysInGUI;
    }

    public final int getTaskAmount() {
        return this.taskAmount;
    }

    @NotNull
    public final List<Task> getTasks() {
        return this.tasks;
    }

    public final boolean isResettable() {
        return this.resetTime >= 0;
    }

    public final int getMinutesUntilReset() {
        int n;
        if (this.resetTime < 0) {
            n = Integer.MAX_VALUE;
        } else {
            Object object = ServerProfile.load().read(this.lastResetTimeKey);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"load().read(lastResetTimeKey)");
            int n2 = ((Number)object).intValue();
            n = this.resetTime - QuestKt.getCurrentTimeMinutes() + n2;
        }
        return n;
    }

    public void onRegister() {
        for (Task task : this.tasks) {
            task.bind();
        }
    }

    public void onRemove() {
        if (this.isResettable()) {
            this.saveTasks();
        }
        for (Task task : this.tasks) {
            task.unbind();
        }
    }

    @Nullable
    public final Task getTask(@NotNull TaskTemplate taskTemplate) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)taskTemplate, (String)"template");
            Iterable iterable = this.tasks;
            boolean bl = false;
            for (Object t : iterable) {
                Task task = (Task)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)task.getTemplate(), (Object)taskTemplate)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<String> getDescription(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.addPlaceholdersInto(CollectionsKt.listOf((Object)this.config.getString("description")), player);
    }

    public final boolean hasActive(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        return this.hasStarted(offlinePlayer) && !this.hasCompleted(offlinePlayer);
    }

    public final boolean hasCompleted(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).read(this.hasCompletedKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(hasCompletedKey)");
        return (Boolean)object;
    }

    public final boolean meetsStartConditions(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.startConditions.areMet(player, (ProvidedHolder)EmptyProvidedHolder.INSTANCE);
    }

    public final boolean shouldStart(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.meetsStartConditions(player) && !this.hasStarted((OfflinePlayer)player) && this.autoStarts;
    }

    public final boolean hasStarted(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).read(this.hasStartedKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(hasStartedKey)");
        return (Boolean)object;
    }

    public final void reset(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).write(this.hasStartedKey, (Object)false);
        ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).write(this.hasCompletedKey, (Object)false);
        for (Task task : this.tasks) {
            task.reset(offlinePlayer);
        }
    }

    public final void start(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.hasStarted((OfflinePlayer)player)) {
            return;
        }
        Chain chain = this.startEffects;
        if (chain != null) {
            Chain.trigger$default((Chain)chain, (Player)player, null, null, null, (int)14, null);
        }
        ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.hasStartedKey, (Object)true);
        ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.startedTimeKey, (Object)QuestKt.getCurrentTimeMinutes());
        for (Task task : this.tasks) {
            task.reset((OfflinePlayer)player);
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerQuestStartEvent(player, this));
    }

    public final int getTimeSinceStart(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        int n = QuestKt.getCurrentTimeMinutes();
        Object object = ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).read(this.startedTimeKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(startedTimeKey)");
        return n - ((Number)object).intValue();
    }

    public final int getTimeSinceCompletion(@NotNull OfflinePlayer offlinePlayer) {
        Intrinsics.checkNotNullParameter((Object)offlinePlayer, (String)"player");
        int n = QuestKt.getCurrentTimeMinutes();
        Object object = ProfileExtensions.getProfile((OfflinePlayer)offlinePlayer).read(this.completedTimeKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(completedTimeKey)");
        return n - ((Number)object).intValue();
    }

    @NotNull
    public final String getTimeSincePlaceholder(@NotNull Player player) {
        String string;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.hasCompleted((OfflinePlayer)player)) {
            String string2 = this.plugin.getLangYml().getString("time-since.completed");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.langYml.getString(\"time-since.completed\")");
            string = StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)string2, (String)"%time%", (String)TimeKt.formatDuration(this.getTimeSinceCompletion((OfflinePlayer)player)), (boolean)false, (int)4, null), (Player)player, (boolean)false, (int)2, null);
        } else if (this.hasStarted((OfflinePlayer)player)) {
            String string3 = this.plugin.getLangYml().getString("time-since.started");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"plugin.langYml.getString(\"time-since.started\")");
            string = StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)string3, (String)"%time%", (String)TimeKt.formatDuration(this.getTimeSinceStart((OfflinePlayer)player)), (boolean)false, (int)4, null), (Player)player, (boolean)false, (int)2, null);
        } else {
            String string4 = this.plugin.getLangYml().getString("time-since.never");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"plugin.langYml.getString(\"time-since.never\")");
            string = StringUtilsExtensions.formatEco$default((String)string4, (Player)player, (boolean)false, (int)2, null);
        }
        return string;
    }

    public final void resetIfNeeded() {
        if (this.resetTime < 0) {
            return;
        }
        if (this.getMinutesUntilReset() > 0) {
            return;
        }
        this.reset();
    }

    public final void reset() {
        ServerProfile.load().write(this.lastResetTimeKey, (Object)((int)(System.currentTimeMillis() / (long)1000 / (long)60)));
        for (Player object : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player");
            this.reset((OfflinePlayer)object);
        }
        this.plugin.getScheduler().runAsync(() -> Quest.reset$lambda-15(this));
        for (Task task : this.tasks) {
            task.unbind();
        }
        this.tasks = ListUtilsKt.randomlyPick((Collection)this.availableTasks, this.taskAmount);
        for (Task task : this.tasks) {
            task.bind();
        }
        this.saveTasks();
    }

    private final List<Task> loadTasks() {
        Object object = ServerProfile.load().read(this.savedTasksKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"load().read(savedTasksKey)");
        List list = (List)object;
        if (list.isEmpty()) {
            return null;
        }
        List list2 = new ArrayList();
        for (String string : list) {
            TaskTemplate taskTemplate;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s");
            Object object2 = new String[]{":"};
            List list3 = StringsKt.split$default((CharSequence)string, (String[])object2, (boolean)false, (int)0, (int)6, null);
            object2 = (String)list3.get(0);
            String string2 = (String)list3.get(1);
            if (Tasks.INSTANCE.get((String)object2) == null) continue;
            ((Collection)list2).add(taskTemplate.create(this, string2));
        }
        return list2;
    }

    private final void saveTasks() {
        Iterable iterable = this.tasks;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            Task task = (Task)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(task.getTemplate().getId() + ":" + task.getXpExpr$core_plugin());
        }
        List list = (List)collection;
        ServerProfile.load().write(this.savedTasksKey, (Object)list);
    }

    public final boolean checkCompletion(@NotNull Player player) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Object object = ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).read(this.hasCompletedKey);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.profile.read(hasCompletedKey)");
            if (((Boolean)object).booleanValue()) {
                return true;
            }
            Iterable iterable = this.tasks;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    Task task = (Task)t;
                    boolean bl3 = false;
                    if (task.hasCompleted((OfflinePlayer)player)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            this.complete(player);
            return true;
        }
        return false;
    }

    private final void complete(Player player) {
        ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.hasCompletedKey, (Object)true);
        ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.completedTimeKey, (Object)QuestKt.getCurrentTimeMinutes());
        Chain chain = this.rewards;
        if (chain != null) {
            Chain.trigger$default((Chain)chain, (Player)player, null, null, null, (int)14, null);
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerQuestCompleteEvent(player, this));
    }

    private final List<String> addMargin(List<String> list, int n) {
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(StringsKt.repeat((CharSequence)" ", (int)n) + string);
        }
        return (List)collection;
    }

    @NotNull
    public final List<String> addPlaceholdersInto(@NotNull List<String> list, @NotNull Player player) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter(list, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Quest quest = this;
        Iterable iterable = list;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            List<String> list2;
            object = (String)t;
            bl = false;
            int n = ((String)object).length() - ((Object)StringsKt.trimStart((CharSequence)((CharSequence)object))).toString().length();
            if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"%rewards%", (boolean)false, (int)2, null)) {
                list2 = this.addMargin(this.rewardMessages, n);
            } else if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"%tasks%", (boolean)false, (int)2, null)) {
                Iterable iterable3 = this.tasks;
                Quest quest2 = this;
                boolean bl4 = false;
                Iterable iterable4 = iterable3;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
                boolean bl5 = false;
                for (Object t2 : iterable4) {
                    Task task = (Task)t2;
                    Collection collection3 = collection2;
                    boolean bl6 = false;
                    collection3.add(task.getCompletedDescription(player));
                }
                list2 = quest2.addMargin((List)collection2, n);
            } else {
                list2 = StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"%description%", (boolean)false, (int)2, null) ? this.addMargin(this.getDescription(player), n) : CollectionsKt.listOf((Object)object);
            }
            object = list2;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t : iterable2) {
            object = (String)t;
            Collection collection4 = collection;
            bl = false;
            collection4.add(Quest.addPlaceholdersInto$addPlaceholders((String)object, quest, this, player));
        }
        List list3 = (List)collection;
        return StringUtilsExtensions.lineWrap((List)StringUtilsExtensions.formatEco((List)list3, (PlaceholderContext)PlaceholderContextExtensions.placeholderContext$default((Player)player, null, null, null, (int)14, null)), (int)this.plugin.getConfigYml().getInt("quests.icon.line-wrap"), (boolean)true);
    }

    @NotNull
    public String getID() {
        return KRegistrable.DefaultImpls.getID((KRegistrable)this);
    }

    private static final String _init_$lambda-3(Quest quest) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        return quest.name;
    }

    private static final String _init_$lambda-4(Quest quest, Player player) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return CollectionsKt.joinToString$default((Iterable)quest.getDescription(player), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String _init_$lambda-5(Quest quest) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        return StringUtilsExtensions.toNiceString((Object)quest.tasks.size());
    }

    private static final String _init_$lambda-6(Quest quest, Player player) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return StringUtilsExtensions.toNiceString((Object)quest.hasStarted((OfflinePlayer)player));
    }

    private static final String _init_$lambda-7(Quest quest, Player player) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return StringUtilsExtensions.toNiceString((Object)quest.hasCompleted((OfflinePlayer)player));
    }

    private static final String _init_$lambda-9(Quest quest, Player player) {
        int n;
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        Iterable iterable = quest.tasks;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            n = 0;
        } else {
            int n2 = 0;
            for (Object t : iterable) {
                Task task = (Task)t;
                boolean bl2 = false;
                if (!task.hasCompleted((OfflinePlayer)player) || ++n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = n2;
        }
        return StringUtilsExtensions.toNiceString((Object)n);
    }

    private static final String _init_$lambda-10(Quest quest) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        return TimeKt.formatDuration(quest.getMinutesUntilReset());
    }

    private static final String _init_$lambda-11(Quest quest, Player player) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return TimeKt.formatDuration(quest.getTimeSinceStart((OfflinePlayer)player));
    }

    private static final String _init_$lambda-12(Quest quest, Player player) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return TimeKt.formatDuration(quest.getTimeSinceCompletion((OfflinePlayer)player));
    }

    private static final String _init_$lambda-13(Quest quest, Player player) {
        String string;
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        if (quest.hasCompleted((OfflinePlayer)player)) {
            String string2 = quest.plugin.getLangYml().getString("time-since.completed");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.langYml.getString(\"time-since.completed\")");
            string = StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)string2, (String)"%time%", (String)TimeKt.formatDuration(quest.getTimeSinceCompletion((OfflinePlayer)player)), (boolean)false, (int)4, null), (Player)player, (boolean)false, (int)2, null);
        } else if (quest.hasStarted((OfflinePlayer)player)) {
            String string3 = quest.plugin.getLangYml().getString("time-since.started");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"plugin.langYml.getString(\"time-since.started\")");
            string = StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)string3, (String)"%time%", (String)TimeKt.formatDuration(quest.getTimeSinceStart((OfflinePlayer)player)), (boolean)false, (int)4, null), (Player)player, (boolean)false, (int)2, null);
        } else {
            String string4 = quest.plugin.getLangYml().getString("time-since.never");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"plugin.langYml.getString(\"time-since.never\")");
            string = StringUtilsExtensions.formatEco$default((String)string4, (Player)player, (boolean)false, (int)2, null);
        }
        return string;
    }

    private static final void reset$lambda-15(Quest quest) {
        Intrinsics.checkNotNullParameter((Object)quest, (String)"this$0");
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayerArray, (String)"getOfflinePlayers()");
        for (OfflinePlayer offlinePlayer : offlinePlayerArray) {
            if (offlinePlayer.isOnline()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"player");
            quest.reset(offlinePlayer);
        }
    }

    private static final String addPlaceholdersInto$addPlaceholders(String string, Quest quest, Quest quest2, Player player) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%quest%", (String)quest.name, (boolean)false, (int)4, null), (String)"%time_until_reset%", (String)TimeKt.formatDuration(quest.getMinutesUntilReset()), (boolean)false, (int)4, null), (String)"%time_since%", (String)quest2.getTimeSincePlaceholder(player), (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ ItemStack access$getGuiItem$p(Quest quest) {
        return quest.guiItem;
    }

    public static final /* synthetic */ EcoPlugin access$getPlugin$p(Quest quest) {
        return quest.plugin;
    }

    public static final /* synthetic */ ConditionList access$getStartConditions$p(Quest quest) {
        return quest.startConditions;
    }
}

