/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests.libreforge.loader.internal;

import com.willfp.eco.core.data.ExternalDataStore;
import com.willfp.eco.core.data.ExternalDataStoreExtensions;
import com.willfp.eco.core.version.Version;
import com.willfp.ecoquests.libreforge.loader.LibreforgePlugin;
import com.willfp.ecoquests.libreforge.loader.internal.LibreforgeNotFoundError;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY", "", "HIGHEST_LIBREFORGE_VERSION_KEY", "checkHighestVersion", "", "plugin", "Lcom/willfp/ecoquests/libreforge/loader/LibreforgePlugin;", "loadHighestLibreforgeVersion", "pluginFolder", "Ljava/io/File;", "tryLoadForceVersion", "loader"})
public final class LibreforgeLoaderKt {
    @NotNull
    private static final String HIGHEST_LIBREFORGE_VERSION_KEY = "highest-libreforge-version";
    @NotNull
    private static final String HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY = "highest-libreforge-version-classloader";

    public static final void checkHighestVersion(@NotNull LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"plugin");
        String string = HIGHEST_LIBREFORGE_VERSION_KEY;
        boolean bl = false;
        boolean bl2 = false;
        Version version = new Version("0.0.0");
        boolean bl3 = false;
        Object object = ExternalDataStore.get((String)string, Version.class);
        if (object == null) {
            object = version;
        }
        Version version2 = (Version)object;
        if (libreforgePlugin.getLibreforgeVersion().compareTo(version2) > 0) {
            ExternalDataStoreExtensions.writeExternalData((String)HIGHEST_LIBREFORGE_VERSION_KEY, (Object)libreforgePlugin.getLibreforgeVersion());
            ClassLoader classLoader = ((Object)((Object)libreforgePlugin)).getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"plugin::class.java.classLoader");
            ExternalDataStoreExtensions.writeExternalData((String)HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY, (Object)classLoader);
        }
    }

    public static final void tryLoadForceVersion(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"pluginFolder");
        File file2 = FilesKt.resolve((File)file, (String)"libreforge");
        File file3 = FilesKt.resolve((File)file2, (String)"versions");
        if (!file3.exists()) {
            return;
        }
        for (File file4 : FilesKt.walk$default((File)file3, null, (int)1, null)) {
            if (!Intrinsics.areEqual((Object)file4.getName(), (Object)"libreforge.jar")) continue;
            Bukkit.getLogger().info("[libreforge] Found generic libreforge.jar!");
            Bukkit.getLogger().info("[libreforge] This version will be loaded instead of any versions bundled with plugins.");
            Bukkit.getPluginManager().loadPlugin(file4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadHighestLibreforgeVersion(@NotNull File file) {
        boolean bl;
        Object object;
        Object object2;
        block15: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"pluginFolder");
            Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)pluginArray, (String)"getPluginManager().plugins");
            object2 = pluginArray;
            boolean bl2 = false;
            for (Object object3 : object2) {
                object = (Plugin)object3;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)object.getName(), (Object)"libreforge")) continue;
                bl = true;
                break block15;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        Object object4 = HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY;
        int n = 0;
        ClassLoader classLoader = (ClassLoader)ExternalDataStore.get((String)object4, ClassLoader.class);
        if (classLoader == null) {
            throw new LibreforgeNotFoundError("No libreforge plugin classloader found");
        }
        object2 = classLoader;
        Object object5 = HIGHEST_LIBREFORGE_VERSION_KEY;
        boolean bl4 = false;
        Version version = (Version)ExternalDataStore.get((String)object5, Version.class);
        if (version == null) {
            throw new LibreforgeNotFoundError("No libreforge version found");
        }
        Version version2 = version;
        object4 = FilesKt.resolve((File)file, (String)"libreforge");
        object5 = FilesKt.resolve((File)object4, (String)"versions");
        ((File)object5).mkdirs();
        File file2 = FilesKt.resolve((File)object5, (String)("libreforge-" + version2 + ".jar"));
        object = "libreforge-" + version2 + "-shadow.jar";
        Closeable closeable = new FileOutputStream(file2);
        Throwable throwable = null;
        try {
            long l;
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            boolean bl5 = false;
            Closeable closeable2 = ((ClassLoader)object2).getResourceAsStream((String)object);
            Throwable throwable2 = null;
            try {
                InputStream inputStream = (InputStream)closeable2;
                boolean bl6 = false;
                InputStream inputStream2 = inputStream;
                if (inputStream2 == null) {
                    throw new LibreforgeNotFoundError("libreforge wasn't found in the plugin jar");
                }
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"inputStream");
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)fileOutputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Bukkit.getPluginManager().loadPlugin(file2);
    }
}

