/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests.libreforge.loader;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.LifecyclePosition;
import com.willfp.eco.core.PluginProps;
import com.willfp.eco.core.config.ConfigExtensions;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.core.registry.Registry;
import com.willfp.eco.core.version.Version;
import com.willfp.ecoquests.libreforge.loader.LibreforgePlugin;
import com.willfp.ecoquests.libreforge.loader.configs.ConfigCategory;
import com.willfp.ecoquests.libreforge.loader.configs.LegacyLocation;
import com.willfp.ecoquests.libreforge.loader.internal.InvalidLibreforgePluginError;
import com.willfp.ecoquests.libreforge.loader.internal.LibreforgeLoaderKt;
import com.willfp.ecoquests.libreforge.loader.internal.LoadedLibreforgePluginImpl;
import com.willfp.ecoquests.libreforge.loader.internal.configs.RegistrableConfig;
import com.willfp.libreforge.Plugins;
import com.willfp.libreforge.ViolationContext;
import com.willfp.libreforge.configs.LibreforgeConfigCategory;
import com.willfp.libreforge.configs.category.FoundConfig;
import com.willfp.libreforge.effects.Chain;
import com.willfp.libreforge.effects.Effects;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0010H\u0002J\u001a\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0014J&\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00182\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100+H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/willfp/ecoquests/libreforge/loader/LibreforgePlugin;", "Lcom/willfp/eco/core/EcoPlugin;", "()V", "categories", "Lcom/willfp/eco/core/registry/Registry;", "Lcom/willfp/libreforge/configs/LibreforgeConfigCategory;", "getCategories", "()Lcom/willfp/eco/core/registry/Registry;", "libreforgeVersion", "Lcom/willfp/eco/core/version/Version;", "getLibreforgeVersion", "()Lcom/willfp/eco/core/version/Version;", "loaderCategories", "", "Lcom/willfp/ecoquests/libreforge/loader/configs/ConfigCategory;", "addCategory", "", "category", "competeForVersion", "copyConfigs", "doFetchConfigs", "", "Lcom/willfp/ecoquests/libreforge/loader/internal/configs/RegistrableConfig;", "directory", "", "fetchConfigs", "", "getDefaultConfigNames", "", "getFile", "Ljava/io/File;", "getMinimumEcoVersion", "loadCategories", "loadCategory", "preload", "", "loadConfigCategories", "mutateProps", "Lcom/willfp/eco/core/PluginProps;", "props", "withLogs", "position", "block", "Lkotlin/Function0;", "RegistryLock", "loader"})
public abstract class LibreforgePlugin
extends EcoPlugin {
    @NotNull
    private final List<ConfigCategory> loaderCategories = new ArrayList();
    @NotNull
    private final Registry<LibreforgeConfigCategory> categories = new Registry();
    @NotNull
    private final Version libreforgeVersion;

    public LibreforgePlugin() {
        String string = this.getProps().getEnvironmentVariable("libreforge version");
        if (string == null) {
            throw new InvalidLibreforgePluginError("libreforge version environment variable not set!");
        }
        this.libreforgeVersion = new Version(string);
        this.categories.lock((Object)RegistryLock.INSTANCE);
        File file = this.getDataFolder().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dataFolder.parentFile");
        LibreforgeLoaderKt.tryLoadForceVersion(file);
        this.competeForVersion();
        this.onLoad(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda-0(this));
        this.onLoad(LifecyclePosition.END, () -> LibreforgePlugin._init_$lambda-2(this));
        this.onEnable(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda-3(this));
        this.onReload(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda-5(this));
        this.onReload(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda-6(this));
        this.onDisable(LifecyclePosition.END, () -> LibreforgePlugin._init_$lambda-7(this));
    }

    @NotNull
    public final Registry<LibreforgeConfigCategory> getCategories() {
        return this.categories;
    }

    @NotNull
    public final Version getLibreforgeVersion() {
        return this.libreforgeVersion;
    }

    private final void loadCategory(ConfigCategory configCategory, boolean bl) {
        this.withLogs(configCategory, "before reload", (Function0<Unit>)((Function0)new Function0<Unit>(configCategory, this){
            final /* synthetic */ ConfigCategory $category;
            final /* synthetic */ LibreforgePlugin this$0;
            {
                this.$category = configCategory;
                this.this$0 = libreforgePlugin;
                super(0);
            }

            public final void invoke() {
                this.$category.beforeReload(this.this$0);
            }
        }));
        this.withLogs(configCategory, "clear", (Function0<Unit>)((Function0)new Function0<Unit>(configCategory, this){
            final /* synthetic */ ConfigCategory $category;
            final /* synthetic */ LibreforgePlugin this$0;
            {
                this.$category = configCategory;
                this.this$0 = libreforgePlugin;
                super(0);
            }

            public final void invoke() {
                this.$category.clear(this.this$0);
                this.$category.getHandle$loader().clear();
            }
        }));
        for (RegistrableConfig object : this.fetchConfigs(configCategory)) {
            this.withLogs(configCategory, "loading config " + object.getId(), (Function0<Unit>)((Function0)new Function0<Unit>(configCategory, object, bl, this){
                final /* synthetic */ ConfigCategory $category;
                final /* synthetic */ RegistrableConfig $config;
                final /* synthetic */ boolean $preload;
                final /* synthetic */ LibreforgePlugin this$0;
                {
                    this.$category = configCategory;
                    this.$config = registrableConfig;
                    this.$preload = bl;
                    this.this$0 = libreforgePlugin;
                    super(0);
                }

                public final void invoke() {
                    this.$category.getHandle$loader().register((Registrable)this.$config.getHandle());
                    if (this.$preload) {
                        this.$category.acceptPreloadConfig(this.this$0, this.$config.getId(), this.$config.getConfig());
                    } else {
                        this.$category.acceptConfig(this.this$0, this.$config.getId(), this.$config.getConfig());
                    }
                }
            }));
        }
        LegacyLocation legacyLocation = configCategory.getLegacyLocation();
        if (legacyLocation != null) {
            for (Config config : legacyLocation.getConfig(this).getSubsections(legacyLocation.getSection())) {
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)config.getString("id"), (String)"config.getString(\"id\")");
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
                RegistrableConfig registrableConfig = new RegistrableConfig(config, null, string, configCategory);
                this.withLogs(configCategory, "loading legacy config " + string, (Function0<Unit>)((Function0)new Function0<Unit>(configCategory, registrableConfig, this, string){
                    final /* synthetic */ ConfigCategory $category;
                    final /* synthetic */ RegistrableConfig $registrable;
                    final /* synthetic */ LibreforgePlugin this$0;
                    final /* synthetic */ String $id;
                    {
                        this.$category = configCategory;
                        this.$registrable = registrableConfig;
                        this.this$0 = libreforgePlugin;
                        this.$id = string;
                        super(0);
                    }

                    public final void invoke() {
                        this.$category.getHandle$loader().register((Registrable)this.$registrable.getHandle());
                        this.$category.acceptConfig(this.this$0, this.$id, this.$registrable.getConfig());
                    }
                }));
            }
        }
        this.withLogs(configCategory, "after reload", (Function0<Unit>)((Function0)new Function0<Unit>(configCategory, this){
            final /* synthetic */ ConfigCategory $category;
            final /* synthetic */ LibreforgePlugin this$0;
            {
                this.$category = configCategory;
                this.this$0 = libreforgePlugin;
                super(0);
            }

            public final void invoke() {
                this.$category.afterReload(this.this$0);
            }
        }));
    }

    static /* synthetic */ void loadCategory$default(LibreforgePlugin libreforgePlugin, ConfigCategory configCategory, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadCategory");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        libreforgePlugin.loadCategory(configCategory, bl);
    }

    private final void withLogs(ConfigCategory configCategory, String string, Function0<Unit> function0) {
        try {
            function0.invoke();
        }
        catch (Exception exception) {
            this.getLogger().warning("Exception loading " + configCategory.getId() + " at " + string + "!");
            exception.printStackTrace();
        }
    }

    private final void competeForVersion() {
        LibreforgeLoaderKt.checkHighestVersion(this);
    }

    private final void loadCategories() {
        for (ConfigCategory configCategory : this.loadConfigCategories()) {
            this.addCategory(configCategory);
        }
    }

    private final void copyConfigs(ConfigCategory configCategory) {
        File file = this.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dataFolder");
        File file2 = FilesKt.resolve((File)file, (String)configCategory.getDirectory());
        if (!file2.exists()) {
            Iterable iterable = this.getDefaultConfigNames(configCategory);
            boolean bl = false;
            for (Object t : iterable) {
                String string = (String)t;
                boolean bl2 = false;
                new FoundConfig(string, configCategory.getDirectory(), (EcoPlugin)this).copy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> getDefaultConfigNames(ConfigCategory configCategory) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        List list = new ArrayList();
        try {
            object3 = new ZipFile(this.getFile());
            Throwable throwable = null;
            try {
                object2 = (ZipFile)object3;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object2).entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
                Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<ZipEntry, Boolean>(configCategory){
                    final /* synthetic */ ConfigCategory $category;
                    {
                        this.$category = configCategory;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(ZipEntry zipEntry) {
                        String string = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        return StringsKt.startsWith$default((String)string, (String)(this.$category.getDirectory() + "/"), (boolean)false, (int)2, null);
                    }
                }));
                boolean bl2 = false;
                for (String string2 : sequence) {
                    ZipEntry zipEntry = (ZipEntry)((Object)string2);
                    Collection collection = list;
                    boolean bl3 = false;
                    String string3 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                    collection.add(StringsKt.removePrefix((String)string3, (CharSequence)(configCategory.getDirectory() + "/")));
                }
                object2 = (List)((Collection)list);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = list;
        boolean bl = false;
        object2 = object3;
        Collection collection = new ArrayList();
        boolean bl4 = false;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            string2 = (String)object;
            boolean bl5 = false;
            if (!StringsKt.endsWith$default((String)string2, (String)".yml", (boolean)false, (int)2, null)) continue;
            collection.add(object);
        }
        object3 = (List)collection;
        bl = false;
        object2 = object3;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        bl4 = false;
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            string2 = (String)object;
            Collection collection2 = collection;
            boolean bl6 = false;
            collection2.add(StringsKt.removeSuffix((String)string2, (CharSequence)".yml"));
        }
        return (List)collection;
    }

    private final List<RegistrableConfig> fetchConfigs(ConfigCategory configCategory) {
        Set set = new LinkedHashSet();
        CollectionsKt.addAll((Collection)set, (Iterable)this.doFetchConfigs(configCategory, configCategory.getDirectory()));
        Object object = configCategory.getLegacyLocation();
        if (object != null && (object = ((LegacyLocation)object).getAlternativeDirectories()) != null) {
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            for (Object t : iterable) {
                String string = (String)t;
                boolean bl2 = false;
                CollectionsKt.addAll((Collection)set, (Iterable)this.doFetchConfigs(configCategory, string));
            }
        }
        Iterable iterable = set;
        boolean bl = false;
        iterable = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            public final int compare(T t, T t2) {
                RegistrableConfig registrableConfig = (RegistrableConfig)t;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)registrableConfig.getId());
                registrableConfig = (RegistrableConfig)t2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)registrableConfig.getId())));
            }
        });
        bl = false;
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            public final int compare(T t, T t2) {
                RegistrableConfig registrableConfig = (RegistrableConfig)t;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(registrableConfig.getConfig().getInt("load-weight", 100));
                registrableConfig = (RegistrableConfig)t2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(registrableConfig.getConfig().getInt("load-weight", 100)));
            }
        });
    }

    private final Set<RegistrableConfig> doFetchConfigs(ConfigCategory configCategory, String string) {
        File file = this.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dataFolder");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)FilesKt.resolve((File)file, (String)string), null, (int)1, null)), (Function1)doFetchConfigs.1.INSTANCE), (Function1)((Function1)new Function1<File, RegistrableConfig>(configCategory){
            final /* synthetic */ ConfigCategory $category;
            {
                this.$category = configCategory;
                super(1);
            }

            @NotNull
            public final RegistrableConfig invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = FilesKt.getNameWithoutExtension((File)file);
                Config config = ConfigExtensions.readConfig((File)file);
                return new RegistrableConfig(config, file, string, this.$category);
            }
        })));
    }

    @NotNull
    public File getFile() {
        File file = super.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"super.getFile()");
        return file;
    }

    @NotNull
    protected PluginProps mutateProps(@NotNull PluginProps pluginProps) {
        PluginProps pluginProps2;
        Intrinsics.checkNotNullParameter((Object)pluginProps, (String)"props");
        PluginProps pluginProps3 = pluginProps2 = pluginProps;
        boolean bl = false;
        pluginProps3.setSupportingExtensions(true);
        return pluginProps2;
    }

    @NotNull
    public String getMinimumEcoVersion() {
        return "6.63.0";
    }

    @NotNull
    public List<ConfigCategory> loadConfigCategories() {
        return CollectionsKt.emptyList();
    }

    public final void addCategory(@NotNull ConfigCategory configCategory) {
        Intrinsics.checkNotNullParameter((Object)configCategory, (String)"category");
        this.categories.unlock((Object)RegistryLock.INSTANCE);
        configCategory.makeHandle$loader(this);
        this.copyConfigs(configCategory);
        ((Collection)this.loaderCategories).add(configCategory);
        this.categories.register((Registrable)configCategory.getHandle$loader());
        this.categories.lock((Object)RegistryLock.INSTANCE);
    }

    private static final void _init_$lambda-0(LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"this$0");
        File file = libreforgePlugin.getDataFolder().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dataFolder.parentFile");
        LibreforgeLoaderKt.loadHighestLibreforgeVersion(file);
        File file2 = libreforgePlugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"this.dataFolder");
        FilesKt.resolve((File)file2, (String)"lrcdb.yml").delete();
    }

    private static final void _init_$lambda-2(LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"this$0");
        libreforgePlugin.loadCategories();
        Object object2 = libreforgePlugin.loaderCategories;
        boolean bl = false;
        Iterable iterable = object2;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable) {
            ConfigCategory configCategory = (ConfigCategory)t;
            boolean bl3 = false;
            if (!configCategory.getShouldPreload()) continue;
            collection.add(t);
        }
        for (Object object2 : (List)collection) {
            libreforgePlugin.loadCategory((ConfigCategory)object2, true);
        }
    }

    private static final void _init_$lambda-3(LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"this$0");
        Plugins.INSTANCE.register((Registrable)new LoadedLibreforgePluginImpl(libreforgePlugin));
    }

    private static final void _init_$lambda-5(LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"this$0");
        File file = libreforgePlugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"this.dataFolder");
        File file22 = FilesKt.resolve((File)file, (String)"chains.yml");
        boolean bl = false;
        Config config = file22.exists() ? ConfigExtensions.readConfig((File)file22) : ConfigExtensions.emptyConfig();
        for (File file22 : config.getSubsections("chains")) {
            String string = file22.getString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.getString(\"id\")");
            List list = file22.getSubsections("effects");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"config.getSubsections(\"effects\")");
            Chain chain = Effects.INSTANCE.compileChain((Collection)list, new ViolationContext((EcoPlugin)libreforgePlugin, "chains.yml"));
            if (chain == null) continue;
            Effects.INSTANCE.register(string, chain);
        }
    }

    private static final void _init_$lambda-6(LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"this$0");
        for (ConfigCategory configCategory : libreforgePlugin.loaderCategories) {
            LibreforgePlugin.loadCategory$default(libreforgePlugin, configCategory, false, 2, null);
        }
    }

    private static final void _init_$lambda-7(LibreforgePlugin libreforgePlugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)libreforgePlugin), (String)"this$0");
        for (ConfigCategory configCategory : libreforgePlugin.loaderCategories) {
            libreforgePlugin.withLogs(configCategory, "clear", (Function0<Unit>)((Function0)new Function0<Unit>(configCategory, libreforgePlugin){
                final /* synthetic */ ConfigCategory $category;
                final /* synthetic */ LibreforgePlugin this$0;
                {
                    this.$category = configCategory;
                    this.this$0 = libreforgePlugin;
                    super(0);
                }

                public final void invoke() {
                    this.$category.clear(this.this$0);
                    this.$category.getHandle$loader().clear();
                }
            }));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/willfp/ecoquests/libreforge/loader/LibreforgePlugin$RegistryLock;", "", "()V", "loader"})
    private static final class RegistryLock {
        @NotNull
        public static final RegistryLock INSTANCE = new RegistryLock();

        private RegistryLock() {
        }
    }
}

