/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests.gui.components;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.util.MenuUtils;
import com.willfp.ecoquests.gui.components.PositionedComponent;
import com.willfp.ecoquests.quests.Quest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0006J*\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/willfp/ecoquests/gui/components/QuestAreaComponent;", "Lcom/willfp/ecoquests/gui/components/PositionedComponent;", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "getQuests", "Lkotlin/Function1;", "Lorg/bukkit/entity/Player;", "", "Lcom/willfp/ecoquests/quests/Quest;", "(Lcom/willfp/eco/core/config/interfaces/Config;Lkotlin/jvm/functions/Function1;)V", "column", "", "getColumn", "()I", "columnSize", "getColumnSize", "pageSize", "row", "getRow", "rowSize", "getRowSize", "getPages", "player", "getSlotAt", "Lcom/willfp/eco/core/gui/slot/Slot;", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "core-plugin"})
public final class QuestAreaComponent
implements PositionedComponent {
    @NotNull
    private final Function1<Player, List<Quest>> getQuests;
    private final int row;
    private final int column;
    private final int rowSize;
    private final int columnSize;
    private final int pageSize;

    public QuestAreaComponent(@NotNull Config config, @NotNull Function1<? super Player, ? extends List<Quest>> function1) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(function1, (String)"getQuests");
        this.getQuests = function1;
        this.row = config.getInt("top-left.row");
        this.column = config.getInt("top-left.column");
        this.rowSize = config.getInt("bottom-right.row") - this.getRow() + 1;
        this.columnSize = config.getInt("bottom-right.column") - this.getColumn() + 1;
        this.pageSize = this.getRowSize() * this.getColumnSize();
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }

    @Override
    public int getColumnSize() {
        return this.columnSize;
    }

    public final int getPages(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int n = ((List)this.getQuests.invoke((Object)player)).size();
        int n2 = this.pageSize;
        int n3 = n / n2;
        if ((n ^ n2) < 0 && n3 * n2 != n) {
            --n3;
        }
        return n3 + 1;
    }

    @Nullable
    public Slot getSlotAt(int n, int n2, @NotNull Player player, @NotNull Menu menu) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        int n3 = menu.getPage(player);
        int n4 = MenuUtils.rowColumnToSlot((int)n, (int)n2, (int)this.getColumnSize()) + (n3 - 1) * this.pageSize;
        Iterable iterable = (Iterable)this.getQuests.invoke((Object)player);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            Quest quest = (Quest)t;
            boolean bl3 = false;
            if (!quest.getShowsInGui()) continue;
            collection.add(t);
        }
        Quest quest = (Quest)CollectionsKt.getOrNull((List)((List)collection), (int)n4);
        return quest != null ? quest.getSlot() : null;
    }

    @Override
    public boolean isEnabled() {
        return PositionedComponent.DefaultImpls.isEnabled(this);
    }

    @Override
    public int getRows() {
        return PositionedComponent.DefaultImpls.getRows(this);
    }

    @Override
    public int getColumns() {
        return PositionedComponent.DefaultImpls.getColumns(this);
    }
}

