/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoquests;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.command.impl.PluginCommand;
import com.willfp.eco.core.placeholder.PlayerPlaceholder;
import com.willfp.eco.core.placeholder.PlayerlessPlaceholder;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecoquests.commands.CommandEcoQuests;
import com.willfp.ecoquests.commands.CommandQuests;
import com.willfp.ecoquests.gui.PreviousQuestsGUI;
import com.willfp.ecoquests.gui.QuestsGUI;
import com.willfp.ecoquests.libreforge.ConditionHasCompletedQuest;
import com.willfp.ecoquests.libreforge.ConditionHasCompletedTask;
import com.willfp.ecoquests.libreforge.ConditionHasQuestActive;
import com.willfp.ecoquests.libreforge.EffectGainTaskXp;
import com.willfp.ecoquests.libreforge.EffectGiveTaskXp;
import com.willfp.ecoquests.libreforge.EffectQuestXpMultiplier;
import com.willfp.ecoquests.libreforge.EffectStartQuest;
import com.willfp.ecoquests.libreforge.FilterQuest;
import com.willfp.ecoquests.libreforge.FilterTask;
import com.willfp.ecoquests.libreforge.TriggerCompleteQuest;
import com.willfp.ecoquests.libreforge.TriggerCompleteTask;
import com.willfp.ecoquests.libreforge.TriggerGainTaskXp;
import com.willfp.ecoquests.libreforge.TriggerStartQuest;
import com.willfp.ecoquests.libreforge.loader.LibreforgePlugin;
import com.willfp.ecoquests.libreforge.loader.configs.ConfigCategory;
import com.willfp.ecoquests.quests.Quest;
import com.willfp.ecoquests.quests.QuestCompleteDisplay;
import com.willfp.ecoquests.quests.QuestStartDisplay;
import com.willfp.ecoquests.quests.Quests;
import com.willfp.ecoquests.tasks.Tasks;
import com.willfp.libreforge.conditions.Conditions;
import com.willfp.libreforge.effects.Effects;
import com.willfp.libreforge.filters.Filters;
import com.willfp.libreforge.triggers.Triggers;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0004H\u0014J\b\u0010\u0006\u001a\u00020\u0004H\u0014J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0014J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/willfp/ecoquests/EcoQuestsPlugin;", "Lcom/willfp/ecoquests/libreforge/loader/LibreforgePlugin;", "()V", "createTasks", "", "handleEnable", "handleReload", "loadConfigCategories", "", "Lcom/willfp/ecoquests/libreforge/loader/configs/ConfigCategory;", "loadListeners", "Lorg/bukkit/event/Listener;", "loadPluginCommands", "Lcom/willfp/eco/core/command/impl/PluginCommand;", "core-plugin"})
public final class EcoQuestsPlugin
extends LibreforgePlugin {
    protected void handleEnable() {
        Conditions.INSTANCE.register((Registrable)ConditionHasCompletedQuest.INSTANCE);
        Conditions.INSTANCE.register((Registrable)ConditionHasCompletedTask.INSTANCE);
        Conditions.INSTANCE.register((Registrable)ConditionHasQuestActive.INSTANCE);
        Effects.INSTANCE.register((Registrable)EffectGainTaskXp.INSTANCE);
        Effects.INSTANCE.register((Registrable)EffectGiveTaskXp.INSTANCE);
        Effects.INSTANCE.register((Registrable)EffectQuestXpMultiplier.INSTANCE);
        Effects.INSTANCE.register((Registrable)EffectStartQuest.INSTANCE);
        Filters.INSTANCE.register((Registrable)FilterQuest.INSTANCE);
        Filters.INSTANCE.register((Registrable)FilterTask.INSTANCE);
        Triggers.INSTANCE.register((Registrable)TriggerCompleteQuest.INSTANCE);
        Triggers.INSTANCE.register((Registrable)TriggerCompleteTask.INSTANCE);
        Triggers.INSTANCE.register((Registrable)TriggerGainTaskXp.INSTANCE);
        Triggers.INSTANCE.register((Registrable)TriggerStartQuest.INSTANCE);
        new PlayerlessPlaceholder((EcoPlugin)this, "quests_amount", EcoQuestsPlugin::handleEnable$lambda-0).register();
        new PlayerPlaceholder((EcoPlugin)this, "quests_completed", EcoQuestsPlugin::handleEnable$lambda-1).register();
        new PlayerPlaceholder((EcoPlugin)this, "quests_percent_completed", EcoQuestsPlugin::handleEnable$lambda-2).register();
        new PlayerPlaceholder((EcoPlugin)this, "quests_active", EcoQuestsPlugin::handleEnable$lambda-3).register();
        new PlayerPlaceholder((EcoPlugin)this, "recent_quest_name", EcoQuestsPlugin::handleEnable$lambda-5).register();
    }

    protected void handleReload() {
        PreviousQuestsGUI.INSTANCE.reload(this);
        QuestsGUI.INSTANCE.reload(this);
    }

    protected void createTasks() {
        long l = this.getConfigYml().getInt("scan-interval");
        this.getScheduler().runTimer(l, l, EcoQuestsPlugin::createTasks$lambda-6);
        this.getScheduler().runTimer(20L, 20L, EcoQuestsPlugin::createTasks$lambda-7);
    }

    @NotNull
    protected List<Listener> loadListeners() {
        Object[] objectArray = new Listener[]{new QuestCompleteDisplay(this), new QuestStartDisplay(this)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<PluginCommand> loadPluginCommands() {
        Object[] objectArray = new PluginCommand[]{new CommandEcoQuests(this), new CommandQuests(this)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<ConfigCategory> loadConfigCategories() {
        Object[] objectArray = new ConfigCategory[]{Tasks.INSTANCE, Quests.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final String handleEnable$lambda-0() {
        return String.valueOf(Quests.INSTANCE.values().size());
    }

    private static final String handleEnable$lambda-1(Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return String.valueOf(Quests.INSTANCE.getCompletedQuests(player).size());
    }

    private static final String handleEnable$lambda-2(Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        int n = Quests.INSTANCE.getCompletedQuests(player).size();
        int n2 = Quests.INSTANCE.values().size();
        double d = (double)n / (double)n2 * 100.0;
        return StringUtilsExtensions.toNiceString((Object)d);
    }

    private static final String handleEnable$lambda-3(Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        return String.valueOf(Quests.INSTANCE.getActiveQuests(player).size());
    }

    private static final String handleEnable$lambda-5(Player player) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)player, (String)"it");
        Iterable iterable = Quests.INSTANCE.getActiveQuests(player);
        boolean bl = false;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Object t2 = iterator.next();
        if (!iterator.hasNext()) {
            t = t2;
        } else {
            Quest quest = (Quest)t2;
            boolean bl2 = false;
            int n = quest.getTimeSinceStart((OfflinePlayer)player);
            do {
                Object t3 = iterator.next();
                Quest quest2 = (Quest)t3;
                boolean bl3 = false;
                int n2 = quest2.getTimeSinceStart((OfflinePlayer)player);
                if (n <= n2) continue;
                t2 = t3;
                n = n2;
            } while (iterator.hasNext());
            t = t2;
        }
        return ((Quest)t).getName();
    }

    private static final void createTasks$lambda-6() {
        for (Quest quest : Quests.INSTANCE.values()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                if (!quest.shouldStart(player)) continue;
                quest.start(player);
            }
        }
    }

    private static final void createTasks$lambda-7() {
        for (Quest quest : Quests.INSTANCE.values()) {
            quest.resetIfNeeded();
        }
    }
}

