/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecopets.pets.entity;

import com.willfp.ecopets.EcoPetsPlugin;
import com.willfp.ecopets.modelenginebridge.BridgedActiveModel;
import com.willfp.ecopets.modelenginebridge.BridgedModeledEntity;
import com.willfp.ecopets.modelenginebridge.ModelEngineBridge;
import com.willfp.ecopets.pets.Pet;
import com.willfp.ecopets.pets.entity.PetEntity;
import com.willfp.ecopets.pets.entity.PetEntityKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/ecopets/pets/entity/ModelEnginePetEntity;", "Lcom/willfp/ecopets/pets/entity/PetEntity;", "pet", "Lcom/willfp/ecopets/pets/Pet;", "modelID", "", "plugin", "Lcom/willfp/ecopets/EcoPetsPlugin;", "(Lcom/willfp/ecopets/pets/Pet;Ljava/lang/String;Lcom/willfp/ecopets/EcoPetsPlugin;)V", "spawn", "Lorg/bukkit/entity/ArmorStand;", "location", "Lorg/bukkit/Location;", "core-plugin"})
public final class ModelEnginePetEntity
extends PetEntity {
    @NotNull
    private final String modelID;
    @NotNull
    private final EcoPetsPlugin plugin;

    public ModelEnginePetEntity(@NotNull Pet pet, @NotNull String modelID, @NotNull EcoPetsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        Intrinsics.checkNotNullParameter((Object)modelID, (String)"modelID");
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        super(pet);
        this.modelID = modelID;
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public ArmorStand spawn(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ArmorStand stand = PetEntityKt.emptyArmorStandAt(location, this.getPet());
        BridgedActiveModel bridgedActiveModel = ModelEngineBridge.Companion.getInstance().createActiveModel(this.modelID);
        if (bridgedActiveModel == null) {
            return stand;
        }
        BridgedActiveModel model = bridgedActiveModel;
        BridgedModeledEntity modelled = ModelEngineBridge.Companion.getInstance().createModeledEntity((Entity)stand);
        modelled.addModel(model);
        return stand;
    }
}

