/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecopets.pets;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.ecopets.pets.Pet;
import com.willfp.ecopets.pets.PetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/ecopets/pets/SpawnEggHandler;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "handle", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "core-plugin"})
public final class SpawnEggHandler
implements Listener {
    @NotNull
    private final EcoPlugin plugin;

    public SpawnEggHandler(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public final void handle(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        Pet pet = PetKt.getPetEgg(item);
        if (pet == null) {
            return;
        }
        Pet pet2 = pet;
        event.setCancelled(true);
        event.setUseItemInHand(Event.Result.DENY);
        if (PetKt.hasPet((OfflinePlayer)player2, pet2)) {
            player2.sendMessage(this.plugin.getLangYml().getMessage("cannot-spawn-pet"));
            return;
        }
        if (event.getHand() == EquipmentSlot.HAND) {
            ItemStack itemStack2 = event.getPlayer().getInventory().getItemInMainHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemInMainHand(...)");
            ItemStack hand = itemStack2;
            hand.setAmount(hand.getAmount() - 1);
        } else {
            ItemStack itemStack3 = event.getPlayer().getInventory().getItemInOffHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getItemInOffHand(...)");
            ItemStack hand = itemStack3;
            hand.setAmount(hand.getAmount() - 1);
        }
        PetKt.setPetLevel((OfflinePlayer)player2, pet2, 1);
    }
}

