/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecopets.pets;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.GUIHelperExtensions;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuBuilder;
import com.willfp.eco.core.gui.menu.MenuLayer;
import com.willfp.eco.core.gui.page.PageChanger;
import com.willfp.eco.core.gui.slot.ConfigSlot;
import com.willfp.eco.core.gui.slot.FillerMask;
import com.willfp.eco.core.gui.slot.MaskItems;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.builder.ItemStackBuilder;
import com.willfp.eco.util.NumberUtils;
import com.willfp.ecopets.ecomponent.components.LevelComponent;
import com.willfp.ecopets.ecomponent.components.LevelState;
import com.willfp.ecopets.pets.Pet;
import com.willfp.ecopets.pets.PetKt;
import com.willfp.ecopets.pets.PetLevelGUI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/ecopets/pets/PetLevelGUI;", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "pet", "Lcom/willfp/ecopets/pets/Pet;", "(Lcom/willfp/eco/core/EcoPlugin;Lcom/willfp/ecopets/pets/Pet;)V", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "open", "", "player", "Lorg/bukkit/entity/Player;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nPetLevelGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PetLevelGUI.kt\ncom/willfp/ecopets/pets/PetLevelGUI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,147:1\n37#2,2:148\n*S KotlinDebug\n*F\n+ 1 PetLevelGUI.kt\ncom/willfp/ecopets/pets/PetLevelGUI\n*L\n29#1:148,2\n*E\n"})
public final class PetLevelGUI {
    @NotNull
    private final Pet pet;
    @NotNull
    private final Menu menu;

    public PetLevelGUI(@NotNull EcoPlugin plugin, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        this.pet = pet;
        List list = plugin.getConfigYml().getStrings("level-gui.mask.pattern");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] maskPattern = thisCollection$iv.toArray(new String[0]);
        MaskItems maskItems = MaskItems.fromItemNames((Iterable)plugin.getConfigYml().getStrings("level-gui.mask.materials"));
        List list2 = plugin.getConfigYml().getStrings("level-gui.progression-slots.pattern");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
        List progressionPattern = list2;
        int n = this.pet.getMaxLevel();
        LevelComponent component2 = new LevelComponent(progressionPattern, this, plugin, n){
            final /* synthetic */ PetLevelGUI this$0;
            final /* synthetic */ EcoPlugin $plugin;
            {
                this.this$0 = $receiver;
                this.$plugin = $plugin;
                super($progressionPattern, $super_call_param$1);
            }

            @NotNull
            public ItemStack getLevelItem(@NotNull Player player, @NotNull Menu menu, int level, @NotNull LevelState levelState) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
                Intrinsics.checkNotNullParameter((Object)((Object)levelState), (String)"levelState");
                String string = levelState.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String key = StringsKt.replace$default((String)string, (String)"_", (String)"-", (boolean)false, (int)4, null);
                String prefix = PetKt.getPetLevel((OfflinePlayer)player, PetLevelGUI.access$getPet$p(this.this$0)) == PetLevelGUI.access$getPet$p(this.this$0).getMaxLevel() ? "max-level-" : "";
                ItemStackBuilder itemStackBuilder = new ItemStackBuilder(Items.lookup((String)this.$plugin.getConfigYml().getString("level-gui.progression-slots." + key + ".item")));
                String string2 = this.$plugin.getConfigYml().getFormattedString("level-gui.progression-slots." + key + ".name");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedString(...)");
                String string3 = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"%pet%", (String)PetLevelGUI.access$getPet$p(this.this$0).getName(), (boolean)false, (int)4, null), (String)"%level%", (String)String.valueOf(level), (boolean)false, (int)4, null);
                String string4 = NumberUtils.toNumeral((int)level);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toNumeral(...)");
                ItemStackBuilder itemStackBuilder2 = (ItemStackBuilder)itemStackBuilder.setDisplayName(StringsKt.replace$default((String)string3, (String)"%level_numeral%", (String)string4, (boolean)false, (int)4, null));
                Pet pet = PetLevelGUI.access$getPet$p(this.this$0);
                List list = this.$plugin.getConfigYml().getFormattedStrings("level-gui.progression-slots." + key + "." + prefix + "lore");
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFormattedStrings(...)");
                ItemStack itemStack = ((ItemStackBuilder)((ItemStackBuilder)itemStackBuilder2.addLoreLines(pet.injectPlaceholdersInto(list, player, level))).setAmount(this.$plugin.getConfigYml().getBool("level-gui.progression-slots.level-as-amount") ? level : 1)).build();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"build(...)");
                return itemStack;
            }

            @NotNull
            public LevelState getLevelState(@NotNull Player player, int level) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return level <= PetKt.getPetLevel((OfflinePlayer)player, PetLevelGUI.access$getPet$p(this.this$0)) ? LevelState.UNLOCKED : (level == PetKt.getPetLevel((OfflinePlayer)player, PetLevelGUI.access$getPet$p(this.this$0)) + 1 ? LevelState.IN_PROGRESS : LevelState.LOCKED);
            }
        };
        this.menu = GUIHelperExtensions.menu((int)plugin.getConfigYml().getInt("level-gui.rows"), (Function1)((Function1)new Function1<MenuBuilder, Unit>(component2, maskItems, maskPattern, plugin){
            final /* synthetic */ component.1 $component;
            final /* synthetic */ MaskItems $maskItems;
            final /* synthetic */ String[] $maskPattern;
            final /* synthetic */ EcoPlugin $plugin;
            {
                this.$component = $component;
                this.$maskItems = $maskItems;
                this.$maskPattern = $maskPattern;
                this.$plugin = $plugin;
                super(1);
            }

            public final void invoke(@NotNull MenuBuilder $this$menu) {
                Intrinsics.checkNotNullParameter((Object)$this$menu, (String)"$this$menu");
                $this$menu.setTitle(pet.getName());
                $this$menu.maxPages(this.$component.getPages());
                $this$menu.setMask(new FillerMask(this.$maskItems, Arrays.copyOf(this.$maskPattern, this.$maskPattern.length)));
                $this$menu.addComponent(1, 1, (GUIComponent)this.$component);
                int n = this.$plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.row");
                int n2 = this.$plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.column");
                ItemStack itemStack = ((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)this.$plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.material"))).setDisplayName(this.$plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.name"))).build();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"build(...)");
                $this$menu.addComponent(MenuLayer.LOWER, n, n2, (GUIComponent)GUIHelperExtensions.slot((ItemStack)itemStack, (Function1)1.INSTANCE));
                $this$menu.addComponent(this.$plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.row"), this.$plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.column"), (GUIComponent)new PageChanger(((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)this.$plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.material"))).setDisplayName(this.$plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.name"))).build(), PageChanger.Direction.BACKWARDS));
                $this$menu.addComponent(this.$plugin.getConfigYml().getInt("level-gui.progression-slots.next-page.location.row"), this.$plugin.getConfigYml().getInt("level-gui.progression-slots.next-page.location.column"), (GUIComponent)new PageChanger(((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)this.$plugin.getConfigYml().getString("level-gui.progression-slots.next-page.material"))).setDisplayName(this.$plugin.getConfigYml().getString("level-gui.progression-slots.next-page.name"))).build(), PageChanger.Direction.FORWARDS));
                int n3 = this.$plugin.getConfigYml().getInt("level-gui.progression-slots.close.location.row");
                int n4 = this.$plugin.getConfigYml().getInt("level-gui.progression-slots.close.location.column");
                ItemStack itemStack2 = ((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)this.$plugin.getConfigYml().getString("level-gui.progression-slots.close.material"))).setDisplayName(this.$plugin.getConfigYml().getString("level-gui.progression-slots.close.name"))).build();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"build(...)");
                $this$menu.setSlot(n3, n4, GUIHelperExtensions.slot((ItemStack)itemStack2, (Function1)2.INSTANCE));
                for (Config config : this.$plugin.getConfigYml().getSubsections("level-gui.custom-slots")) {
                    $this$menu.setSlot(config.getInt("row"), config.getInt("column"), (Slot)new ConfigSlot(config));
                }
            }
        }));
    }

    public final void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.menu.open(player);
    }
}

