/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecopets.pets;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.willfp.eco.core.data.PlayerProfile;
import com.willfp.eco.core.data.ProfileExtensions;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.ecopets.EcoPetsPlugin;
import com.willfp.ecopets.api.event.PlayerPetExpGainEvent;
import com.willfp.ecopets.api.event.PlayerPetLevelUpEvent;
import com.willfp.ecopets.pets.LevelPlaceholder;
import com.willfp.ecopets.pets.Pet;
import com.willfp.ecopets.pets.PetKt;
import com.willfp.ecopets.pets.PetLevel;
import com.willfp.ecopets.pets.Pets;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\f\u0010 \u001a\u00020\u0007*\u00020\u0005H\u0002\u001a\"\u0010!\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0012\u0010'\u001a\u00020&*\u00020\u000e2\u0006\u0010(\u001a\u00020\f\u001a\u0012\u0010)\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010(\u001a\u00020\f\u001a\u0012\u0010*\u001a\u00020\u0007*\u00020\u000e2\u0006\u0010(\u001a\u00020\f\u001a\u0012\u0010+\u001a\u00020\u0007*\u00020\u000e2\u0006\u0010(\u001a\u00020\f\u001a\u0012\u0010,\u001a\u00020&*\u00020\u000e2\u0006\u0010(\u001a\u00020\f\u001a\u001a\u0010-\u001a\u00020.*\u00020\u00052\u0006\u0010(\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0007\u001a$\u00100\u001a\u00020.*\u00020\u00052\u0006\u0010(\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00072\b\b\u0002\u00101\u001a\u000202\u001a\u0012\u00103\u001a\u000202*\u00020\u000e2\u0006\u0010(\u001a\u00020\f\u001a\u001a\u00104\u001a\u00020.*\u00020\u000e2\u0006\u0010(\u001a\u00020\f2\u0006\u0010%\u001a\u00020&\u001a\u001a\u00105\u001a\u00020.*\u00020\u000e2\u0006\u0010(\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"N\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\",\u0010\u0017\u001a\u0004\u0018\u00010\f*\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\u0007*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00067"}, d2={"activePetKey", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "", "expMultiplierCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lorg/bukkit/entity/Player;", "kotlin.jvm.PlatformType", "", "petEggKey", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/NotNull;", "value", "Lcom/willfp/ecopets/pets/Pet;", "activePet", "Lorg/bukkit/OfflinePlayer;", "getActivePet", "(Lorg/bukkit/OfflinePlayer;)Lcom/willfp/ecopets/pets/Pet;", "setActivePet", "(Lorg/bukkit/OfflinePlayer;Lcom/willfp/ecopets/pets/Pet;)V", "activePetLevel", "Lcom/willfp/ecopets/pets/PetLevel;", "getActivePetLevel", "(Lorg/bukkit/OfflinePlayer;)Lcom/willfp/ecopets/pets/PetLevel;", "petEgg", "Lorg/bukkit/inventory/ItemStack;", "getPetEgg", "(Lorg/bukkit/inventory/ItemStack;)Lcom/willfp/ecopets/pets/Pet;", "setPetEgg", "(Lorg/bukkit/inventory/ItemStack;Lcom/willfp/ecopets/pets/Pet;)V", "petExperienceMultiplier", "getPetExperienceMultiplier", "(Lorg/bukkit/entity/Player;)D", "cacheSkillExperienceMultiplier", "format", "", "Lcom/willfp/ecopets/pets/LevelPlaceholder;", "string", "level", "", "getPetLevel", "pet", "getPetLevelObject", "getPetProgress", "getPetXP", "getPetXPRequired", "giveExactPetExperience", "", "experience", "givePetExperience", "noMultiply", "", "hasPet", "setPetLevel", "setPetXP", "xp", "core-plugin"})
public final class PetKt {
    @NotNull
    private static final PersistentDataKey<String> activePetKey = new PersistentDataKey(EcoPetsPlugin.Companion.getInstance().getNamespacedKeyFactory().create("active_pet"), PersistentDataKeyType.STRING, (Object)"");
    @NotNull
    private static final NamespacedKey petEggKey;
    private static final LoadingCache<Player, Double> expMultiplierCache;

    private static final String format(Collection<LevelPlaceholder> $this$format, String string, int level) {
        String process = string;
        for (LevelPlaceholder placeholder : $this$format) {
            process = StringsKt.replace$default((String)process, (String)("%" + placeholder.getId() + "%"), (String)placeholder.invoke(level), (boolean)false, (int)4, null);
        }
        return process;
    }

    @Nullable
    public static final Pet getPetEgg(@NotNull ItemStack $this$petEgg) {
        Intrinsics.checkNotNullParameter((Object)$this$petEgg, (String)"<this>");
        String string = (String)FastItemStackExtensions.fast((ItemStack)$this$petEgg).getPersistentDataContainer().get(petEggKey, PersistentDataType.STRING);
        if (string == null) {
            string = "";
        }
        return Pets.getByID(string);
    }

    public static final void setPetEgg(@NotNull ItemStack $this$petEgg, @Nullable Pet value) {
        Intrinsics.checkNotNullParameter((Object)$this$petEgg, (String)"<this>");
        if (value == null) {
            return;
        }
        FastItemStackExtensions.fast((ItemStack)$this$petEgg).getPersistentDataContainer().set(petEggKey, PersistentDataType.STRING, (Object)value.getId());
    }

    @Nullable
    public static final Pet getActivePet(@NotNull OfflinePlayer $this$activePet) {
        Intrinsics.checkNotNullParameter((Object)$this$activePet, (String)"<this>");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)$this$activePet).read(activePetKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        return Pets.getByID((String)object);
    }

    public static final void setActivePet(@NotNull OfflinePlayer $this$activePet, @Nullable Pet value) {
        Intrinsics.checkNotNullParameter((Object)$this$activePet, (String)"<this>");
        PlayerProfile playerProfile = ProfileExtensions.getProfile((OfflinePlayer)$this$activePet);
        Object object = value;
        if (object == null || (object = ((Pet)object).getId()) == null) {
            object = "";
        }
        playerProfile.write(activePetKey, object);
    }

    @Nullable
    public static final PetLevel getActivePetLevel(@NotNull OfflinePlayer $this$activePetLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$activePetLevel, (String)"<this>");
        Pet pet = PetKt.getActivePet($this$activePetLevel);
        if (pet == null) {
            return null;
        }
        Pet active = pet;
        return PetKt.getPetLevelObject($this$activePetLevel, active);
    }

    public static final int getPetLevel(@NotNull OfflinePlayer $this$getPetLevel, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)$this$getPetLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)$this$getPetLevel).read(pet.getLevelKey());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        return ((Number)object).intValue();
    }

    public static final void setPetLevel(@NotNull OfflinePlayer $this$setPetLevel, @NotNull Pet pet, int level) {
        Intrinsics.checkNotNullParameter((Object)$this$setPetLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        ProfileExtensions.getProfile((OfflinePlayer)$this$setPetLevel).write(pet.getLevelKey(), (Object)level);
    }

    public static final double getPetProgress(@NotNull OfflinePlayer $this$getPetProgress, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)$this$getPetProgress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        double currentXP = PetKt.getPetXP($this$getPetProgress, pet);
        int requiredXP = pet.getExpForLevel(PetKt.getPetLevel($this$getPetProgress, pet) + 1);
        return currentXP / (double)requiredXP;
    }

    @NotNull
    public static final PetLevel getPetLevelObject(@NotNull OfflinePlayer $this$getPetLevelObject, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)$this$getPetLevelObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        return pet.getLevel(PetKt.getPetLevel($this$getPetLevelObject, pet));
    }

    public static final boolean hasPet(@NotNull OfflinePlayer $this$hasPet, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        return PetKt.getPetLevel($this$hasPet, pet) > 0;
    }

    public static final double getPetXP(@NotNull OfflinePlayer $this$getPetXP, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)$this$getPetXP, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)$this$getPetXP).read(pet.getXpKey());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        return ((Number)object).doubleValue();
    }

    public static final void setPetXP(@NotNull OfflinePlayer $this$setPetXP, @NotNull Pet pet, double xp) {
        Intrinsics.checkNotNullParameter((Object)$this$setPetXP, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        ProfileExtensions.getProfile((OfflinePlayer)$this$setPetXP).write(pet.getXpKey(), (Object)xp);
    }

    public static final int getPetXPRequired(@NotNull OfflinePlayer $this$getPetXPRequired, @NotNull Pet pet) {
        Intrinsics.checkNotNullParameter((Object)$this$getPetXPRequired, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        return pet.getExpForLevel(PetKt.getPetLevel($this$getPetXPRequired, pet) + 1);
    }

    public static final double getPetExperienceMultiplier(@NotNull Player $this$petExperienceMultiplier) {
        Intrinsics.checkNotNullParameter((Object)$this$petExperienceMultiplier, (String)"<this>");
        Object object = expMultiplierCache.get((Object)$this$petExperienceMultiplier);
        Intrinsics.checkNotNull((Object)object);
        return ((Number)object).doubleValue();
    }

    private static final double cacheSkillExperienceMultiplier(Player $this$cacheSkillExperienceMultiplier) {
        if ($this$cacheSkillExperienceMultiplier.hasPermission("ecopets.xpmultiplier.quadruple")) {
            return 4.0;
        }
        if ($this$cacheSkillExperienceMultiplier.hasPermission("ecopets.xpmultiplier.triple")) {
            return 3.0;
        }
        if ($this$cacheSkillExperienceMultiplier.hasPermission("ecopets.xpmultiplier.double")) {
            return 2.0;
        }
        if ($this$cacheSkillExperienceMultiplier.hasPermission("ecopets.xpmultiplier.50percent")) {
            return 1.5;
        }
        String prefix = "ecopets.xpmultiplier.";
        for (PermissionAttachmentInfo permissionAttachmentInfo : $this$cacheSkillExperienceMultiplier.getEffectivePermissions()) {
            String permission;
            Intrinsics.checkNotNullExpressionValue((Object)permissionAttachmentInfo.getPermission(), (String)"getPermission(...)");
            if (!StringsKt.startsWith$default((String)permission, (String)prefix, (boolean)false, (int)2, null)) continue;
            String string = permission.substring(StringsKt.lastIndexOf$default((CharSequence)permission, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Double d = StringsKt.toDoubleOrNull((String)string);
            return (d != null ? d : 100.0) / (double)100 + 1.0;
        }
        return 1.0;
    }

    public static final void givePetExperience(@NotNull Player $this$givePetExperience, @NotNull Pet pet, double experience, boolean noMultiply) {
        Intrinsics.checkNotNullParameter((Object)$this$givePetExperience, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        double exp = Math.abs(noMultiply ? experience : experience * PetKt.getPetExperienceMultiplier($this$givePetExperience));
        PlayerPetExpGainEvent gainEvent = new PlayerPetExpGainEvent($this$givePetExperience, pet, exp, !noMultiply);
        Bukkit.getPluginManager().callEvent((Event)gainEvent);
        if (gainEvent.isCancelled()) {
            return;
        }
        PetKt.giveExactPetExperience($this$givePetExperience, pet, gainEvent.getAmount());
    }

    public static /* synthetic */ void givePetExperience$default(Player player, Pet pet, double d, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        PetKt.givePetExperience(player, pet, d, bl);
    }

    public static final void giveExactPetExperience(@NotNull Player $this$giveExactPetExperience, @NotNull Pet pet, double experience) {
        Intrinsics.checkNotNullParameter((Object)$this$giveExactPetExperience, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
        int level = PetKt.getPetLevel((OfflinePlayer)$this$giveExactPetExperience, pet);
        double progress = PetKt.getPetXP((OfflinePlayer)$this$giveExactPetExperience, pet) + experience;
        if (progress >= (double)pet.getExpForLevel(level + 1) && level + 1 <= pet.getMaxLevel()) {
            double overshoot = progress - (double)pet.getExpForLevel(level + 1);
            PetKt.setPetXP((OfflinePlayer)$this$giveExactPetExperience, pet, 0.0);
            PetKt.setPetLevel((OfflinePlayer)$this$giveExactPetExperience, pet, level + 1);
            PlayerPetLevelUpEvent levelUpEvent = new PlayerPetLevelUpEvent($this$giveExactPetExperience, pet, level + 1);
            Bukkit.getPluginManager().callEvent((Event)levelUpEvent);
            PetKt.giveExactPetExperience($this$giveExactPetExperience, pet, overshoot);
        } else {
            PetKt.setPetXP((OfflinePlayer)$this$giveExactPetExperience, pet, progress);
        }
    }

    private static final Double expMultiplierCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$format(Collection $receiver, String string, int level) {
        return PetKt.format($receiver, string, level);
    }

    public static final /* synthetic */ double access$cacheSkillExperienceMultiplier(Player $receiver) {
        return PetKt.cacheSkillExperienceMultiplier($receiver);
    }

    static {
        NamespacedKey namespacedKey = EcoPetsPlugin.Companion.getInstance().getNamespacedKeyFactory().create("pet_egg");
        Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"create(...)");
        petEggKey = namespacedKey;
        expMultiplierCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build(arg_0 -> PetKt.expMultiplierCache$lambda$0(expMultiplierCache.1.INSTANCE, arg_0));
    }
}

