/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecopets.pets;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecopets.pets.Pet;
import com.willfp.ecopets.pets.PetKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/willfp/ecopets/pets/PetDisplay;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "tick", "", "trackedEntities", "", "Ljava/util/UUID;", "Lcom/willfp/ecopets/pets/PetDisplay$PetArmorStand;", "getLocation", "Lorg/bukkit/Location;", "player", "Lorg/bukkit/entity/Player;", "getOrNew", "Lorg/bukkit/entity/ArmorStand;", "onLeave", "", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "onWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "remove", "shutdown", "tickAll", "tickPlayer", "PetArmorStand", "core-plugin"})
public final class PetDisplay
implements Listener {
    @NotNull
    private final EcoPlugin plugin;
    private int tick;
    @NotNull
    private final Map<UUID, PetArmorStand> trackedEntities;

    public PetDisplay(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
        this.trackedEntities = new LinkedHashMap();
    }

    public final void tickAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull((Object)player);
            this.tickPlayer(player);
        }
        int n = this.tick;
        this.tick = n + 1;
    }

    private final void tickPlayer(Player player) {
        ArmorStand armorStand = this.getOrNew(player);
        if (armorStand == null) {
            return;
        }
        ArmorStand stand = armorStand;
        Pet pet = PetKt.getActivePet((OfflinePlayer)player);
        if (pet != null) {
            if (player.isInvisible()) {
                this.remove(player);
                return;
            }
            String string = this.plugin.getConfigYml().getString("pet-entity.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = player.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            stand.setCustomName(StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%player%", (String)string2, (boolean)false, (int)4, null), (String)"%pet%", (String)pet.getName(), (boolean)false, (int)4, null), (String)"%level%", (String)String.valueOf(PetKt.getPetLevel((OfflinePlayer)player, pet)), (boolean)false, (int)4, null), (Player)player, (boolean)false, (int)2, null));
            Location location = this.getLocation(player);
            location.setY(location.getY() + NumberUtils.fastSin((double)((double)this.tick / (Math.PI * 2) * 0.5)) * 0.15);
            if (location.getWorld() != null) {
                stand.teleport(location);
            }
            if (!StringsKt.contains$default((CharSequence)pet.getEntityTexture(), (CharSequence)":", (boolean)false, (int)2, null)) {
                stand.setRotation((float)((double)(20 * this.tick) / (Math.PI * 2)), 0.0f);
            }
        }
    }

    private final Location getLocation(Player player) {
        Vector vector;
        Vector $this$getLocation_u24lambda_u240 = vector = player.getEyeLocation().getDirection().clone().normalize().multiply(-1);
        boolean bl = false;
        $this$getLocation_u24lambda_u240.setY(Math.abs($this$getLocation_u24lambda_u240.getY()));
        if (Math.abs($this$getLocation_u24lambda_u240.getX()) < 0.5) {
            $this$getLocation_u24lambda_u240.setX(0.5);
        }
        if (Math.abs($this$getLocation_u24lambda_u240.getZ()) < 0.5) {
            $this$getLocation_u24lambda_u240.setZ(0.5);
        }
        Vector vector2 = vector.rotateAroundY(0.5235987755982988);
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"rotateAroundY(...)");
        Vector offset = vector2;
        Location location = player.getEyeLocation().clone().add(offset);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        return location;
    }

    private final ArmorStand getOrNew(Player player) {
        PetArmorStand petArmorStand;
        PetArmorStand tracked;
        if (player.isInvisible()) {
            return null;
        }
        PetArmorStand petArmorStand2 = tracked = this.trackedEntities.get(player.getUniqueId());
        ArmorStand existing = petArmorStand2 != null ? petArmorStand2.getStand() : null;
        Pet pet = PetKt.getActivePet((OfflinePlayer)player);
        PetArmorStand petArmorStand3 = tracked;
        if (!Intrinsics.areEqual((Object)pet, (Object)(petArmorStand3 != null ? petArmorStand3.getPet() : null)) && (petArmorStand = tracked) != null && (petArmorStand = petArmorStand.getStand()) != null) {
            petArmorStand.remove();
        }
        if (existing == null || existing.isDead() || pet == null) {
            ArmorStand armorStand = existing;
            if (armorStand != null) {
                armorStand.remove();
            }
            this.trackedEntities.remove(player.getUniqueId());
            if (pet == null) {
                return null;
            }
            Location location = this.getLocation(player);
            ArmorStand stand = pet.makePetEntity().spawn(location);
            Map<UUID, PetArmorStand> map = this.trackedEntities;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            UUID uUID2 = uUID;
            PetArmorStand petArmorStand4 = new PetArmorStand(stand, pet);
            map.put(uUID2, petArmorStand4);
        }
        PetArmorStand petArmorStand5 = this.trackedEntities.get(player.getUniqueId());
        return petArmorStand5 != null ? petArmorStand5.getStand() : null;
    }

    public final void shutdown() {
        for (PetArmorStand stand : this.trackedEntities.values()) {
            stand.getStand().remove();
        }
        this.trackedEntities.clear();
    }

    private final void remove(Player player) {
        PetArmorStand petArmorStand = this.trackedEntities.get(player.getUniqueId());
        if (petArmorStand != null && (petArmorStand = petArmorStand.getStand()) != null) {
            petArmorStand.remove();
        }
        this.trackedEntities.remove(player.getUniqueId());
    }

    @EventHandler
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.remove(player);
    }

    @EventHandler
    public final void onTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.remove(player);
    }

    @EventHandler
    public final void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.remove(player);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/willfp/ecopets/pets/PetDisplay$PetArmorStand;", "", "stand", "Lorg/bukkit/entity/ArmorStand;", "pet", "Lcom/willfp/ecopets/pets/Pet;", "(Lorg/bukkit/entity/ArmorStand;Lcom/willfp/ecopets/pets/Pet;)V", "getPet", "()Lcom/willfp/ecopets/pets/Pet;", "getStand", "()Lorg/bukkit/entity/ArmorStand;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core-plugin"})
    private static final class PetArmorStand {
        @NotNull
        private final ArmorStand stand;
        @NotNull
        private final Pet pet;

        public PetArmorStand(@NotNull ArmorStand stand, @NotNull Pet pet) {
            Intrinsics.checkNotNullParameter((Object)stand, (String)"stand");
            Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
            this.stand = stand;
            this.pet = pet;
        }

        @NotNull
        public final ArmorStand getStand() {
            return this.stand;
        }

        @NotNull
        public final Pet getPet() {
            return this.pet;
        }

        @NotNull
        public final ArmorStand component1() {
            return this.stand;
        }

        @NotNull
        public final Pet component2() {
            return this.pet;
        }

        @NotNull
        public final PetArmorStand copy(@NotNull ArmorStand stand, @NotNull Pet pet) {
            Intrinsics.checkNotNullParameter((Object)stand, (String)"stand");
            Intrinsics.checkNotNullParameter((Object)pet, (String)"pet");
            return new PetArmorStand(stand, pet);
        }

        public static /* synthetic */ PetArmorStand copy$default(PetArmorStand petArmorStand, ArmorStand armorStand, Pet pet, int n, Object object) {
            if ((n & 1) != 0) {
                armorStand = petArmorStand.stand;
            }
            if ((n & 2) != 0) {
                pet = petArmorStand.pet;
            }
            return petArmorStand.copy(armorStand, pet);
        }

        @NotNull
        public String toString() {
            return "PetArmorStand(stand=" + this.stand + ", pet=" + this.pet + ")";
        }

        public int hashCode() {
            int result = this.stand.hashCode();
            result = result * 31 + this.pet.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PetArmorStand)) {
                return false;
            }
            PetArmorStand petArmorStand = (PetArmorStand)other;
            if (!Intrinsics.areEqual((Object)this.stand, (Object)petArmorStand.stand)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pet, (Object)petArmorStand.pet);
        }
    }
}

