/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecopets.ecomponent.components;

import com.willfp.eco.core.gui.GUIHelperExtensions;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.ecopets.ecomponent.AutofillComponent;
import com.willfp.ecopets.ecomponent.GUIPosition;
import com.willfp.ecopets.ecomponent.components.LevelComponentKt;
import com.willfp.ecopets.ecomponent.components.LevelState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0006H&J*\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/willfp/ecopets/ecomponent/components/LevelComponent;", "Lcom/willfp/ecopets/ecomponent/AutofillComponent;", "pattern", "", "", "maxLevel", "", "(Ljava/util/List;I)V", "levelsPerPage", "getLevelsPerPage", "()I", "pages", "getPages", "slots", "", "Lcom/willfp/ecopets/ecomponent/GUIPosition;", "Lcom/willfp/eco/core/gui/slot/Slot;", "getLevelItem", "Lorg/bukkit/inventory/ItemStack;", "player", "Lorg/bukkit/entity/Player;", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "level", "levelState", "Lcom/willfp/ecopets/ecomponent/components/LevelState;", "getLevelState", "getSlotAt", "row", "column", "eco-api"})
public abstract class LevelComponent
extends AutofillComponent {
    @NotNull
    private final Map<Integer, Map<GUIPosition, Slot>> slots;
    private final int levelsPerPage;
    private final int pages;

    public LevelComponent(@NotNull List<String> pattern, int maxLevel) {
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        this.slots = new LinkedHashMap();
        Map progressionSlots = new LinkedHashMap();
        int x = 0;
        for (String row : pattern) {
            ++x;
            int y = 0;
            int n = row.length();
            for (int i = 0; i < n; ++i) {
                int pos;
                char c = row.charAt(i);
                ++y;
                if (c == '0' || (pos = ArraysKt.indexOf((char[])LevelComponentKt.access$getProgressionOrder$p(), (char)c)) == -1) continue;
                progressionSlots.put(pos + 1, new GUIPosition(x, y));
            }
        }
        this.levelsPerPage = progressionSlots.size();
        this.pages = (int)Math.ceil((double)maxLevel / (double)this.levelsPerPage);
        int page = 1;
        int n = this.pages;
        if (page <= n) {
            while (true) {
                for (Map.Entry entry : progressionSlots.entrySet()) {
                    int levelOffset = ((Number)entry.getKey()).intValue();
                    GUIPosition position = (GUIPosition)entry.getValue();
                    final int level = (page - 1) * this.levelsPerPage + levelOffset;
                    if (level > maxLevel) continue;
                    Map map = this.slots.get(page);
                    if (map == null) {
                        map = new LinkedHashMap();
                    }
                    Map pageSlots = map;
                    pageSlots.put(position, GUIHelperExtensions.slot((Function2)((Function2)new Function2<Player, Menu, ItemStack>(){

                        @NotNull
                        public final ItemStack invoke(@NotNull Player player, @NotNull Menu menu) {
                            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                            Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
                            return this.getLevelItem(player, menu, level, this.getLevelState(player, level));
                        }
                    })));
                    Integer n2 = page;
                    this.slots.put(n2, pageSlots);
                }
                if (page == n) break;
                ++page;
            }
        }
    }

    @Nullable
    public Slot getSlotAt(int row, int column, @NotNull Player player, @NotNull Menu menu) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Map<GUIPosition, Slot> map = this.slots.get(menu.getPage(player));
        return map != null ? map.get(new GUIPosition(row, column)) : null;
    }

    public final int getLevelsPerPage() {
        return this.levelsPerPage;
    }

    public final int getPages() {
        return this.pages;
    }

    @NotNull
    public abstract ItemStack getLevelItem(@NotNull Player var1, @NotNull Menu var2, int var3, @NotNull LevelState var4);

    @NotNull
    public abstract LevelState getLevelState(@NotNull Player var1, int var2);
}

