/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.libreforge.loader.internal;

import com.willfp.eco.core.data.ExternalDataStore;
import com.willfp.eco.core.data.ExternalDataStoreExtensions;
import com.willfp.eco.core.version.Version;
import com.willfp.ecojobs.libreforge.loader.LibreforgePlugin;
import com.willfp.ecojobs.libreforge.loader.internal.LibreforgeNotFoundError;
import com.willfp.libreforge.LibreforgeSpigotPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY", "", "HIGHEST_LIBREFORGE_VERSION_KEY", "checkHighestVersion", "", "plugin", "Lcom/willfp/ecojobs/libreforge/loader/LibreforgePlugin;", "loadHighestLibreforgeVersion", "pluginFolder", "Ljava/io/File;", "tryLoadForceVersion", "loader"})
@SourceDebugExtension(value={"SMAP\nLibreforgeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibreforgeLoader.kt\ncom/willfp/libreforge/loader/internal/LibreforgeLoaderKt\n+ 2 ExternalDataStore.kt\ncom/willfp/eco/core/data/ExternalDataStoreExtensions\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,78:1\n34#2:79\n26#2:80\n18#2:83\n18#2:84\n12474#3,2:81\n*S KotlinDebug\n*F\n+ 1 LibreforgeLoader.kt\ncom/willfp/libreforge/loader/internal/LibreforgeLoaderKt\n*L\n24#1:79\n24#1:80\n55#1:83\n58#1:84\n53#1:81,2\n*E\n"})
public final class LibreforgeLoaderKt {
    @NotNull
    private static final String HIGHEST_LIBREFORGE_VERSION_KEY = "highest-libreforge-version";
    @NotNull
    private static final String HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY = "highest-libreforge-version-classloader";

    public static final void checkHighestVersion(@NotNull LibreforgePlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        String key$iv = HIGHEST_LIBREFORGE_VERSION_KEY;
        boolean $i$f$readExternalData = false;
        boolean bl = false;
        Version default$iv$iv = new Version("0.0.0");
        boolean $i$f$readExternalData2 = false;
        Object object = ExternalDataStore.get((String)key$iv, Version.class);
        if (object == null) {
            object = default$iv$iv;
        }
        Version currentHighestVersion = (Version)object;
        if (plugin.getLibreforgeVersion().compareTo(currentHighestVersion) > 0) {
            ExternalDataStoreExtensions.writeExternalData((String)HIGHEST_LIBREFORGE_VERSION_KEY, (Object)plugin.getLibreforgeVersion());
            ClassLoader classLoader = ((Object)((Object)plugin)).getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            ExternalDataStoreExtensions.writeExternalData((String)HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY, (Object)classLoader);
        }
    }

    public static final void tryLoadForceVersion(@NotNull File pluginFolder) {
        Intrinsics.checkNotNullParameter((Object)pluginFolder, (String)"pluginFolder");
        File libreforgeFolder = FilesKt.resolve((File)pluginFolder, (String)"libreforge");
        File versionsFolder = FilesKt.resolve((File)libreforgeFolder, (String)"versions");
        if (!versionsFolder.exists()) {
            return;
        }
        for (File file : FilesKt.walk$default((File)versionsFolder, null, (int)1, null)) {
            if (!Intrinsics.areEqual((Object)file.getName(), (Object)"libreforge.jar")) continue;
            Bukkit.getLogger().info("[libreforge] Found generic libreforge.jar!");
            Bukkit.getLogger().info("[libreforge] This version will be loaded instead of any versions bundled with plugins.");
            Bukkit.getPluginManager().loadPlugin(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadHighestLibreforgeVersion(@NotNull File pluginFolder) {
        boolean bl;
        block15: {
            Intrinsics.checkNotNullParameter((Object)pluginFolder, (String)"pluginFolder");
            Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)pluginArray, (String)"getPlugins(...)");
            Object[] $this$any$iv = pluginArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Plugin it = (Plugin)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"libreforge")) continue;
                bl = true;
                break block15;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        String key$iv = HIGHEST_LIBREFORGE_VERSION_CLASSLOADER_KEY;
        boolean $i$f$readExternalData = false;
        ClassLoader classLoader = (ClassLoader)ExternalDataStore.get((String)key$iv, ClassLoader.class);
        if (classLoader == null) {
            throw new LibreforgeNotFoundError("No libreforge plugin classloader found");
        }
        ClassLoader classLoader2 = classLoader;
        String key$iv2 = HIGHEST_LIBREFORGE_VERSION_KEY;
        boolean $i$f$readExternalData2 = false;
        Version version = (Version)ExternalDataStore.get((String)key$iv2, Version.class);
        if (version == null) {
            throw new LibreforgeNotFoundError("No libreforge version found");
        }
        Version version2 = version;
        File libreforgeFolder = FilesKt.resolve((File)pluginFolder, (String)"libreforge");
        File versionsFolder = FilesKt.resolve((File)libreforgeFolder, (String)"versions");
        versionsFolder.mkdirs();
        File libreforgeJar = FilesKt.resolve((File)versionsFolder, (String)("libreforge-" + version2 + ".jar"));
        String libreforgeResourceName = "libreforge-" + version2 + "-shadow.jar";
        Closeable closeable = new FileOutputStream(libreforgeJar);
        Throwable throwable = null;
        try {
            long l;
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = classLoader2.getResourceAsStream(libreforgeResourceName);
            Throwable throwable2 = null;
            try {
                InputStream inputStream = (InputStream)closeable2;
                boolean bl4 = false;
                InputStream inputStream2 = inputStream;
                if (inputStream2 == null) {
                    throw new LibreforgeNotFoundError("libreforge wasn't found in the plugin jar");
                }
                Intrinsics.checkNotNull((Object)inputStream2);
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Plugin plugin = Bukkit.getPluginManager().loadPlugin(libreforgeJar);
        Intrinsics.checkNotNull((Object)plugin, (String)"null cannot be cast to non-null type com.willfp.libreforge.LibreforgeSpigotPlugin");
        LibreforgeSpigotPlugin cfr_ignored_0 = (LibreforgeSpigotPlugin)plugin;
    }
}

