/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.libreforge.loader;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.LifecyclePosition;
import com.willfp.eco.core.PluginProps;
import com.willfp.eco.core.config.ConfigExtensions;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.core.registry.Registry;
import com.willfp.eco.core.version.Version;
import com.willfp.ecojobs.libreforge.loader.LibreforgePlugin;
import com.willfp.ecojobs.libreforge.loader.configs.ConfigCategory;
import com.willfp.ecojobs.libreforge.loader.configs.LegacyLocation;
import com.willfp.ecojobs.libreforge.loader.internal.InvalidLibreforgePluginError;
import com.willfp.ecojobs.libreforge.loader.internal.LibreforgeLoaderKt;
import com.willfp.ecojobs.libreforge.loader.internal.LoadedLibreforgePluginImpl;
import com.willfp.ecojobs.libreforge.loader.internal.configs.RegistrableConfig;
import com.willfp.libreforge.Plugins;
import com.willfp.libreforge.ViolationContext;
import com.willfp.libreforge.configs.LibreforgeConfigCategory;
import com.willfp.libreforge.configs.category.FoundConfig;
import com.willfp.libreforge.effects.Chain;
import com.willfp.libreforge.effects.Effects;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0010H\u0002J\u001a\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0014J&\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00182\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100+H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/willfp/ecojobs/libreforge/loader/LibreforgePlugin;", "Lcom/willfp/eco/core/EcoPlugin;", "()V", "categories", "Lcom/willfp/eco/core/registry/Registry;", "Lcom/willfp/libreforge/configs/LibreforgeConfigCategory;", "getCategories", "()Lcom/willfp/eco/core/registry/Registry;", "libreforgeVersion", "Lcom/willfp/eco/core/version/Version;", "getLibreforgeVersion", "()Lcom/willfp/eco/core/version/Version;", "loaderCategories", "", "Lcom/willfp/ecojobs/libreforge/loader/configs/ConfigCategory;", "addCategory", "", "category", "competeForVersion", "copyConfigs", "doFetchConfigs", "", "Lcom/willfp/ecojobs/libreforge/loader/internal/configs/RegistrableConfig;", "directory", "", "fetchConfigs", "", "getDefaultConfigNames", "", "getFile", "Ljava/io/File;", "getMinimumEcoVersion", "loadCategories", "loadCategory", "preload", "", "loadConfigCategories", "mutateProps", "Lcom/willfp/eco/core/PluginProps;", "props", "withLogs", "position", "block", "Lkotlin/Function0;", "RegistryLock", "loader"})
@SourceDebugExtension(value={"SMAP\nLibreforgePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibreforgePlugin.kt\ncom/willfp/libreforge/loader/LibreforgePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n766#2:239\n857#2,2:240\n766#2:245\n857#2,2:246\n1549#2:248\n1620#2,3:249\n1855#2,2:252\n1045#2:254\n1045#2:255\n766#2:256\n857#2,2:257\n1155#3,3:242\n1#4:259\n*S KotlinDebug\n*F\n+ 1 LibreforgePlugin.kt\ncom/willfp/libreforge/loader/LibreforgePlugin\n*L\n158#1:239\n158#1:240,2\n176#1:245\n176#1:246,2\n176#1:248\n176#1:249,3\n183#1:252,2\n188#1:254\n189#1:255\n52#1:256\n52#1:257,2\n170#1:242,3\n*E\n"})
public abstract class LibreforgePlugin
extends EcoPlugin {
    @NotNull
    private final List<ConfigCategory> loaderCategories = new ArrayList();
    @NotNull
    private final Registry<LibreforgeConfigCategory> categories = new Registry();
    @NotNull
    private final Version libreforgeVersion;

    public LibreforgePlugin() {
        String string = this.getProps().getEnvironmentVariable("libreforge version");
        if (string == null) {
            throw new InvalidLibreforgePluginError("libreforge version environment variable not set!");
        }
        this.libreforgeVersion = new Version(string);
        this.categories.lock((Object)RegistryLock.INSTANCE);
        File file = this.getDataFolder().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        LibreforgeLoaderKt.tryLoadForceVersion(file);
        this.competeForVersion();
        this.onLoad(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda$0(this));
        this.onLoad(LifecyclePosition.END, () -> LibreforgePlugin._init_$lambda$2(this));
        this.onEnable(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda$3(this));
        this.onReload(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda$5(this));
        this.onReload(LifecyclePosition.START, () -> LibreforgePlugin._init_$lambda$6(this));
    }

    @NotNull
    public final Registry<LibreforgeConfigCategory> getCategories() {
        return this.categories;
    }

    @NotNull
    public final Version getLibreforgeVersion() {
        return this.libreforgeVersion;
    }

    private final void loadCategory(ConfigCategory category, boolean preload) {
        this.withLogs(category, "before reload", (Function0<Unit>)((Function0)new Function0<Unit>(category, this){
            final /* synthetic */ ConfigCategory $category;
            final /* synthetic */ LibreforgePlugin this$0;
            {
                this.$category = $category;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$category.beforeReload(this.this$0);
            }
        }));
        this.withLogs(category, "clear", (Function0<Unit>)((Function0)new Function0<Unit>(category, this){
            final /* synthetic */ ConfigCategory $category;
            final /* synthetic */ LibreforgePlugin this$0;
            {
                this.$category = $category;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$category.clear(this.this$0);
                this.$category.getHandle$loader().clear();
            }
        }));
        for (RegistrableConfig config : this.fetchConfigs(category)) {
            this.withLogs(category, "loading config " + config.getId(), (Function0<Unit>)((Function0)new Function0<Unit>(category, config, preload, this){
                final /* synthetic */ ConfigCategory $category;
                final /* synthetic */ RegistrableConfig $config;
                final /* synthetic */ boolean $preload;
                final /* synthetic */ LibreforgePlugin this$0;
                {
                    this.$category = $category;
                    this.$config = $config;
                    this.$preload = $preload;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$category.getHandle$loader().register((Registrable)this.$config.getHandle());
                    if (this.$preload) {
                        this.$category.acceptPreloadConfig(this.this$0, this.$config.getId(), this.$config.getConfig());
                    } else {
                        this.$category.acceptConfig(this.this$0, this.$config.getId(), this.$config.getConfig());
                    }
                }
            }));
        }
        LegacyLocation legacy = category.getLegacyLocation();
        if (legacy != null) {
            for (Config config : legacy.getConfig(this).getSubsections(legacy.getSection())) {
                String id;
                Intrinsics.checkNotNullExpressionValue((Object)config.getString("id"), (String)"getString(...)");
                Intrinsics.checkNotNull((Object)config);
                RegistrableConfig registrable = new RegistrableConfig(config, null, id, category);
                this.withLogs(category, "loading legacy config " + id, (Function0<Unit>)((Function0)new Function0<Unit>(category, registrable, this, id){
                    final /* synthetic */ ConfigCategory $category;
                    final /* synthetic */ RegistrableConfig $registrable;
                    final /* synthetic */ LibreforgePlugin this$0;
                    final /* synthetic */ String $id;
                    {
                        this.$category = $category;
                        this.$registrable = $registrable;
                        this.this$0 = $receiver;
                        this.$id = $id;
                        super(0);
                    }

                    public final void invoke() {
                        this.$category.getHandle$loader().register((Registrable)this.$registrable.getHandle());
                        this.$category.acceptConfig(this.this$0, this.$id, this.$registrable.getConfig());
                    }
                }));
            }
        }
        this.withLogs(category, "after reload", (Function0<Unit>)((Function0)new Function0<Unit>(category, this){
            final /* synthetic */ ConfigCategory $category;
            final /* synthetic */ LibreforgePlugin this$0;
            {
                this.$category = $category;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$category.afterReload(this.this$0);
            }
        }));
    }

    static /* synthetic */ void loadCategory$default(LibreforgePlugin libreforgePlugin, ConfigCategory configCategory, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadCategory");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        libreforgePlugin.loadCategory(configCategory, bl);
    }

    private final void withLogs(ConfigCategory category, String position, Function0<Unit> block) {
        try {
            block.invoke();
        }
        catch (Exception e) {
            this.getLogger().warning("Exception loading " + category.getId() + " at " + position + "!");
            e.printStackTrace();
        }
    }

    private final void competeForVersion() {
        LibreforgeLoaderKt.checkHighestVersion(this);
    }

    private final void loadCategories() {
        for (ConfigCategory category : this.loadConfigCategories()) {
            this.addCategory(category);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyConfigs(ConfigCategory category) {
        void $this$filterTo$iv$iv;
        File file = this.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataFolder(...)");
        File folder = FilesKt.resolve((File)file, (String)category.getDirectory());
        Collection<String> configNames = this.getDefaultConfigNames(category);
        if (!folder.exists()) {
            for (String name : configNames) {
                new FoundConfig(name, category.getDirectory(), (EcoPlugin)this).copy();
            }
        }
        Iterable $this$filter$iv = configNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String exampleConfigs : (List)destination$iv$iv) {
            new FoundConfig(exampleConfigs, category.getDirectory(), (EcoPlugin)this).copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Collection<String> getDefaultConfigNames(ConfigCategory category) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Object zipFile2;
        List files = new ArrayList();
        try {
            Closeable closeable = new ZipFile(this.getFile());
            Throwable throwable = null;
            try {
                void $this$mapTo$iv;
                zipFile2 = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)zipFile2).entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<ZipEntry, Boolean>(category){
                    final /* synthetic */ ConfigCategory $category;
                    {
                        this.$category = $category;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(ZipEntry it) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        return StringsKt.startsWith$default((String)string, (String)(this.$category.getDirectory() + "/"), (boolean)false, (int)2, null);
                    }
                }));
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it2;
                    ZipEntry zipEntry = (ZipEntry)item$iv;
                    Collection collection = files;
                    boolean bl2 = false;
                    String string = it2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    collection.add(StringsKt.removePrefix((String)string, (CharSequence)(category.getDirectory() + "/")));
                }
                zipFile2 = (List)((Collection)files);
            }
            catch (Throwable zipFile2) {
                throwable = zipFile2;
                throw zipFile2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        zipFile2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)".yml", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removeSuffix((String)it, (CharSequence)".yml"));
        }
        return (List)destination$iv$iv;
    }

    private final List<RegistrableConfig> fetchConfigs(ConfigCategory category) {
        Set configs = new LinkedHashSet();
        CollectionsKt.addAll((Collection)configs, (Iterable)this.doFetchConfigs(category, category.getDirectory()));
        Object object = category.getLegacyLocation();
        if (object != null && (object = ((LegacyLocation)object).getAlternativeDirectories()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String directory = (String)element$iv;
                boolean bl = false;
                CollectionsKt.addAll((Collection)configs, (Iterable)this.doFetchConfigs(category, directory));
            }
        }
        Iterable $this$sortedBy$iv = configs;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RegistrableConfig it = (RegistrableConfig)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (RegistrableConfig)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        });
        $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RegistrableConfig it = (RegistrableConfig)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getConfig().getInt("load-weight", 100));
                it = (RegistrableConfig)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getConfig().getInt("load-weight", 100)));
            }
        });
    }

    private final Set<RegistrableConfig> doFetchConfigs(ConfigCategory category, String directory) {
        File file = this.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataFolder(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)FilesKt.resolve((File)file, (String)directory), null, (int)1, null)), (Function1)doFetchConfigs.1.INSTANCE), (Function1)((Function1)new Function1<File, RegistrableConfig>(category){
            final /* synthetic */ ConfigCategory $category;
            {
                this.$category = $category;
                super(1);
            }

            @NotNull
            public final RegistrableConfig invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String id = FilesKt.getNameWithoutExtension((File)file);
                Config config = ConfigExtensions.readConfig((File)file);
                return new RegistrableConfig(config, file, id, this.$category);
            }
        })));
    }

    @NotNull
    public File getFile() {
        File file = super.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        return file;
    }

    @NotNull
    protected PluginProps mutateProps(@NotNull PluginProps props) {
        PluginProps pluginProps;
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        PluginProps $this$mutateProps_u24lambda_u2415 = pluginProps = props;
        boolean bl = false;
        $this$mutateProps_u24lambda_u2415.setSupportingExtensions(true);
        return pluginProps;
    }

    @NotNull
    public String getMinimumEcoVersion() {
        return "6.63.0";
    }

    @NotNull
    public List<ConfigCategory> loadConfigCategories() {
        return CollectionsKt.emptyList();
    }

    public final void addCategory(@NotNull ConfigCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.categories.unlock((Object)RegistryLock.INSTANCE);
        category.makeHandle$loader(this);
        this.copyConfigs(category);
        ((Collection)this.loaderCategories).add(category);
        this.categories.register((Registrable)category.getHandle$loader());
        this.categories.lock((Object)RegistryLock.INSTANCE);
    }

    private static final void _init_$lambda$0(LibreforgePlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        File file = this$0.getDataFolder().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        LibreforgeLoaderKt.loadHighestLibreforgeVersion(file);
        File file2 = this$0.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getDataFolder(...)");
        FilesKt.resolve((File)file2, (String)"lrcdb.yml").delete();
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$2(LibreforgePlugin this$0) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.loadCategories();
        Iterable $this$filter$iv = this$0.loaderCategories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfigCategory it = (ConfigCategory)element$iv$iv;
            boolean bl = false;
            if (!it.getShouldPreload()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ConfigCategory category : (List)destination$iv$iv) {
            this$0.loadCategory(category, true);
        }
    }

    private static final void _init_$lambda$3(LibreforgePlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Plugins.INSTANCE.register((Registrable)new LoadedLibreforgePluginImpl(this$0));
    }

    private static final void _init_$lambda$5(LibreforgePlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        File file = this$0.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDataFolder(...)");
        File it = FilesKt.resolve((File)file, (String)"chains.yml");
        boolean bl = false;
        Config chainsYml = it.exists() ? ConfigExtensions.readConfig((File)it) : ConfigExtensions.emptyConfig();
        for (Config config : chainsYml.getSubsections("chains")) {
            String string = config.getString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            List list = config.getSubsections("effects");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSubsections(...)");
            Chain chain = Effects.INSTANCE.compileChain((Collection)list, new ViolationContext((EcoPlugin)this$0, "chains.yml"));
            if (chain == null) continue;
            Effects.INSTANCE.register(string, chain);
        }
    }

    private static final void _init_$lambda$6(LibreforgePlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        for (ConfigCategory category : this$0.loaderCategories) {
            LibreforgePlugin.loadCategory$default(this$0, category, false, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/willfp/ecojobs/libreforge/loader/LibreforgePlugin$RegistryLock;", "", "()V", "loader"})
    private static final class RegistryLock {
        @NotNull
        public static final RegistryLock INSTANCE = new RegistryLock();

        private RegistryLock() {
        }
    }
}

