/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.jobs;

import com.willfp.ecojobs.EcoJobsPlugin;
import com.willfp.ecojobs.api.event.PlayerJobLevelUpEvent;
import com.willfp.ecojobs.jobs.Job;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/ecojobs/jobs/JobLevelListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/ecojobs/EcoJobsPlugin;", "(Lcom/willfp/ecojobs/EcoJobsPlugin;)V", "onLevelUp", "", "event", "Lcom/willfp/ecojobs/api/event/PlayerJobLevelUpEvent;", "core-plugin"})
public final class JobLevelListener
implements Listener {
    @NotNull
    private final EcoJobsPlugin plugin;

    public JobLevelListener(@NotNull EcoJobsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onLevelUp(@NotNull PlayerJobLevelUpEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Job job = event.getJob();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        int level = event.getLevel();
        job.executeLevelCommands(player2, level);
        if (this.plugin.getConfigYml().getBool("level-up.sound.enabled")) {
            String string = this.plugin.getConfigYml().getString("level-up.sound.id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            Sound sound = Sound.valueOf((String)string2);
            double pitch = this.plugin.getConfigYml().getDouble("level-up.sound.pitch");
            player2.playSound(player2.getLocation(), sound, 100.0f, (float)pitch);
        }
        if (this.plugin.getConfigYml().getBool("level-up.message.enabled")) {
            List list = this.plugin.getConfigYml().getFormattedStrings("level-up.message.message");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFormattedStrings(...)");
            for (String message : job.injectPlaceholdersInto(list, player2, level)) {
                player2.sendMessage(message);
            }
        }
    }
}

