/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.jobs;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.GUIHelperExtensions;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuBuilder;
import com.willfp.eco.core.gui.menu.MenuLayer;
import com.willfp.eco.core.gui.page.PageChanger;
import com.willfp.eco.core.gui.slot.ConfigSlot;
import com.willfp.eco.core.gui.slot.FillerMask;
import com.willfp.eco.core.gui.slot.MaskItems;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.builder.ItemStackBuilder;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecojobs.api.EcoJobsAPI;
import com.willfp.ecojobs.ecomponent.components.LevelComponent;
import com.willfp.ecojobs.ecomponent.components.LevelState;
import com.willfp.ecojobs.jobs.Job;
import com.willfp.ecojobs.jobs.JobLevelGUI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/ecojobs/jobs/JobLevelGUI;", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "job", "Lcom/willfp/ecojobs/jobs/Job;", "(Lcom/willfp/eco/core/EcoPlugin;Lcom/willfp/ecojobs/jobs/Job;)V", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "open", "", "player", "Lorg/bukkit/entity/Player;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nJobLevelGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobLevelGUI.kt\ncom/willfp/ecojobs/jobs/JobLevelGUI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n37#2,2:149\n*S KotlinDebug\n*F\n+ 1 JobLevelGUI.kt\ncom/willfp/ecojobs/jobs/JobLevelGUI\n*L\n30#1:149,2\n*E\n"})
public final class JobLevelGUI {
    @NotNull
    private final Job job;
    @NotNull
    private final Menu menu;

    public JobLevelGUI(final @NotNull EcoPlugin plugin, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.job = job;
        List list = plugin.getConfigYml().getStrings("level-gui.mask.pattern");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] maskPattern = thisCollection$iv.toArray(new String[0]);
        MaskItems maskItems = MaskItems.fromItemNames((Iterable)plugin.getConfigYml().getStrings("level-gui.mask.materials"));
        List list2 = plugin.getConfigYml().getStrings("level-gui.progression-slots.pattern");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
        List progressionPattern = list2;
        int n = this.job.getMaxLevel();
        LevelComponent component2 = new LevelComponent(progressionPattern, plugin, this, n){
            final /* synthetic */ EcoPlugin $plugin;
            final /* synthetic */ JobLevelGUI this$0;
            {
                this.$plugin = $plugin;
                this.this$0 = $receiver;
                super($progressionPattern, $super_call_param$1);
            }

            @NotNull
            public ItemStack getLevelItem(@NotNull Player player, @NotNull Menu menu2, int level, @NotNull LevelState levelState) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
                Intrinsics.checkNotNullParameter((Object)((Object)levelState), (String)"levelState");
                String string = levelState.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String key = StringsKt.replace$default((String)string, (String)"_", (String)"-", (boolean)false, (int)4, null);
                ItemStackBuilder itemStackBuilder = new ItemStackBuilder(Items.lookup((String)this.$plugin.getConfigYml().getString("level-gui.progression-slots." + key + ".item")));
                String string2 = this.$plugin.getConfigYml().getFormattedString("level-gui.progression-slots." + key + ".name");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedString(...)");
                String string3 = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"%job%", (String)JobLevelGUI.access$getJob$p(this.this$0).getName(), (boolean)false, (int)4, null), (String)"%level%", (String)String.valueOf(level), (boolean)false, (int)4, null);
                String string4 = NumberUtils.toNumeral((int)level);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toNumeral(...)");
                ItemStackBuilder itemStackBuilder2 = (ItemStackBuilder)itemStackBuilder.setDisplayName(StringsKt.replace$default((String)string3, (String)"%level_numeral%", (String)string4, (boolean)false, (int)4, null));
                Job job = JobLevelGUI.access$getJob$p(this.this$0);
                List list = this.$plugin.getConfigYml().getFormattedStrings("level-gui.progression-slots." + key + ".lore");
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFormattedStrings(...)");
                ItemStack itemStack = ((ItemStackBuilder)((ItemStackBuilder)itemStackBuilder2.addLoreLines(job.injectPlaceholdersInto(list, player, level))).setAmount(this.$plugin.getConfigYml().getBool("level-gui.progression-slots.level-as-amount") ? level : 1)).build();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"build(...)");
                return itemStack;
            }

            @NotNull
            public LevelState getLevelState(@NotNull Player player, int level) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return level <= EcoJobsAPI.getJobLevel((OfflinePlayer)player, JobLevelGUI.access$getJob$p(this.this$0)) ? LevelState.UNLOCKED : (level == EcoJobsAPI.getJobLevel((OfflinePlayer)player, JobLevelGUI.access$getJob$p(this.this$0)) + 1 ? LevelState.IN_PROGRESS : LevelState.LOCKED);
            }
        };
        this.menu = GUIHelperExtensions.menu((int)plugin.getConfigYml().getInt("level-gui.rows"), (Function1)((Function1)new Function1<MenuBuilder, Unit>(component2, maskItems, maskPattern){
            final /* synthetic */ component.1 $component;
            final /* synthetic */ MaskItems $maskItems;
            final /* synthetic */ String[] $maskPattern;
            {
                this.$component = $component;
                this.$maskItems = $maskItems;
                this.$maskPattern = $maskPattern;
                super(1);
            }

            public final void invoke(@NotNull MenuBuilder $this$menu) {
                Intrinsics.checkNotNullParameter((Object)$this$menu, (String)"$this$menu");
                String string = plugin.getConfigYml().getString("level-gui.title");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                $this$menu.setTitle(StringUtilsExtensions.formatEco$default((String)StringsKt.replace$default((String)string, (String)"%job%", (String)job.getName(), (boolean)false, (int)4, null), null, (boolean)false, (int)3, null));
                $this$menu.maxPages(this.$component.getPages());
                $this$menu.setMask(new FillerMask(this.$maskItems, Arrays.copyOf(this.$maskPattern, this.$maskPattern.length)));
                $this$menu.addComponent(1, 1, (GUIComponent)this.$component);
                int n = plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.row");
                int n2 = plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.column");
                ItemStack itemStack = ((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.material"))).setDisplayName(plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.name"))).build();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"build(...)");
                $this$menu.addComponent(MenuLayer.LOWER, n, n2, (GUIComponent)GUIHelperExtensions.slot((ItemStack)itemStack, (Function1)1.INSTANCE));
                $this$menu.addComponent(plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.row"), plugin.getConfigYml().getInt("level-gui.progression-slots.prev-page.location.column"), (GUIComponent)new PageChanger(((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.material"))).setDisplayName(plugin.getConfigYml().getString("level-gui.progression-slots.prev-page.name"))).build(), PageChanger.Direction.BACKWARDS));
                $this$menu.addComponent(plugin.getConfigYml().getInt("level-gui.progression-slots.next-page.location.row"), plugin.getConfigYml().getInt("level-gui.progression-slots.next-page.location.column"), (GUIComponent)new PageChanger(((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)plugin.getConfigYml().getString("level-gui.progression-slots.next-page.material"))).setDisplayName(plugin.getConfigYml().getString("level-gui.progression-slots.next-page.name"))).build(), PageChanger.Direction.FORWARDS));
                int n3 = plugin.getConfigYml().getInt("level-gui.progression-slots.close.location.row");
                int n4 = plugin.getConfigYml().getInt("level-gui.progression-slots.close.location.column");
                ItemStack itemStack2 = ((ItemStackBuilder)new ItemStackBuilder(Items.lookup((String)plugin.getConfigYml().getString("level-gui.progression-slots.close.material"))).setDisplayName(plugin.getConfigYml().getString("level-gui.progression-slots.close.name"))).build();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"build(...)");
                $this$menu.setSlot(n3, n4, GUIHelperExtensions.slot((ItemStack)itemStack2, (Function1)2.INSTANCE));
                for (Config config : plugin.getConfigYml().getSubsections("level-gui.custom-slots")) {
                    $this$menu.setSlot(config.getInt("row"), config.getInt("column"), (Slot)new ConfigSlot(config));
                }
            }
        }));
    }

    public final void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.menu.open(player);
    }
}

