/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.jobs;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.willfp.ecojobs.api.EcoJobsAPI;
import com.willfp.ecojobs.jobs.Job;
import com.willfp.ecojobs.jobs.JobKt;
import com.willfp.ecojobs.jobs.JobLevel;
import com.willfp.ecojobs.jobs.LevelPlaceholder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\"\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001a\u0010\u0015\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0004\"N\u0010\u0000\u001aB\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004 \u0003* \u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0004*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"expMultiplierCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lorg/bukkit/entity/Player;", "kotlin.jvm.PlatformType", "", "jobExperienceMultiplier", "getJobExperienceMultiplier", "(Lorg/bukkit/entity/Player;)D", "cacheJobExperienceMultiplier", "format", "", "", "Lcom/willfp/ecojobs/jobs/LevelPlaceholder;", "string", "level", "", "getJobLevelObject", "Lcom/willfp/ecojobs/jobs/JobLevel;", "Lorg/bukkit/OfflinePlayer;", "job", "Lcom/willfp/ecojobs/jobs/Job;", "getNumericalPermission", "permission", "default", "core-plugin"})
public final class JobKt {
    private static final LoadingCache<Player, Double> expMultiplierCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build(arg_0 -> JobKt.expMultiplierCache$lambda$0(expMultiplierCache.1.INSTANCE, arg_0));

    private static final String format(Collection<LevelPlaceholder> $this$format, String string, int level) {
        String process = string;
        for (LevelPlaceholder placeholder : $this$format) {
            process = StringsKt.replace$default((String)process, (String)("%" + placeholder.getId() + "%"), (String)placeholder.invoke(level), (boolean)false, (int)4, null);
        }
        return process;
    }

    @NotNull
    public static final JobLevel getJobLevelObject(@NotNull OfflinePlayer $this$getJobLevelObject, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$getJobLevelObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return job.getLevel(EcoJobsAPI.getJobLevel($this$getJobLevelObject, job));
    }

    public static final double getJobExperienceMultiplier(@NotNull Player $this$jobExperienceMultiplier) {
        Intrinsics.checkNotNullParameter((Object)$this$jobExperienceMultiplier, (String)"<this>");
        Object object = expMultiplierCache.get((Object)$this$jobExperienceMultiplier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).doubleValue();
    }

    private static final double cacheJobExperienceMultiplier(Player $this$cacheJobExperienceMultiplier) {
        if ($this$cacheJobExperienceMultiplier.hasPermission("ecojobs.xpmultiplier.quadruple")) {
            return 4.0;
        }
        if ($this$cacheJobExperienceMultiplier.hasPermission("ecojobs.xpmultiplier.triple")) {
            return 3.0;
        }
        if ($this$cacheJobExperienceMultiplier.hasPermission("ecojobs.xpmultiplier.double")) {
            return 2.0;
        }
        if ($this$cacheJobExperienceMultiplier.hasPermission("ecojobs.xpmultiplier.50percent")) {
            return 1.5;
        }
        return 1.0 + JobKt.getNumericalPermission($this$cacheJobExperienceMultiplier, "ecojobs.xpmultiplier", 0.0) / (double)100;
    }

    public static final double getNumericalPermission(@NotNull Player $this$getNumericalPermission, @NotNull String permission, double d) {
        Intrinsics.checkNotNullParameter((Object)$this$getNumericalPermission, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Double highest = null;
        for (PermissionAttachmentInfo permissionAttachmentInfo : $this$getNumericalPermission.getEffectivePermissions()) {
            String perm;
            Intrinsics.checkNotNullExpressionValue((Object)permissionAttachmentInfo.getPermission(), (String)"getPermission(...)");
            if (!StringsKt.startsWith$default((String)perm, (String)permission, (boolean)false, (int)2, null)) continue;
            String string = perm.substring(StringsKt.lastIndexOf$default((CharSequence)perm, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Double d2 = StringsKt.toDoubleOrNull((String)string);
            if (d2 == null) {
                continue;
            }
            double found = d2;
            Double d3 = highest;
            highest = Math.max(d3 != null ? d3 : Double.MIN_VALUE, found);
        }
        Double d4 = highest;
        return d4 != null ? d4 : d;
    }

    private static final Double expMultiplierCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$format(Collection $receiver, String string, int level) {
        return JobKt.format($receiver, string, level);
    }

    public static final /* synthetic */ double access$cacheJobExperienceMultiplier(Player $receiver) {
        return JobKt.cacheJobExperienceMultiplier($receiver);
    }
}

