/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.jobs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.builder.ItemStackBuilder;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.PlayerPlaceholder;
import com.willfp.eco.core.placeholder.PlayerStaticPlaceholder;
import com.willfp.eco.core.placeholder.PlayerlessPlaceholder;
import com.willfp.eco.core.price.ConfiguredPrice;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.core.price.impl.PriceEconomy;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.StringUtilsExtensions;
import com.willfp.ecojobs.EcoJobsPlugin;
import com.willfp.ecojobs.api.EcoJobsAPI;
import com.willfp.ecojobs.jobs.JobKt;
import com.willfp.ecojobs.jobs.JobLeaveGUI;
import com.willfp.ecojobs.jobs.JobLevel;
import com.willfp.ecojobs.jobs.JobLevelGUI;
import com.willfp.ecojobs.jobs.JobXPAccumulator;
import com.willfp.ecojobs.jobs.LeaderboardCacheEntry;
import com.willfp.ecojobs.jobs.LevelPlaceholder;
import com.willfp.libreforge.ViolationContext;
import com.willfp.libreforge.conditions.ConditionList;
import com.willfp.libreforge.conditions.Conditions;
import com.willfp.libreforge.counters.Accumulator;
import com.willfp.libreforge.counters.Counter;
import com.willfp.libreforge.counters.Counters;
import com.willfp.libreforge.effects.EffectList;
import com.willfp.libreforge.effects.Effects;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010I\u001a\u00020\u001c2\b\u0010J\u001a\u0004\u0018\u00010KH\u0096\u0002J\u0016\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0017J \u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010P\u001a\u00020\u00172\b\b\u0002\u0010R\u001a\u00020\u0017H\u0002J\u000e\u0010S\u001a\u00020\u00172\u0006\u0010P\u001a\u00020\u0017J\b\u0010T\u001a\u00020\u0003H\u0016J\u000e\u0010U\u001a\u00020\n2\u0006\u0010N\u001a\u00020OJ\u000e\u0010V\u001a\u00020\n2\u0006\u0010N\u001a\u00020OJ \u0010W\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010P\u001a\u00020\u00172\b\b\u0002\u0010R\u001a\u00020\u0017H\u0002J \u0010X\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010P\u001a\u00020\u00172\b\b\u0002\u0010R\u001a\u00020\u0017H\u0002J\u000e\u0010Y\u001a\u00020;2\u0006\u0010P\u001a\u00020\u0017J \u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010P\u001a\u00020\u00172\b\b\u0002\u0010R\u001a\u00020\u0017H\u0002J \u0010[\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010P\u001a\u00020\u00172\b\b\u0002\u0010R\u001a\u00020\u0017H\u0002J\u0010\u0010\\\u001a\u0004\u0018\u00010E2\u0006\u0010]\u001a\u00020\u0017J\b\u0010^\u001a\u00020\u0017H\u0016J3\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010N\u001a\u00020O2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010bJ\b\u0010c\u001a\u00020MH\u0016J\b\u0010d\u001a\u00020MH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\u0015\u001aZ\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0018*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00190\u0019 \u0018*,\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0018*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00190\u0019\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0016\u0010)\u001a\u00070!\u00a2\u0006\u0002\b\"\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$R \u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u001703\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u00108\u001aZ\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0018*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00190\u0019 \u0018*,\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0018*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00190\u0019\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00109\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010:\u001aB\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u0018*\u0004\u0018\u00010;0; \u0018* \u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u0018*\u0004\u0018\u00010;0;\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0016\u0010?\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010A\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u001dRf\u0010C\u001aZ\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0018*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00190\u0019 \u0018*,\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0018*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00190\u0019\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010D\u001aB\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u0018*\u0004\u0018\u00010E0E \u0018* \u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u0018*\u0004\u0018\u00010E0E\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020G03\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00105\u00a8\u0006e"}, d2={"Lcom/willfp/ecojobs/jobs/Job;", "Lcom/willfp/eco/core/registry/Registrable;", "id", "", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "plugin", "Lcom/willfp/ecojobs/EcoJobsPlugin;", "(Ljava/lang/String;Lcom/willfp/eco/core/config/interfaces/Config;Lcom/willfp/ecojobs/EcoJobsPlugin;)V", "baseItem", "Lorg/bukkit/inventory/ItemStack;", "conditions", "Lcom/willfp/libreforge/conditions/ConditionList;", "getConfig", "()Lcom/willfp/eco/core/config/interfaces/Config;", "description", "Lorg/jetbrains/annotations/NotNull;", "getDescription", "()Ljava/lang/String;", "effects", "Lcom/willfp/libreforge/effects/EffectList;", "effectsDescription", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "getId", "isUnlockedByDefault", "", "()Z", "jobXpGains", "Lcom/willfp/libreforge/counters/Counter;", "joinPrice", "Lcom/willfp/eco/core/price/ConfiguredPrice;", "Lorg/jetbrains/annotations/Nullable;", "getJoinPrice", "()Lcom/willfp/eco/core/price/ConfiguredPrice;", "leaveGUI", "Lcom/willfp/ecojobs/jobs/JobLeaveGUI;", "getLeaveGUI", "()Lcom/willfp/ecojobs/jobs/JobLeaveGUI;", "leavePrice", "getLeavePrice", "levelCommands", "", "", "levelGUI", "Lcom/willfp/ecojobs/jobs/JobLevelGUI;", "getLevelGUI", "()Lcom/willfp/ecojobs/jobs/JobLevelGUI;", "levelKey", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "getLevelKey", "()Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "levelPlaceholders", "Lcom/willfp/ecojobs/jobs/LevelPlaceholder;", "levelUpMessages", "levelXpRequirements", "levels", "Lcom/willfp/ecojobs/jobs/JobLevel;", "maxLevel", "getMaxLevel", "()I", "name", "getName", "resetsOnQuit", "getResetsOnQuit", "rewardsDescription", "topCache", "Lcom/willfp/ecojobs/jobs/LeaderboardCacheEntry;", "xpKey", "", "getXpKey", "equals", "other", "", "executeLevelCommands", "", "player", "Lorg/bukkit/entity/Player;", "level", "getEffectsDescription", "whitespace", "getExpForLevel", "getID", "getIcon", "getJobInfoIcon", "getJoinLore", "getLeaveLore", "getLevel", "getLevelUpMessages", "getRewardsDescription", "getTop", "place", "hashCode", "injectPlaceholdersInto", "lore", "forceLevel", "(Ljava/util/List;Lorg/bukkit/entity/Player;Ljava/lang/Integer;)Ljava/util/List;", "onRegister", "onRemove", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Job.kt\ncom/willfp/ecojobs/jobs/Job\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,452:1\n1549#2:453\n1620#2,3:454\n1603#2,9:457\n1855#2:466\n1856#2:468\n1612#2:469\n1855#2,2:470\n1855#2,2:472\n1549#2:474\n1620#2,3:475\n1549#2:478\n1620#2,3:479\n1549#2:482\n1620#2,3:483\n1549#2:486\n1620#2,3:487\n1549#2:490\n1620#2,3:491\n1#3:467\n12634#4,3:494\n*S KotlinDebug\n*F\n+ 1 Job.kt\ncom/willfp/ecojobs/jobs/Job\n*L\n94#1:453\n94#1:454,3\n104#1:457,9\n104#1:466\n104#1:468\n104#1:469\n194#1:470,2\n198#1:472,2\n262#1:474\n262#1:475,3\n264#1:478\n264#1:479,3\n268#1:482\n268#1:483,3\n270#1:486\n270#1:487,3\n275#1:490\n275#1:491,3\n104#1:467\n189#1:494,3\n*E\n"})
public final class Job
implements Registrable {
    @NotNull
    private final String id;
    @NotNull
    private final Config config;
    @NotNull
    private final EcoJobsPlugin plugin;
    private final Cache<Integer, LeaderboardCacheEntry> topCache;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    private final boolean isUnlockedByDefault;
    private final boolean resetsOnQuit;
    @NotNull
    private final ConfiguredPrice joinPrice;
    @NotNull
    private final ConfiguredPrice leavePrice;
    @NotNull
    private final PersistentDataKey<Integer> levelKey;
    @NotNull
    private final PersistentDataKey<Double> xpKey;
    @NotNull
    private final List<Integer> levelXpRequirements;
    private final int maxLevel;
    @NotNull
    private final JobLevelGUI levelGUI;
    @NotNull
    private final JobLeaveGUI leaveGUI;
    @NotNull
    private final ItemStack baseItem;
    @NotNull
    private final EffectList effects;
    @NotNull
    private final ConditionList conditions;
    private final Cache<Integer, JobLevel> levels;
    private final Cache<Integer, List<String>> effectsDescription;
    private final Cache<Integer, List<String>> rewardsDescription;
    private final Cache<Integer, List<String>> levelUpMessages;
    @NotNull
    private final Map<Integer, List<String>> levelCommands;
    @NotNull
    private final List<LevelPlaceholder> levelPlaceholders;
    @NotNull
    private final List<Counter> jobXpGains;

    /*
     * WARNING - void declaration
     */
    public Job(@NotNull String id, @NotNull Config config, @NotNull EcoJobsPlugin plugin) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ConfiguredPrice configuredPrice;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.id = id;
        this.config = config;
        this.plugin = plugin;
        this.topCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.plugin.getConfigYml().getInt("leaderboard-cache-lifetime"))).build();
        String string = this.config.getFormattedString("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormattedString(...)");
        this.name = string;
        String string2 = this.config.getFormattedString("description");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedString(...)");
        this.description = string2;
        this.isUnlockedByDefault = this.config.getBool("unlocked-by-default");
        this.resetsOnQuit = this.config.getBool("reset-on-quit");
        ConfiguredPrice configuredPrice2 = ConfiguredPrice.create((Config)this.config.getSubsection("join-price"));
        if (configuredPrice2 == null) {
            configuredPrice2 = this.joinPrice = new ConfiguredPrice((Price)new PriceEconomy(this.config.getDouble("join-price")), "");
        }
        if ((configuredPrice = ConfiguredPrice.create((Config)this.config.getSubsection("leave-price"))) == null) {
            configuredPrice = new ConfiguredPrice((Price)new PriceEconomy(this.config.getDouble("leave-price")), "");
        }
        this.leavePrice = configuredPrice;
        this.levelKey = new PersistentDataKey(EcoJobsPlugin.Companion.getInstance().getNamespacedKeyFactory().create(this.id + "_level"), PersistentDataKeyType.INT, (Object)(this.isUnlockedByDefault ? 1 : 0));
        this.xpKey = new PersistentDataKey(EcoJobsPlugin.Companion.getInstance().getNamespacedKeyFactory().create(this.id + "_xp"), PersistentDataKeyType.DOUBLE, (Object)0.0);
        Collection collection = CollectionsKt.listOf((Object)0);
        List list = this.config.getInts("level-xp-requirements");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInts(...)");
        this.levelXpRequirements = CollectionsKt.plus((Collection)collection, (Iterable)list);
        this.maxLevel = this.levelXpRequirements.size();
        this.levelGUI = new JobLevelGUI(this.plugin, this);
        this.leaveGUI = new JobLeaveGUI(this.plugin, this);
        ItemStack itemStack = Items.lookup((String)this.config.getString("icon")).getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        this.baseItem = itemStack;
        this.levels = Caffeine.newBuilder().build();
        this.effectsDescription = Caffeine.newBuilder().build();
        this.rewardsDescription = Caffeine.newBuilder().build();
        this.levelUpMessages = Caffeine.newBuilder().build();
        this.levelCommands = new LinkedHashMap();
        List list2 = this.config.getSubsections("level-placeholders");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSubsections(...)");
        Object object2 = (InjectablePlaceholder[])list2;
        Job job = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        String[] destination$iv$iv = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sub;
            object = (Config)item$iv$iv;
            String[] stringArray = destination$iv$iv;
            boolean bl = false;
            String string3 = sub.getString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            stringArray.add(new LevelPlaceholder(string3, (Function1<? super Integer, String>)((Function1)new Function1<Integer, String>((Config)sub){
                final /* synthetic */ Config $sub;
                {
                    this.$sub = $sub;
                    super(1);
                }

                @NotNull
                public final String invoke(int it) {
                    String string = this.$sub.getString("value");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    return StringUtilsExtensions.toNiceString((Object)NumberUtils.evaluateExpression((String)StringsKt.replace$default((String)string, (String)"%level%", (String)String.valueOf(it), (boolean)false, (int)4, null)));
                }
            })));
        }
        job.levelPlaceholders = (List)destination$iv$iv;
        List list3 = this.config.getSubsections("xp-gain-methods");
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSubsections(...)");
        $this$map$iv = list3;
        job = this;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        int $i$f$mapNotNullTo = 0;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Counter it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Config it = (Config)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (Counters.compile((Config)it, (ViolationContext)new ViolationContext((EcoPlugin)this.plugin, "Job " + this.id)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        job.jobXpGains = (List)destination$iv$iv;
        object2 = new InjectablePlaceholder[]{new PlayerStaticPlaceholder("level", arg_0 -> Job._init_$lambda$2(this, arg_0))};
        this.config.injectPlaceholders((InjectablePlaceholder[])object2);
        List list4 = this.config.getSubsections("effects");
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getSubsections(...)");
        this.effects = Effects.INSTANCE.compile((Collection)list4, new ViolationContext((EcoPlugin)this.plugin, "Job " + this.id));
        List list5 = this.config.getSubsections("conditions");
        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getSubsections(...)");
        this.conditions = Conditions.INSTANCE.compile((Collection)list5, new ViolationContext((EcoPlugin)this.plugin, "Job " + this.id));
        block2: for (String string4 : this.config.getStrings("level-commands")) {
            List commands;
            Intrinsics.checkNotNull((Object)string4);
            destination$iv$iv = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)string4, (String[])destination$iv$iv, (boolean)false, (int)0, (int)6, null);
            if (split.size() == 1) {
                int level = 1;
                $i$f$mapNotNullTo = this.maxLevel;
                if (level > $i$f$mapNotNullTo) continue;
                while (true) {
                    List list6;
                    if ((list6 = this.levelCommands.get(level)) == null) {
                        list6 = new ArrayList();
                    }
                    commands = list6;
                    commands.add((String)string4);
                    object = level;
                    this.levelCommands.put((Integer)object, commands);
                    if (level == $i$f$mapNotNullTo) continue block2;
                    ++level;
                }
            }
            int level = Integer.parseInt((String)split.get(0));
            String command = StringsKt.removePrefix((String)string4, (CharSequence)(level + ":"));
            List list7 = this.levelCommands.get(level);
            if (list7 == null) {
                list7 = new ArrayList();
            }
            commands = list7;
            commands.add((String)command);
            object = level;
            this.levelCommands.put((Integer)object, commands);
        }
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id + "_percentage_progress", arg_0 -> Job._init_$lambda$3(this, arg_0)).register();
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id, arg_0 -> Job._init_$lambda$4(this, arg_0)).register();
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id + "_current_xp", arg_0 -> Job._init_$lambda$5(this, arg_0)).register();
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id + "_required_xp", arg_0 -> Job._init_$lambda$6(this, arg_0)).register();
        new PlayerlessPlaceholder((EcoPlugin)this.plugin, this.id + "_name", () -> Job._init_$lambda$7(this)).register();
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id + "_level", arg_0 -> Job._init_$lambda$8(this, arg_0)).register();
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id + "_active", arg_0 -> Job._init_$lambda$9(this, arg_0)).register();
        new PlayerPlaceholder((EcoPlugin)this.plugin, this.id + "_total_players", arg_0 -> Job._init_$lambda$11(this, arg_0)).register();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final boolean isUnlockedByDefault() {
        return this.isUnlockedByDefault;
    }

    public final boolean getResetsOnQuit() {
        return this.resetsOnQuit;
    }

    @NotNull
    public final ConfiguredPrice getJoinPrice() {
        return this.joinPrice;
    }

    @NotNull
    public final ConfiguredPrice getLeavePrice() {
        return this.leavePrice;
    }

    @NotNull
    public final PersistentDataKey<Integer> getLevelKey() {
        return this.levelKey;
    }

    @NotNull
    public final PersistentDataKey<Double> getXpKey() {
        return this.xpKey;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    @NotNull
    public final JobLevelGUI getLevelGUI() {
        return this.levelGUI;
    }

    @NotNull
    public final JobLeaveGUI getLeaveGUI() {
        return this.leaveGUI;
    }

    public void onRegister() {
        Iterable $this$forEach$iv = this.jobXpGains;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Counter it = (Counter)element$iv;
            boolean bl = false;
            it.bind((Accumulator)new JobXPAccumulator(this));
        }
    }

    public void onRemove() {
        Iterable $this$forEach$iv = this.jobXpGains;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Counter it = (Counter)element$iv;
            boolean bl = false;
            it.unbind();
        }
    }

    @NotNull
    public final JobLevel getLevel(int level) {
        Object object = this.levels.get((Object)level, arg_0 -> Job.getLevel$lambda$14((Function1)new Function1<Integer, JobLevel>(this){
            final /* synthetic */ Job this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final JobLevel invoke(Integer it) {
                EcoPlugin ecoPlugin = Job.access$getPlugin$p(this.this$0);
                Intrinsics.checkNotNull((Object)it);
                return new JobLevel(ecoPlugin, this.this$0, it, Job.access$getEffects$p(this.this$0), Job.access$getConditions$p(this.this$0));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (JobLevel)object;
    }

    private final List<String> getLevelUpMessages(int level, int whitespace) {
        Object object = this.levelUpMessages.get((Object)level, arg_0 -> Job.getLevelUpMessages$lambda$15((Function1)new Function1<Integer, List<? extends String>>(this, level, whitespace){
            final /* synthetic */ Job this$0;
            final /* synthetic */ int $level;
            final /* synthetic */ int $whitespace;
            {
                this.this$0 = $receiver;
                this.$level = $level;
                this.$whitespace = $whitespace;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<String> invoke(Integer it) {
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                void it2;
                Collection collection;
                void $this$mapTo$iv$iv3;
                int highestConfiguredLevel = 1;
                List list = this.this$0.getConfig().getSubsection("level-up-messages").getKeys(false);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                Iterable $this$map$iv2 = list;
                int $i$f$map = 0;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    collection.add(Integer.parseInt((String)it2));
                }
                Object object = ((List)destination$iv$iv).iterator();
                while (object.hasNext()) {
                    int messagesLevel = ((Number)object.next()).intValue();
                    if (messagesLevel > this.$level || messagesLevel <= highestConfiguredLevel) continue;
                    highestConfiguredLevel = messagesLevel;
                }
                List list2 = this.this$0.getConfig().getStrings("level-up-messages." + highestConfiguredLevel);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                object = list2;
                Job job = this.this$0;
                $i$f$map = this.$level;
                boolean $i$f$map22 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it3;
                    String bl = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Collection collection2 = Job.access$getLevelPlaceholders$p(job);
                    Intrinsics.checkNotNull((Object)it3);
                    collection.add(JobKt.access$format(collection2, (String)it3, $i$f$map));
                }
                $this$map$iv = (List)destination$iv$iv2;
                int n = this.$whitespace;
                $i$f$map = 0;
                Iterable $i$f$map22 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object item$iv$iv2;
                    item$iv$iv2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(StringsKt.repeat((CharSequence)" ", (int)n) + (String)it2);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (List)object;
    }

    static /* synthetic */ List getLevelUpMessages$default(Job job, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return job.getLevelUpMessages(n, n2);
    }

    private final List<String> getEffectsDescription(int level, int whitespace) {
        Object object = this.effectsDescription.get((Object)level, arg_0 -> Job.getEffectsDescription$lambda$16((Function1)new Function1<Integer, List<? extends String>>(this, level, whitespace){
            final /* synthetic */ Job this$0;
            final /* synthetic */ int $level;
            final /* synthetic */ int $whitespace;
            {
                this.this$0 = $receiver;
                this.$level = $level;
                this.$whitespace = $whitespace;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<String> invoke(Integer it) {
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                void it2;
                Collection collection;
                void $this$mapTo$iv$iv3;
                int highestConfiguredLevel = 1;
                List list = this.this$0.getConfig().getSubsection("effects-description").getKeys(false);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                Iterable $this$map$iv2 = list;
                int $i$f$map = 0;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    collection.add(Integer.parseInt((String)it2));
                }
                Object object = ((List)destination$iv$iv).iterator();
                while (object.hasNext()) {
                    int messagesLevel = ((Number)object.next()).intValue();
                    if (messagesLevel > this.$level || messagesLevel <= highestConfiguredLevel) continue;
                    highestConfiguredLevel = messagesLevel;
                }
                List list2 = this.this$0.getConfig().getStrings("effects-description." + highestConfiguredLevel);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                object = list2;
                Job job = this.this$0;
                $i$f$map = this.$level;
                boolean $i$f$map22 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it3;
                    String bl = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Collection collection2 = Job.access$getLevelPlaceholders$p(job);
                    Intrinsics.checkNotNull((Object)it3);
                    collection.add(JobKt.access$format(collection2, (String)it3, $i$f$map));
                }
                $this$map$iv = (List)destination$iv$iv2;
                int n = this.$whitespace;
                $i$f$map = 0;
                Iterable $i$f$map22 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object item$iv$iv2;
                    item$iv$iv2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(StringsKt.repeat((CharSequence)" ", (int)n) + (String)it2);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (List)object;
    }

    static /* synthetic */ List getEffectsDescription$default(Job job, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return job.getEffectsDescription(n, n2);
    }

    private final List<String> getRewardsDescription(int level, int whitespace) {
        Object object = this.rewardsDescription.get((Object)level, arg_0 -> Job.getRewardsDescription$lambda$17((Function1)new Function1<Integer, List<? extends String>>(this, level, whitespace){
            final /* synthetic */ Job this$0;
            final /* synthetic */ int $level;
            final /* synthetic */ int $whitespace;
            {
                this.this$0 = $receiver;
                this.$level = $level;
                this.$whitespace = $whitespace;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<String> invoke(Integer it) {
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                void it2;
                Collection collection;
                void $this$mapTo$iv$iv3;
                int highestConfiguredLevel = 1;
                List list = this.this$0.getConfig().getSubsection("rewards-description").getKeys(false);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                Iterable $this$map$iv2 = list;
                int $i$f$map = 0;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    collection.add(Integer.parseInt((String)it2));
                }
                Object object = ((List)destination$iv$iv).iterator();
                while (object.hasNext()) {
                    int messagesLevel = ((Number)object.next()).intValue();
                    if (messagesLevel > this.$level || messagesLevel <= highestConfiguredLevel) continue;
                    highestConfiguredLevel = messagesLevel;
                }
                List list2 = this.this$0.getConfig().getStrings("rewards-description." + highestConfiguredLevel);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
                object = list2;
                Job job = this.this$0;
                $i$f$map = this.$level;
                boolean $i$f$map22 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it3;
                    String bl = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Collection collection2 = Job.access$getLevelPlaceholders$p(job);
                    Intrinsics.checkNotNull((Object)it3);
                    collection.add(JobKt.access$format(collection2, (String)it3, $i$f$map));
                }
                $this$map$iv = (List)destination$iv$iv2;
                int n = this.$whitespace;
                $i$f$map = 0;
                Iterable $i$f$map22 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object item$iv$iv2;
                    item$iv$iv2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(StringsKt.repeat((CharSequence)" ", (int)n) + (String)it2);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (List)object;
    }

    static /* synthetic */ List getRewardsDescription$default(Job job, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return job.getRewardsDescription(n, n2);
    }

    private final List<String> getLeaveLore(int level, int whitespace) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List list = this.config.getStrings("leave-lore");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Collection collection2 = this.levelPlaceholders;
            Intrinsics.checkNotNull((Object)it);
            collection.add(JobKt.access$format(collection2, it, level));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.repeat((CharSequence)" ", (int)whitespace) + it);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getLeaveLore$default(Job job, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return job.getLeaveLore(n, n2);
    }

    private final List<String> getJoinLore(int level, int whitespace) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List list = this.config.getStrings("join-lore");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Collection collection2 = this.levelPlaceholders;
            Intrinsics.checkNotNull((Object)it);
            collection.add(JobKt.access$format(collection2, it, level));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.repeat((CharSequence)" ", (int)whitespace) + it);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getJoinLore$default(Job job, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return job.getJoinLore(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> injectPlaceholdersInto(@NotNull List<String> lore, @NotNull Player player, @Nullable Integer forceLevel) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lore, (String)"lore");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$map$iv = lore;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void req;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = this.getExpForLevel(EcoJobsAPI.getJobLevel((OfflinePlayer)player, this) + 1);
            String string2 = "%required_xp%";
            String string3 = StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"%percentage_progress%", (String)StringUtilsExtensions.toNiceString((Object)(EcoJobsAPI.getJobProgress((OfflinePlayer)player, this) * (double)100)), (boolean)false, (int)4, null), (String)"%current_xp%", (String)StringUtilsExtensions.toNiceString((Object)EcoJobsAPI.getJobXP((OfflinePlayer)player, this)), (boolean)false, (int)4, null);
            boolean bl2 = false;
            String string4 = req == Integer.MAX_VALUE ? this.plugin.getLangYml().getFormattedString("infinity") : StringUtilsExtensions.toNiceString((Object)((int)req));
            Intrinsics.checkNotNull((Object)string4);
            String string5 = string4;
            Integer n2 = forceLevel;
            String string6 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)string2, (String)string5, (boolean)false, (int)4, null), (String)"%description%", (String)this.description, (boolean)false, (int)4, null), (String)"%job%", (String)this.name, (boolean)false, (int)4, null), (String)"%level%", (String)String.valueOf(n2 != null ? n2 : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this)), (boolean)false, (int)4, null);
            Integer n3 = forceLevel;
            String string7 = NumberUtils.toNumeral((int)(n3 != null ? n3 : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this)));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toNumeral(...)");
            String string8 = StringsKt.replace$default((String)string6, (String)"%level_numeral%", (String)string7, (boolean)false, (int)4, null);
            String string9 = this.joinPrice.getDisplay(player);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getDisplay(...)");
            String string10 = StringsKt.replace$default((String)string8, (String)"%join_price%", (String)string9, (boolean)false, (int)4, null);
            String string11 = this.leavePrice.getDisplay(player);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getDisplay(...)");
            collection.add(StringsKt.replace$default((String)string10, (String)"%leave_price%", (String)string11, (boolean)false, (int)4, null));
        }
        List withPlaceholders = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List processed = new ArrayList();
        for (String s : withPlaceholders) {
            List<String> list;
            int whitespace = s.length() - StringsKt.replace$default((String)s, (String)" ", (String)"", (boolean)false, (int)4, null).length();
            if (StringsKt.contains$default((CharSequence)s, (CharSequence)"%effects%", (boolean)false, (int)2, null)) {
                Integer n = forceLevel;
                list = this.getEffectsDescription(n != null ? n : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this), whitespace);
            } else if (StringsKt.contains$default((CharSequence)s, (CharSequence)"%rewards%", (boolean)false, (int)2, null)) {
                Integer n = forceLevel;
                list = this.getRewardsDescription(n != null ? n : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this), whitespace);
            } else if (StringsKt.contains$default((CharSequence)s, (CharSequence)"%level_up_messages%", (boolean)false, (int)2, null)) {
                Integer n = forceLevel;
                list = this.getLevelUpMessages(n != null ? n : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this), whitespace);
            } else if (StringsKt.contains$default((CharSequence)s, (CharSequence)"%leave_lore%", (boolean)false, (int)2, null)) {
                Integer n = forceLevel;
                list = this.getLeaveLore(n != null ? n : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this), whitespace);
            } else if (StringsKt.contains$default((CharSequence)s, (CharSequence)"%join_lore%", (boolean)false, (int)2, null)) {
                Integer n = forceLevel;
                list = this.getJoinLore(n != null ? n : EcoJobsAPI.getJobLevel((OfflinePlayer)player, this), whitespace);
            } else {
                list = CollectionsKt.listOf((Object)s);
            }
            processed.add(list);
        }
        return StringUtilsExtensions.formatEco$default((List)CollectionsKt.flatten((Iterable)processed), (Player)player, (boolean)false, (int)2, null);
    }

    public static /* synthetic */ List injectPlaceholdersInto$default(Job job, List list, Player player, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return job.injectPlaceholdersInto(list, player, n);
    }

    @NotNull
    public final ItemStack getIcon(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.baseItem.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack base = itemStack;
        int level = EcoJobsAPI.getJobLevel((OfflinePlayer)player, this);
        ItemStackBuilder itemStackBuilder = new ItemStackBuilder(base);
        String string = this.plugin.getConfigYml().getFormattedString("gui.job-icon.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormattedString(...)");
        String string2 = StringsKt.replace$default((String)string, (String)"%level%", (String)String.valueOf(level), (boolean)false, (int)4, null);
        String string3 = NumberUtils.toNumeral((int)level);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toNumeral(...)");
        ItemStack itemStack2 = ((ItemStackBuilder)((ItemStackBuilder)itemStackBuilder.setDisplayName(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"%level_numeral%", (String)string3, (boolean)false, (int)4, null), (String)"%job%", (String)this.name, (boolean)false, (int)4, null))).addLoreLines(() -> Job.getIcon$lambda$24(this, player))).build();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"build(...)");
        return itemStack2;
    }

    @NotNull
    public final ItemStack getJobInfoIcon(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.baseItem.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack base = itemStack;
        ItemStackBuilder itemStackBuilder = new ItemStackBuilder(base);
        String string = this.plugin.getConfigYml().getFormattedString("gui.job-info.active.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormattedString(...)");
        String string2 = StringsKt.replace$default((String)string, (String)"%level%", (String)String.valueOf(EcoJobsAPI.getJobLevel((OfflinePlayer)player, this)), (boolean)false, (int)4, null);
        String string3 = NumberUtils.toNumeral((int)EcoJobsAPI.getJobLevel((OfflinePlayer)player, this));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toNumeral(...)");
        ItemStack itemStack2 = ((ItemStackBuilder)((ItemStackBuilder)itemStackBuilder.setDisplayName(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"%level_numeral%", (String)string3, (boolean)false, (int)4, null), (String)"%job%", (String)this.name, (boolean)false, (int)4, null))).addLoreLines(() -> Job.getJobInfoIcon$lambda$25(this, player))).build();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"build(...)");
        return itemStack2;
    }

    public final int getExpForLevel(int level) {
        if (level < 1 || level > this.maxLevel) {
            return Integer.MAX_VALUE;
        }
        Integer n = this.levelXpRequirements.get(level - 1);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        return ((Number)n).intValue();
    }

    public final void executeLevelCommands(@NotNull Player player, int level) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List list = this.levelCommands.get(level);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List commands = list;
        for (String command : commands) {
            CommandSender commandSender = (CommandSender)Bukkit.getConsoleSender();
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Bukkit.dispatchCommand((CommandSender)commandSender, (String)StringsKt.replace$default((String)command, (String)"%player%", (String)string, (boolean)false, (int)4, null));
        }
    }

    @Nullable
    public final LeaderboardCacheEntry getTop(int place) {
        return (LeaderboardCacheEntry)this.topCache.get((Object)place, arg_0 -> Job.getTop$lambda$26((Function1)new Function1<Integer, LeaderboardCacheEntry>(place, this){
            final /* synthetic */ int $place;
            final /* synthetic */ Job this$0;
            {
                this.$place = $place;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final LeaderboardCacheEntry invoke(Integer it) {
                void $this$sortedByDescending$iv;
                OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
                Intrinsics.checkNotNullExpressionValue((Object)offlinePlayerArray, (String)"getOfflinePlayers(...)");
                Object[] objectArray = offlinePlayerArray;
                Job job = this.this$0;
                boolean $i$f$sortedByDescending = false;
                List players = ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(job){
                    final /* synthetic */ Job this$0;
                    {
                        this.this$0 = job;
                    }

                    public final int compare(T a, T b) {
                        OfflinePlayer it = (OfflinePlayer)b;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        Comparable comparable = Integer.valueOf(EcoJobsAPI.getJobLevel(it, this.this$0));
                        it = (OfflinePlayer)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(EcoJobsAPI.getJobLevel(it, this.this$0)));
                    }
                });
                OfflinePlayer offlinePlayer = (OfflinePlayer)CollectionsKt.getOrNull((List)players, (int)(this.$place - 1));
                if (offlinePlayer == null) {
                    return null;
                }
                OfflinePlayer target = offlinePlayer;
                return new LeaderboardCacheEntry(target, EcoJobsAPI.getJobLevel(target, this.this$0));
            }
        }, arg_0));
    }

    @NotNull
    public String getID() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Job)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)((Job)other).id);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.id};
        return Objects.hash(objectArray);
    }

    private static final String _init_$lambda$2(Job this$0, Player p) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)p);
        return String.valueOf(EcoJobsAPI.getJobLevel((OfflinePlayer)p, this$0));
    }

    private static final String _init_$lambda$3(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return StringUtilsExtensions.toNiceString((Object)(EcoJobsAPI.getJobProgress((OfflinePlayer)it, this$0) * (double)100));
    }

    private static final String _init_$lambda$4(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return String.valueOf(EcoJobsAPI.getJobLevel((OfflinePlayer)it, this$0));
    }

    private static final String _init_$lambda$5(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return NumberUtils.format((double)EcoJobsAPI.getJobXP((OfflinePlayer)it, this$0));
    }

    private static final String _init_$lambda$6(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return String.valueOf(EcoJobsAPI.getJobXPRequired((OfflinePlayer)it, this$0));
    }

    private static final String _init_$lambda$7(Job this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.name;
    }

    private static final String _init_$lambda$8(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return String.valueOf(EcoJobsAPI.getJobLevel((OfflinePlayer)it, this$0));
    }

    private static final String _init_$lambda$9(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return String.valueOf(EcoJobsAPI.hasJobActive((OfflinePlayer)it, this$0));
    }

    private static final String _init_$lambda$11(Job this$0, Player it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayerArray, (String)"getOfflinePlayers(...)");
        Object[] $this$count$iv = offlinePlayerArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            OfflinePlayer it2 = (OfflinePlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            if (!EcoJobsAPI.getActiveJobs(it2).contains(this$0)) continue;
            ++count$iv;
        }
        return String.valueOf(count$iv);
    }

    private static final JobLevel getLevel$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JobLevel)$tmp0.invoke(p0);
    }

    private static final List getLevelUpMessages$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List getEffectsDescription$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List getRewardsDescription$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List getIcon$lambda$24(Job this$0, Player $player) {
        List list;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        List list2 = this$0.plugin.getConfigYml().getStrings("gui.job-icon.lore");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStrings(...)");
        Collection collection = Job.injectPlaceholdersInto$default(this$0, list2, $player, null, 4, null);
        if (EcoJobsAPI.hasJobActive((OfflinePlayer)$player, this$0)) {
            List list3 = this$0.plugin.getConfigYml().getStrings("gui.job-icon.active-lore");
            Intrinsics.checkNotNull((Object)list3);
            list = list3;
        } else if (EcoJobsAPI.canJoinJob($player, this$0)) {
            List list4 = this$0.plugin.getConfigYml().getStrings("gui.job-icon.join-lore");
            Intrinsics.checkNotNull((Object)list4);
            list = list4;
        } else if (EcoJobsAPI.getActiveJobs((OfflinePlayer)$player).size() == EcoJobsAPI.getJobLimit($player)) {
            List list5 = this$0.plugin.getConfigYml().getStrings("gui.job-icon.too-many-jobs-lore");
            Intrinsics.checkNotNull((Object)list5);
            list = list5;
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    private static final List getJobInfoIcon$lambda$25(Job this$0, Player $player) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        List list = this$0.plugin.getConfigYml().getStrings("gui.job-info.active.lore");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        return Job.injectPlaceholdersInto$default(this$0, list, $player, null, 4, null);
    }

    private static final LeaderboardCacheEntry getTop$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LeaderboardCacheEntry)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ EcoJobsPlugin access$getPlugin$p(Job $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ EffectList access$getEffects$p(Job $this) {
        return $this.effects;
    }

    public static final /* synthetic */ ConditionList access$getConditions$p(Job $this) {
        return $this.conditions;
    }

    public static final /* synthetic */ List access$getLevelPlaceholders$p(Job $this) {
        return $this.levelPlaceholders;
    }
}

