/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecojobs.api;

import com.willfp.eco.core.data.PlayerProfile;
import com.willfp.eco.core.data.ProfileExtensions;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.ecojobs.EcoJobsPlugin;
import com.willfp.ecojobs.api.event.PlayerJobExpGainEvent;
import com.willfp.ecojobs.api.event.PlayerJobJoinEvent;
import com.willfp.ecojobs.api.event.PlayerJobLeaveEvent;
import com.willfp.ecojobs.api.event.PlayerJobLevelUpEvent;
import com.willfp.ecojobs.jobs.Job;
import com.willfp.ecojobs.jobs.JobKt;
import com.willfp.ecojobs.jobs.Jobs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0017\u0010\u0017\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0018*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0017\u0010\u001b\u001a\u00070\u001a\u00a2\u0006\u0002\b\u0018*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010\u001c\u001a\u00020\u000e*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u001a\u0010\u001d\u001a\u00020\u0016*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001a\u001a&\u0010\u001f\u001a\u00020\u0016*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001a2\b\b\u0002\u0010 \u001a\u00020\u0013H\u0007\u001a\u0012\u0010!\u001a\u00020\u0013*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010\"\u001a\u00020\u0013*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010#\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010$\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u0012\u0010%\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t\u001a\u001a\u0010&\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u000e\u001a\u001a\u0010(\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u001a\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"activeJobsKey", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "", "", "legacyActiveJobKey", "plugin", "Lcom/willfp/ecojobs/EcoJobsPlugin;", "activeJobs", "", "Lcom/willfp/ecojobs/jobs/Job;", "Lorg/bukkit/OfflinePlayer;", "getActiveJobs", "(Lorg/bukkit/OfflinePlayer;)Ljava/util/Collection;", "jobLimit", "", "Lorg/bukkit/entity/Player;", "getJobLimit", "(Lorg/bukkit/entity/Player;)I", "canJoinJob", "", "job", "forceLeaveJob", "", "getJobLevel", "Lorg/jetbrains/annotations/NotNull;", "getJobProgress", "", "getJobXP", "getJobXPRequired", "giveExactJobExperience", "experience", "giveJobExperience", "withMultipliers", "hasJob", "hasJobActive", "joinJob", "leaveJob", "resetJob", "setJobLevel", "level", "setJobXP", "xp", "core-plugin"})
@JvmName(name="EcoJobsAPI")
@SourceDebugExtension(value={"SMAP\nEcoJobsAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoJobsAPI.kt\ncom/willfp/ecojobs/api/EcoJobsAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1603#2,9:194\n1855#2:203\n1856#2:205\n1612#2:206\n1549#2:207\n1620#2,3:208\n1549#2:211\n1620#2,3:212\n1#3:204\n*S KotlinDebug\n*F\n+ 1 EcoJobsAPI.kt\ncom/willfp/ecojobs/api/EcoJobsAPI\n*L\n73#1:194,9\n73#1:203\n73#1:205\n73#1:206\n85#1:207\n85#1:208,3\n109#1:211\n109#1:212,3\n73#1:204\n*E\n"})
public final class EcoJobsAPI {
    @NotNull
    private static final EcoJobsPlugin plugin = EcoJobsPlugin.Companion.getInstance();
    @NotNull
    private static final PersistentDataKey<String> legacyActiveJobKey = new PersistentDataKey(plugin.getNamespacedKeyFactory().create("active_job"), PersistentDataKeyType.STRING, (Object)"");
    @NotNull
    private static final PersistentDataKey<List<String>> activeJobsKey = new PersistentDataKey(plugin.getNamespacedKeyFactory().create("active_jobs"), PersistentDataKeyType.STRING_LIST, (Object)CollectionsKt.emptyList());

    public static final int getJobLimit(@NotNull Player $this$jobLimit) {
        Intrinsics.checkNotNullParameter((Object)$this$jobLimit, (String)"<this>");
        return (int)JobKt.getNumericalPermission($this$jobLimit, "ecojobs.limit", plugin.getConfigYml().getDouble("jobs.limit"));
    }

    public static final boolean canJoinJob(@NotNull Player $this$canJoinJob, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$canJoinJob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return EcoJobsAPI.getActiveJobs((OfflinePlayer)$this$canJoinJob).size() < EcoJobsAPI.getJobLimit($this$canJoinJob) && !EcoJobsAPI.getActiveJobs((OfflinePlayer)$this$canJoinJob).contains(job) && EcoJobsAPI.hasJob((OfflinePlayer)$this$canJoinJob, job);
    }

    public static final boolean hasJob(@NotNull OfflinePlayer $this$hasJob, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return EcoJobsAPI.getJobLevel($this$hasJob, job) > 0;
    }

    public static final boolean hasJobActive(@NotNull OfflinePlayer $this$hasJobActive, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJobActive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return EcoJobsAPI.getActiveJobs($this$hasJobActive).contains(job);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Job> getActiveJobs(@NotNull OfflinePlayer $this$activeJobs) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$activeJobs, (String)"<this>");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)$this$activeJobs).read(legacyActiveJobKey);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        if (!StringsKt.isBlank((CharSequence)((CharSequence)object))) {
            ProfileExtensions.getProfile((OfflinePlayer)$this$activeJobs).write(activeJobsKey, (Object)CollectionsKt.listOf((Object)ProfileExtensions.getProfile((OfflinePlayer)$this$activeJobs).read(legacyActiveJobKey)));
            ProfileExtensions.getProfile((OfflinePlayer)$this$activeJobs).write(legacyActiveJobKey, (Object)"");
        }
        Object object2 = ProfileExtensions.getProfile((OfflinePlayer)$this$activeJobs).read(activeJobsKey);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"read(...)");
        Iterable $this$mapNotNull$iv = (Iterable)object2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Job it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (Jobs.getByID(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final void joinJob(@NotNull OfflinePlayer $this$joinJob, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$joinJob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        PlayerJobJoinEvent event = new PlayerJobJoinEvent($this$joinJob, job);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.plus(EcoJobsAPI.getActiveJobs($this$joinJob), (Object)job);
            PersistentDataKey<List<String>> persistentDataKey = activeJobsKey;
            PlayerProfile playerProfile = ProfileExtensions.getProfile((OfflinePlayer)$this$joinJob);
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Job job2 = (Job)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            collection = (List)destination$iv$iv;
            playerProfile.write(persistentDataKey, (Object)collection);
        }
    }

    public static final void leaveJob(@NotNull OfflinePlayer $this$leaveJob, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$leaveJob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        if (!EcoJobsAPI.getActiveJobs($this$leaveJob).contains(job)) {
            return;
        }
        PlayerJobLeaveEvent event = new PlayerJobLeaveEvent($this$leaveJob, job);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            EcoJobsAPI.forceLeaveJob($this$leaveJob, job);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void forceLeaveJob(@NotNull OfflinePlayer $this$forceLeaveJob, @NotNull Job job) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$forceLeaveJob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Iterable iterable = CollectionsKt.minus((Iterable)EcoJobsAPI.getActiveJobs($this$forceLeaveJob), (Object)job);
        PersistentDataKey<List<String>> persistentDataKey = activeJobsKey;
        PlayerProfile playerProfile = ProfileExtensions.getProfile((OfflinePlayer)$this$forceLeaveJob);
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Job job2 = (Job)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        playerProfile.write(persistentDataKey, (Object)collection);
    }

    public static final int getJobLevel(@NotNull OfflinePlayer $this$getJobLevel, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$getJobLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)$this$getJobLevel).read(job.getLevelKey());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        return ((Number)object).intValue();
    }

    public static final void setJobLevel(@NotNull OfflinePlayer $this$setJobLevel, @NotNull Job job, int level) {
        Intrinsics.checkNotNullParameter((Object)$this$setJobLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        ProfileExtensions.getProfile((OfflinePlayer)$this$setJobLevel).write(job.getLevelKey(), (Object)level);
    }

    public static final double getJobXP(@NotNull OfflinePlayer $this$getJobXP, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$getJobXP, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Object object = ProfileExtensions.getProfile((OfflinePlayer)$this$getJobXP).read(job.getXpKey());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        return ((Number)object).doubleValue();
    }

    public static final void setJobXP(@NotNull OfflinePlayer $this$setJobXP, @NotNull Job job, double xp) {
        Intrinsics.checkNotNullParameter((Object)$this$setJobXP, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        ProfileExtensions.getProfile((OfflinePlayer)$this$setJobXP).write(job.getXpKey(), (Object)xp);
    }

    public static final void resetJob(@NotNull OfflinePlayer $this$resetJob, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$resetJob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        EcoJobsAPI.setJobLevel($this$resetJob, job, 1);
        EcoJobsAPI.setJobXP($this$resetJob, job, 0.0);
    }

    public static final int getJobXPRequired(@NotNull OfflinePlayer $this$getJobXPRequired, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$getJobXPRequired, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return job.getExpForLevel(EcoJobsAPI.getJobLevel($this$getJobXPRequired, job) + 1);
    }

    public static final double getJobProgress(@NotNull OfflinePlayer $this$getJobProgress, @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)$this$getJobProgress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        double currentXP = EcoJobsAPI.getJobXP($this$getJobProgress, job);
        int requiredXP = job.getExpForLevel(EcoJobsAPI.getJobLevel($this$getJobProgress, job) + 1);
        return currentXP / (double)requiredXP;
    }

    @JvmOverloads
    public static final void giveJobExperience(@NotNull Player $this$giveJobExperience, @NotNull Job job, double experience, boolean withMultipliers) {
        Intrinsics.checkNotNullParameter((Object)$this$giveJobExperience, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        double exp = Math.abs(withMultipliers ? experience * JobKt.getJobExperienceMultiplier($this$giveJobExperience) : experience);
        PlayerJobExpGainEvent gainEvent = new PlayerJobExpGainEvent($this$giveJobExperience, job, exp, !withMultipliers);
        Bukkit.getPluginManager().callEvent((Event)gainEvent);
        if (gainEvent.isCancelled()) {
            return;
        }
        EcoJobsAPI.giveExactJobExperience($this$giveJobExperience, job, gainEvent.getAmount());
    }

    public static /* synthetic */ void giveJobExperience$default(Player player, Job job, double d, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        EcoJobsAPI.giveJobExperience(player, job, d, bl);
    }

    public static final void giveExactJobExperience(@NotNull Player $this$giveExactJobExperience, @NotNull Job job, double experience) {
        Intrinsics.checkNotNullParameter((Object)$this$giveExactJobExperience, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        int level = EcoJobsAPI.getJobLevel((OfflinePlayer)$this$giveExactJobExperience, job);
        double progress = EcoJobsAPI.getJobXP((OfflinePlayer)$this$giveExactJobExperience, job) + experience;
        if (progress >= (double)job.getExpForLevel(level + 1) && level + 1 <= job.getMaxLevel()) {
            double overshoot = progress - (double)job.getExpForLevel(level + 1);
            EcoJobsAPI.setJobXP((OfflinePlayer)$this$giveExactJobExperience, job, 0.0);
            EcoJobsAPI.setJobLevel((OfflinePlayer)$this$giveExactJobExperience, job, level + 1);
            PlayerJobLevelUpEvent levelUpEvent = new PlayerJobLevelUpEvent($this$giveExactJobExperience, job, level + 1);
            Bukkit.getPluginManager().callEvent((Event)levelUpEvent);
            EcoJobsAPI.giveExactJobExperience($this$giveExactJobExperience, job, overshoot);
        } else {
            EcoJobsAPI.setJobXP((OfflinePlayer)$this$giveExactJobExperience, job, progress);
        }
    }

    @JvmOverloads
    public static final void giveJobExperience(@NotNull Player $this$giveJobExperience, @NotNull Job job, double experience) {
        Intrinsics.checkNotNullParameter((Object)$this$giveJobExperience, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        EcoJobsAPI.giveJobExperience$default($this$giveJobExperience, job, experience, false, 4, null);
    }
}

