/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazyenchantments.paper.tasks.processors;

import com.badbones69.crazyenchantments.paper.CrazyEnchantments;
import com.badbones69.crazyenchantments.paper.Methods;
import com.badbones69.crazyenchantments.paper.Starter;
import com.badbones69.crazyenchantments.paper.api.enums.CEnchantments;
import com.badbones69.crazyenchantments.paper.api.objects.CEnchantment;
import com.badbones69.crazyenchantments.paper.api.utils.EnchantUtils;
import com.badbones69.crazyenchantments.paper.controllers.settings.EnchantmentBookSettings;
import com.badbones69.crazyenchantments.paper.support.PluginSupport;
import com.badbones69.crazyenchantments.paper.tasks.processors.PoolProcessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorProcessor
extends PoolProcessor {
    private final CrazyEnchantments plugin = (CrazyEnchantments)JavaPlugin.getPlugin(CrazyEnchantments.class);
    private final Starter starter = this.plugin.getStarter();
    private final Methods methods = this.starter.getMethods();
    private final PluginSupport pluginSupport = this.starter.getPluginSupport();
    private final EnchantmentBookSettings enchantmentBookSettings = this.starter.getEnchantmentBookSettings();

    public void add(UUID id) {
        this.add(() -> this.process(id));
    }

    public void process(UUID playerId) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return;
        }
        for (ItemStack armor : Objects.requireNonNull(player.getEquipment()).getArmorContents()) {
            Map<CEnchantment, Integer> enchantments = this.enchantmentBookSettings.getEnchantments(armor);
            if (enchantments.isEmpty()) continue;
            int heal = 1;
            double maxHealth = Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue();
            if (maxHealth > player.getHealth() && player.getHealth() > 0.0) {
                this.checkNursery(armor, player, enchantments, heal, maxHealth);
            }
            if (player.getFoodLevel() < 20) {
                this.checkImplants(armor, player, enchantments);
            }
            this.checkCommander(armor, player, enchantments);
            if (PluginSupport.SupportedPlugins.FACTIONS_UUID.isPluginLoaded()) {
                int radius = 4 + enchantments.get(CEnchantments.ANGEL.getEnchantment());
                this.checkAngel(armor, player, enchantments, radius);
            }
            this.useHellForge(player, armor, enchantments);
        }
        PlayerInventory inv = player.getInventory();
        this.useHellForge(player, inv.getItemInMainHand(), this.enchantmentBookSettings.getEnchantments(inv.getItemInMainHand()));
        this.useHellForge(player, inv.getItemInOffHand(), this.enchantmentBookSettings.getEnchantments(inv.getItemInOffHand()));
    }

    private void checkCommander(ItemStack armor, Player player, Map<CEnchantment, Integer> enchantments) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.COMMANDER, player, enchantments)) {
            return;
        }
        int radius = 4 + enchantments.get(CEnchantments.COMMANDER.getEnchantment());
        player.getScheduler().run((Plugin)this.plugin, playerTask -> {
            if (EnchantUtils.normalEnchantEvent(CEnchantments.COMMANDER, (Entity)player, armor)) {
                PotionEffect fastDigging = new PotionEffect(PotionEffectType.MINING_FATIGUE, 60, 1);
                for (Entity e : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                    e.getScheduler().run((Plugin)this.plugin, task -> {
                        Player otherPlayer;
                        if (e instanceof Player && this.pluginSupport.isFriendly((Entity)player, (Entity)(otherPlayer = (Player)e))) {
                            otherPlayer.addPotionEffect(fastDigging);
                        }
                    }, null);
                }
            }
        }, null);
    }

    private void checkAngel(ItemStack armor, Player player, Map<CEnchantment, Integer> enchantments, int radius) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.ANGEL, player, enchantments)) {
            return;
        }
        player.getScheduler().run((Plugin)this.plugin, playerTask -> {
            if (!EnchantUtils.normalEnchantEvent(CEnchantments.ANGEL, (Entity)player, armor)) {
                return;
            }
            ArrayList players = new ArrayList();
            for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
                entity.getScheduler().run((Plugin)this.plugin, task -> {
                    Player otherPlayer;
                    if (entity instanceof Player && this.pluginSupport.isFriendly((Entity)player, (Entity)(otherPlayer = (Player)entity))) {
                        players.add(otherPlayer);
                    }
                }, null);
            }
            if (players.isEmpty()) {
                return;
            }
            PotionEffect regeneration = new PotionEffect(PotionEffectType.REGENERATION, 60, 0);
            for (Player p : players) {
                p.getScheduler().run((Plugin)this.plugin, task -> p.addPotionEffect(regeneration), null);
            }
        }, null);
    }

    private void checkImplants(ItemStack armor, Player player, Map<CEnchantment, Integer> enchantments) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.IMPLANTS, player, enchantments)) {
            return;
        }
        player.getScheduler().run((Plugin)this.plugin, playerTask -> {
            if (EnchantUtils.normalEnchantEvent(CEnchantments.IMPLANTS, (Entity)player, armor)) {
                player.setFoodLevel(Math.min(20, player.getFoodLevel() + (Integer)enchantments.get(CEnchantments.IMPLANTS.getEnchantment())));
            }
        }, null);
    }

    private void checkNursery(ItemStack armor, Player player, Map<CEnchantment, Integer> enchantments, int heal, double maxHealth) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.NURSERY, player, enchantments)) {
            return;
        }
        player.getScheduler().run((Plugin)this.plugin, playerTask -> {
            if (EnchantUtils.normalEnchantEvent(CEnchantments.NURSERY, (Entity)player, armor)) {
                if (player.getHealth() + (double)heal <= maxHealth) {
                    player.setHealth(player.getHealth() + (double)heal);
                }
                if (player.getHealth() + (double)heal >= maxHealth) {
                    player.setHealth(maxHealth);
                }
            }
        }, null);
    }

    private void useHellForge(Player player, ItemStack item, Map<CEnchantment, Integer> enchantments) {
        if (!EnchantUtils.isMoveEventActive(CEnchantments.HELLFORGED, player, enchantments)) {
            return;
        }
        player.getScheduler().run((Plugin)this.plugin, playerTask -> {
            if (!EnchantUtils.normalEnchantEvent(CEnchantments.HELLFORGED, (Entity)player, item)) {
                return;
            }
            int armorDurability = this.methods.getDurability(item);
            if (armorDurability <= 0) {
                return;
            }
            int finalArmorDurability = armorDurability;
            this.methods.setDurability(item, finalArmorDurability -= ((Integer)enchantments.get(CEnchantments.HELLFORGED.getEnchantment())).intValue());
        }, null);
    }
}

